/*
 * Decompiled with CFR 0.152.
 */
package jme.controller;

import java.util.logging.Level;
import jme.controller.AbstractGameController;
import jme.entity.Entity;
import jme.entity.camera.Camera;
import jme.exception.MonkeyRuntimeException;
import jme.math.Distance;
import jme.math.Vector;
import jme.physics.PhysicsModule;
import jme.system.KeyBindingManager;
import jme.utility.LoggingSystem;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class TrackingController
extends AbstractGameController {
    private double trackingDistance;
    private float trackingSpeed;
    private Vector targetView;
    private Camera camera;
    private PhysicsModule physics;
    protected KeyBindingManager key;

    public TrackingController(Entity entity, Camera camera) {
        if (null == entity || null == camera) {
            throw new MonkeyRuntimeException("Entity and camera may not be null.");
        }
        this.entity = entity;
        this.camera = camera;
        this.physics = entity.getPhysics();
        try {
            Mouse.create();
            Keyboard.create();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Error creating Mouse and/or Keyboard");
        }
        this.setDefaultKeyBindings();
    }

    public void render() {
        this.camera.render();
    }

    public boolean update(float f) {
        Keyboard.poll();
        this.camera.update(f);
        this.camera.updateFrustum();
        this.targetView = this.entity.getPosition();
        this.updateCameraView();
        double d = Distance.distancePointPoint(this.camera.getPosition(), this.entity.getPosition());
        if (d > this.trackingDistance) {
            Vector vector = this.camera.getView().subtract(this.camera.getPosition()).normalize();
            this.camera.getPosition().x += vector.x * this.trackingSpeed * (f / 200.0f);
            this.camera.getPosition().z += vector.z * this.trackingSpeed * (f / 200.0f);
            this.camera.getPosition().y = this.entity.getPosition().y;
        }
        if (null != this.physics) {
            if (this.isKeyDown("forward")) {
                this.physics.move(1.0f);
            }
            if (this.isKeyDown("back")) {
                this.physics.move(-0.5f);
            }
            if (this.isKeyDown("right")) {
                this.physics.turn(-1.0f);
                this.entity.setYaw(this.physics.getCurrentAngle());
            } else if (this.isKeyDown("left")) {
                this.physics.turn(1.0f);
                this.entity.setYaw(this.physics.getCurrentAngle());
            } else {
                this.physics.turn(0.0f);
            }
        }
        return this.checkAdditionalKeys();
    }

    public void setTrackingDistance(float f) {
        this.trackingDistance = f;
    }

    public void setTrackingSpeed(float f) {
        this.trackingSpeed = f;
    }

    protected boolean checkAdditionalKeys() {
        if (this.isKeyDown("exit")) {
            System.out.println("EXIT");
            return false;
        }
        return true;
    }

    private void updateCameraView() {
        this.camera.setView(this.targetView);
    }

    private void setDefaultKeyBindings() {
        this.key = KeyBindingManager.getKeyBindingManager();
        this.key.set("exit", 1);
        this.key.set("forward", 17);
        this.key.set("right", 32);
        this.key.set("left", 30);
        this.key.set("back", 31);
        this.key.add("forward", 200);
        this.key.add("right", 205);
        this.key.add("left", 203);
    }
}

