/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.imageSelect;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Properties;

public class ImageSelectControl
implements Controller {
    private Nifty nifty;
    private Screen screen;
    private Element element;
    private ArrayList<NiftyImage> images;
    private int currentImageIndex;

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, ControllerEventListener newListener, Attributes controlDefinitionAttributes) {
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.element = newElement;
        this.images = this.createImages(this.nifty.getRenderEngine(), properties.getProperty("imageList"));
        this.currentImageIndex = 0;
        this.updateVisuals();
    }

    private void updateVisuals() {
        if (this.images.isEmpty()) {
            return;
        }
        NiftyImage currentImage = this.images.get(this.currentImageIndex);
        ((ImageRenderer)this.element.findElementByName("image").getRenderer(ImageRenderer.class)).setImage(currentImage);
        this.element.findElementByName("image").setConstraintWidth(new SizeValue(currentImage.getWidth() + "px"));
        this.element.findElementByName("image").setConstraintHeight(new SizeValue(currentImage.getHeight() + "px"));
        this.element.findElementByName("image").layoutElements();
        if (this.currentImageIndex == 0) {
            this.element.findElementByName("back").hide();
        } else {
            this.element.findElementByName("back").show();
        }
        if (this.currentImageIndex == this.images.size() - 1) {
            this.element.findElementByName("forward").hide();
        } else {
            this.element.findElementByName("forward").show();
        }
    }

    private ArrayList<NiftyImage> createImages(NiftyRenderEngine renderDevice, String property) {
        ArrayList<NiftyImage> imageList = new ArrayList<NiftyImage>();
        if (property != null && property.length() > 0) {
            String[] imageStrings;
            for (String imageString : imageStrings = property.split(",")) {
                imageList.add(renderDevice.createImage(imageString, false));
            }
        }
        return imageList;
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void backClick() {
        if (this.currentImageIndex > 0) {
            --this.currentImageIndex;
            this.updateVisuals();
        }
    }

    public void forwardClick() {
        if (this.currentImageIndex < this.images.size() - 1) {
            ++this.currentImageIndex;
            this.updateVisuals();
        }
    }

    public void addImage(NiftyImage image) {
        this.images.add(image);
        this.updateVisuals();
    }
}

