/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs.elements;

import de.lessvoid.xml.lwxs.Schema;
import de.lessvoid.xml.lwxs.XmlType;
import de.lessvoid.xml.lwxs.elements.OccursEnum;
import de.lessvoid.xml.lwxs.elements.Type;
import de.lessvoid.xml.lwxs.elements.XmlProcessorElement;
import de.lessvoid.xml.lwxs.elements.XmlProcessorType;
import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.SubstitutionGroup;
import de.lessvoid.xml.xpp3.XmlParser;
import de.lessvoid.xml.xpp3.XmlProcessor;

public class Element {
    private final String tagName;
    private final String tagType;
    private final OccursEnum occurs;

    public Element(String elementNameParam, String elementTypeParam, OccursEnum elementOccursParam) throws Exception {
        if (elementNameParam == null) {
            throw new Exception("elementName can't be null");
        }
        if (elementTypeParam == null) {
            throw new Exception("elementType can't be null");
        }
        if (elementOccursParam == null) {
            throw new Exception("elementOccursParam can't be null");
        }
        this.tagName = elementNameParam;
        this.tagType = elementTypeParam;
        this.occurs = elementOccursParam;
    }

    public void addToProcessor(Schema schema, XmlProcessorType processor) throws Exception {
        Type type = schema.getType(this.tagType);
        if (type == null) {
            throw new Exception("type [" + this.tagType + "] not found");
        }
        type.addChildren(schema, processor, this.tagName, this.tagType, this.occurs);
        Type typeParent = type.getTypeParent(schema);
        if (typeParent != null) {
            typeParent.addChildren(schema, processor, this.tagName, this.tagType, this.occurs);
        }
    }

    public void addToSubstGroup(Schema schema, SubstitutionGroup substitutionGroup, XmlType xmlType) throws Exception {
        Type type = schema.getType(this.tagType);
        if (type == null) {
            throw new Exception("type [" + this.tagType + "] not found");
        }
        Type typeParent = type.getTypeParent(schema);
        if (typeParent != null) {
            XmlProcessorElement xmlProcessorElement = new XmlProcessorElement(typeParent.createXmlProcessorFromType(schema, type), this.tagName, this.tagType, this.occurs);
            substitutionGroup.add(this.getTagName(), new Helper(xmlType, xmlProcessorElement));
        } else {
            XmlProcessorElement xmlProcessorElement = new XmlProcessorElement(type.createXmlProcessor(schema), this.tagName, this.tagType, this.occurs);
            substitutionGroup.add(this.getTagName(), new Helper(xmlType, xmlProcessorElement));
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    private class Helper
    implements XmlProcessor {
        private final XmlType xmlTypeParent;
        private final XmlProcessorElement xmlProcessorElement;

        public Helper(XmlType xmlTypeParam, XmlProcessorElement xmlProcessorElementParam) {
            this.xmlTypeParent = xmlTypeParam;
            this.xmlProcessorElement = xmlProcessorElementParam;
        }

        @Override
        public void process(XmlParser xmlParser, Attributes attributes) throws Exception {
            this.xmlProcessorElement.processSubstGroup(xmlParser, this.xmlTypeParent, attributes);
        }
    }
}

