/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.screen;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyStopwatch;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.DefaultScreenController;
import de.lessvoid.nifty.screen.EndOfScreenAction;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.MouseOverHandler;
import de.lessvoid.nifty.screen.NullScreenController;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.NullObjectFactory;
import de.lessvoid.nifty.tools.StringHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Screen {
    public int layoutLayersCallCount = 0;
    private static Logger log = Logger.getLogger(Screen.class.getName());
    private String screenId;
    private ScreenController screenController = new NullScreenController();
    private boolean screenControllerBound = false;
    private ArrayList<Element> layerElements = new ArrayList();
    private LinkedList<Element> layerElementsToAdd = new LinkedList();
    private LinkedList<Element> layerElementsToRemove = new LinkedList();
    private ArrayList<Element> popupElements = new ArrayList();
    private LinkedList<Element> popupElementsToAdd = new LinkedList();
    private LinkedList<ElementWithEndNotify> popupElementsToRemove = new LinkedList();
    private TimeProvider timeProvider;
    private FocusHandler focusHandler;
    private MouseOverHandler mouseOverHandler;
    private Nifty nifty;
    private List<InputHandlerWithMapping> postInputHandlers = new ArrayList<InputHandlerWithMapping>();
    private List<InputHandlerWithMapping> preInputHandlers = new ArrayList<InputHandlerWithMapping>();
    private Element rootElement;
    private String defaultFocusElementId;
    private boolean running = false;
    private Set<String> registeredIds = new HashSet<String>();
    private boolean bound;

    public Screen(Nifty newNifty, String newId, ScreenController newScreenController, TimeProvider newTimeProvider) {
        this.nifty = newNifty;
        this.screenId = newId;
        this.screenController = newScreenController;
        if (this.screenController == null) {
            log.warning("Missing ScreenController for screen [" + newId + "] using DefaultScreenController() instead but this might not be what you want.");
            this.screenController = new DefaultScreenController();
        }
        this.timeProvider = newTimeProvider;
        this.focusHandler = new FocusHandler();
        this.mouseOverHandler = new MouseOverHandler();
    }

    public void registerElementId(String id) {
        if (id != null && this.registeredIds.contains(id)) {
            log.warning("Possible conflicting id [" + id + "] detected. Consider making all Ids unique or use #id in control-definitions.");
        } else {
            this.registeredIds.add(id);
        }
    }

    public void unregisterElementId(String id) {
        this.registeredIds.remove(id);
    }

    public String getScreenId() {
        return this.screenId;
    }

    public List<Element> getLayerElements() {
        return this.layerElements;
    }

    public void addLayerElement(Element layerElement) {
        this.layerElementsToAdd.add(layerElement);
    }

    public void removeLayerElement(Element layerElement) {
        this.layerElementsToRemove.add(layerElement);
    }

    public void removeLayerElement(String layerId) {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            if (!layer.getId().equals(layerId)) continue;
            this.removeLayerElement(layer);
            return;
        }
    }

    public void addPopup(Element popup, Element defaultFocusElement) {
        EndNotify localEndNotify = new EndNotify(){

            @Override
            public final void perform() {
                for (int i = 0; i < Screen.this.layerElements.size(); ++i) {
                    Element w = (Element)Screen.this.layerElements.get(i);
                    if (!w.isEffectActive(EffectEventId.onStartScreen)) continue;
                    return;
                }
            }
        };
        Element mouseFocusElement = this.focusHandler.getMouseFocusElement();
        if (mouseFocusElement != null) {
            mouseFocusElement.stopEffect(EffectEventId.onHover);
        }
        this.focusHandler.pushState();
        popup.resetEffects();
        popup.layoutElements();
        popup.initControls(true);
        popup.startEffect(EffectEventId.onStartScreen, localEndNotify);
        popup.startEffect(EffectEventId.onActive);
        popup.onStartScreen();
        if (defaultFocusElement != null) {
            defaultFocusElement.setFocus();
        } else {
            this.setDefaultFocus();
        }
        this.addLayerElement(popup);
        this.addPopupElement(popup);
    }

    void addPopupElement(Element popup) {
        this.popupElementsToAdd.add(popup);
    }

    public void closePopup(Element popup, EndNotify closeNotify) {
        popup.onEndScreen(this);
        this.nifty.resetMouseInputEvents();
        this.removeLayerElement(popup);
        this.schedulePopupElementRemoval(new ElementWithEndNotify(popup, closeNotify));
    }

    private void schedulePopupElementRemoval(ElementWithEndNotify elementWithEndNotify) {
        this.popupElementsToRemove.add(elementWithEndNotify);
    }

    public void startScreen() {
        this.startScreen(null);
    }

    public void startScreen(EndNotify startScreenEndNotify) {
        NiftyStopwatch.start();
        this.running = false;
        this.nifty.getRenderEngine().screenStarted(this);
        this.focusHandler.resetFocusElements();
        this.resetLayers();
        this.layoutLayers();
        this.bindControls();
        if (!this.screenControllerBound) {
            this.screenController.bind(this.nifty, this);
            this.screenControllerBound = true;
        }
        this.activeEffectStart();
        StartScreenEndNotify endNotify = this.createScreenStartEndNotify(startScreenEndNotify);
        this.startLayers(EffectEventId.onStartScreen, endNotify);
        this.setDefaultFocus();
        NiftyStopwatch.stop("Screen.startScreen(" + this.layoutLayersCallCount + ")");
    }

    public void endScreen(EndNotify callback) {
        this.resetLayers();
        EndScreenEndNotify endNotify = this.createScreenEndNotify(callback);
        this.startLayers(EffectEventId.onEndScreen, endNotify);
    }

    public void layoutLayers() {
        NiftyStopwatch.start();
        ++this.layoutLayersCallCount;
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element w = this.layerElements.get(i);
            w.layoutElements();
        }
        NiftyStopwatch.stop("Screen.layoutLayers()");
    }

    private void resetLayers() {
        this.nifty.resetMouseInputEvents();
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element w = this.layerElements.get(i);
            w.resetEffects();
            w.reactivate();
        }
    }

    private void startLayers(EffectEventId effectEventId, EndNotify endNotify) {
        LocalEndNotify localEndNotify = new LocalEndNotify(effectEventId, endNotify);
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element w = this.layerElements.get(i);
            w.startEffect(effectEventId, localEndNotify);
            if (effectEventId != EffectEventId.onStartScreen) continue;
            w.onStartScreen();
        }
        localEndNotify.enable();
        localEndNotify.perform();
    }

    public void setDefaultFocus() {
        Element defaultFocus;
        if (this.focusHandler.getKeyboardFocusElement() != null) {
            return;
        }
        if (this.defaultFocusElementId != null && (defaultFocus = this.getFocusHandler().findElement(this.defaultFocusElementId)) != null) {
            defaultFocus.setFocus();
            return;
        }
        Element firstFocus = this.getFocusHandler().getFirstFocusElement();
        if (firstFocus != null) {
            firstFocus.setFocus();
        }
    }

    private void activeEffectStart() {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element w = this.layerElements.get(i);
            w.startEffect(EffectEventId.onActive, null);
            if (w.isEnabled()) continue;
            w.startEffect(EffectEventId.onDisabled, null);
        }
    }

    public final void renderLayers(NiftyRenderEngine renderDevice) {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            layer.render(renderDevice);
        }
    }

    public void resetLayout() {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            layer.resetLayout();
        }
    }

    public boolean mouseEvent(NiftyMouseInputEvent inputEvent) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("screen mouseEvent: " + inputEvent.toString());
        }
        if (!this.popupElements.isEmpty()) {
            return this.forwardMouseEventToLayers(this.popupElements, inputEvent);
        }
        return this.forwardMouseEventToLayers(this.layerElements, inputEvent);
    }

    private boolean forwardMouseEventToLayers(List<Element> layerList, NiftyMouseInputEvent inputEvent) {
        this.mouseOverHandler.reset();
        long eventTime = this.timeProvider.getMsTime();
        if (this.focusHandler.hasAnyElementTheMouseFocus()) {
            Element e = this.focusHandler.getMouseFocusElement();
            this.mouseOverHandler.addMouseOverElement(e);
        } else {
            for (int i = 0; i < layerList.size(); ++i) {
                Element layer = layerList.get(i);
                layer.buildMouseOverElements(inputEvent, eventTime, this.mouseOverHandler);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.fine(this.mouseOverHandler.getInfoString());
        }
        this.mouseOverHandler.processMouseOverEvent(this.rootElement, inputEvent, eventTime);
        this.mouseOverHandler.processMouseEvent(inputEvent, eventTime);
        return this.mouseOverHandler.hitsElement();
    }

    public Element findElementByName(String name) {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            Element found = layer.findElementByName(name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public <T extends Controller> T findControl(String elementName, Class<T> requestedControlClass) {
        Element element = this.findElementByName(elementName);
        if (element == null) {
            return null;
        }
        return element.getControl(requestedControlClass);
    }

    public <T extends NiftyControl> T findNiftyControl(String elementName, Class<T> requestedControlClass) {
        Element element = this.findElementByName(elementName);
        if (element == null) {
            log.warning("missing element/control with id [" + elementName + "] for requested control class [" + requestedControlClass.getName() + "]");
            return NullObjectFactory.createNull(requestedControlClass);
        }
        return element.getNiftyControl(requestedControlClass);
    }

    public void setAlternateKey(String alternateKey) {
        for (int i = 0; i < this.layerElements.size(); ++i) {
            Element layer = this.layerElements.get(i);
            layer.setAlternateKey(alternateKey);
        }
    }

    public boolean keyEvent(KeyboardInputEvent inputEvent) {
        InputHandlerWithMapping handler;
        int i;
        for (i = 0; i < this.preInputHandlers.size(); ++i) {
            handler = this.preInputHandlers.get(i);
            if (!handler.process(inputEvent)) continue;
            return true;
        }
        if (this.focusHandler.keyEvent(inputEvent)) {
            return true;
        }
        for (i = 0; i < this.postInputHandlers.size(); ++i) {
            handler = this.postInputHandlers.get(i);
            if (!handler.process(inputEvent)) continue;
            return true;
        }
        return false;
    }

    public void addKeyboardInputHandler(NiftyInputMapping mapping, KeyInputHandler handler) {
        this.postInputHandlers.add(new InputHandlerWithMapping(mapping, handler));
    }

    public void removeKeyboardInputHandler(KeyInputHandler handler) {
        for (int i = 0; i < this.postInputHandlers.size(); ++i) {
            if (!this.postInputHandlers.get(i).getKeyInputHandler().equals(handler)) continue;
            this.postInputHandlers.remove(i);
            return;
        }
    }

    public void addPreKeyboardInputHandler(NiftyInputMapping mapping, KeyInputHandler handler) {
        this.preInputHandlers.add(new InputHandlerWithMapping(mapping, handler));
    }

    public void removePreKeyboardInputHandler(KeyInputHandler handler) {
        for (int i = 0; i < this.preInputHandlers.size(); ++i) {
            if (!this.preInputHandlers.get(i).getKeyInputHandler().equals(handler)) continue;
            this.preInputHandlers.remove(i);
            return;
        }
    }

    public String debugOutput() {
        return this.debugOutput(".*", ".*");
    }

    public String debugOutputFocusElements() {
        StringBuffer result = new StringBuffer();
        result.append(this.focusHandler.toString());
        return result.toString();
    }

    public String debugOutput(String regexpElement, String regexpAttribute) {
        StringBuffer result = new StringBuffer();
        this.debugOutputLayerElements(regexpElement, regexpAttribute, result, this.layerElements);
        result.append("\n\n### popupElements: " + this.popupElements.size());
        this.debugOutputLayerElements(regexpElement, regexpAttribute, result, this.popupElements);
        result.append(this.focusHandler.toString());
        return result.toString();
    }

    private void debugOutputLayerElements(String regexpElement, String regexpAttribute, StringBuffer result, ArrayList<Element> layers) {
        for (int i = 0; i < layers.size(); ++i) {
            Element layer = layers.get(i);
            String layerType = " +";
            if (!layer.isVisible()) {
                layerType = " -";
            }
            result.append("\n" + layerType + this.getIdText(layer) + "\n" + StringHelper.whitespace(layerType.length()) + layer.getElementStateString(StringHelper.whitespace(layerType.length()), regexpAttribute));
            result.append(this.outputElement(layer, "   ", regexpElement, regexpAttribute));
        }
    }

    public String outputElement(Element w, String offset, String regexpElement, String regexpAttribute) {
        StringBuffer result = new StringBuffer();
        List<Element> wwElements = w.getElements();
        for (int i = 0; i < wwElements.size(); ++i) {
            Element ww = wwElements.get(i);
            String elementId = this.getIdText(ww);
            if (elementId.matches(regexpElement)) {
                result.append("\n" + offset + elementId + " " + ww.getElementType().getClass().getSimpleName() + " childLayout [" + ww.getElementType().getAttributes().get("childLayout") + "]");
                result.append("\n" + StringHelper.whitespace(offset.length()) + ww.getElementStateString(StringHelper.whitespace(offset.length()), regexpAttribute));
                result.append(this.outputElement(ww, offset + " ", ".*", regexpAttribute));
                continue;
            }
            result.append(this.outputElement(ww, offset + " ", regexpElement, regexpAttribute));
        }
        return result.toString();
    }

    private String getIdText(Element ww) {
        String id = ww.getId();
        if (id == null) {
            return "[---]";
        }
        return "[" + id + "]";
    }

    public ScreenController getScreenController() {
        return this.screenController;
    }

    public FocusHandler getFocusHandler() {
        return this.focusHandler;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(Element rootElementParam) {
        this.rootElement = rootElementParam;
    }

    public void processAddAndRemoveLayerElements() {
        this.layerElements.addAll(this.layerElementsToAdd);
        this.layerElements.removeAll(this.layerElementsToRemove);
        this.layerElementsToAdd.clear();
        this.layerElementsToRemove.clear();
        this.popupElements.addAll(this.popupElementsToAdd);
        this.popupElementsToAdd.clear();
        while (!this.popupElementsToRemove.isEmpty()) {
            ElementWithEndNotify e = this.popupElementsToRemove.remove(0);
            e.remove();
        }
    }

    public boolean hasDynamicElements() {
        return !this.layerElementsToAdd.isEmpty() || !this.layerElementsToRemove.isEmpty() || !this.popupElementsToAdd.isEmpty() || !this.popupElementsToRemove.isEmpty();
    }

    public void setDefaultFocusElement(String defaultFocusElementIdParam) {
        this.defaultFocusElementId = defaultFocusElementIdParam;
    }

    public String getDefaultFocusElementId() {
        return this.defaultFocusElementId;
    }

    StartScreenEndNotify createScreenStartEndNotify(EndNotify startScreenEndNotify) {
        return new StartScreenEndNotify(startScreenEndNotify);
    }

    EndScreenEndNotify createScreenEndNotify(EndNotify endScreenEndNotify) {
        return new EndScreenEndNotify(endScreenEndNotify);
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isNull() {
        return false;
    }

    void onStartScreenHasEnded() {
        this.nifty.subscribeAnnotations(this.screenController);
        this.screenController.onStartScreen();
        this.nifty.addControls();
        this.running = true;
    }

    void onEndScreenHasEnded() {
        log.fine("onEndScreenHasEnded()");
        this.nifty.unsubscribeAnnotations(this.screenController);
        this.nifty.unsubscribeScreen(this);
        this.screenController.onEndScreen();
        for (int i = 0; i < this.layerElements.size(); ++i) {
            this.layerElements.get(i).onEndScreen(this);
        }
        this.nifty.getRenderEngine().screenEnded(this);
    }

    public boolean isEffectActive(EffectEventId effectEventId) {
        if (!this.popupElements.isEmpty()) {
            return this.isEffectActive(this.popupElements, effectEventId);
        }
        return this.isEffectActive(this.layerElements, effectEventId);
    }

    private boolean isEffectActive(List<Element> elements, EffectEventId effectEventId) {
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            if (!element.isEffectActive(effectEventId)) continue;
            return true;
        }
        return false;
    }

    public Element getTopMostPopup() {
        if (this.popupElements.isEmpty()) {
            return null;
        }
        return this.popupElements.get(this.popupElements.size() - 1);
    }

    public boolean isActivePopup(String id) {
        for (int i = 0; i < this.popupElements.size(); ++i) {
            if (!id.equals(this.popupElements.get(i).getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isActivePopup(Element element) {
        return this.popupElements.contains(element);
    }

    public boolean isMouseOverElement() {
        return this.mouseOverHandler.hitsElement();
    }

    public String getMouseOverInfoString() {
        return this.mouseOverHandler.getInfoString();
    }

    private void bindControls() {
        int i;
        this.bound = true;
        for (i = 0; i < this.layerElements.size(); ++i) {
            this.layerElements.get(i).bindControls(this);
        }
        for (i = 0; i < this.layerElements.size(); ++i) {
            this.layerElements.get(i).initControls(false);
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public void resetMouseDown() {
        for (Element layer : this.layerElements) {
            layer.resetMouseDown();
        }
    }

    public class ElementWithEndNotify {
        private Element element;
        private EndNotify closeNotify;

        public ElementWithEndNotify(Element element, EndNotify closeNotify) {
            this.element = element;
            this.closeNotify = closeNotify;
        }

        public void remove() {
            Screen.this.popupElements.remove(this.element);
            Screen.this.focusHandler.popState();
            if (this.closeNotify != null) {
                this.closeNotify.perform();
            }
        }
    }

    public class InputHandlerWithMapping {
        private NiftyInputMapping mapping;
        private KeyInputHandler handler;

        public InputHandlerWithMapping(NiftyInputMapping newMapping, KeyInputHandler newHandler) {
            this.mapping = newMapping;
            this.handler = newHandler;
        }

        public KeyInputHandler getKeyInputHandler() {
            return this.handler;
        }

        public boolean process(KeyboardInputEvent inputEvent) {
            return this.handler.keyEvent(this.mapping.convert(inputEvent));
        }
    }

    class EndScreenEndNotify
    implements EndNotify {
        private EndNotify additionalEndNotify;

        public EndScreenEndNotify(EndNotify additionalEndNotify) {
            this.additionalEndNotify = additionalEndNotify;
        }

        @Override
        public void perform() {
            log.fine("onEndScreen has ended - schedule further processing as end of frame action");
            Screen.this.nifty.scheduleEndOfFrameElementAction(Screen.this, null, new EndOfScreenAction(), this.additionalEndNotify);
        }
    }

    class StartScreenEndNotify
    implements EndNotify {
        private EndNotify additionalEndNotify;

        public StartScreenEndNotify(EndNotify additionalEndNotify) {
            this.additionalEndNotify = additionalEndNotify;
        }

        @Override
        public void perform() {
            log.fine("onStartScreen has ended");
            if (this.additionalEndNotify != null) {
                this.additionalEndNotify.perform();
            }
            Screen.this.onStartScreenHasEnded();
        }
    }

    private class LocalEndNotify
    implements EndNotify {
        private boolean enabled = false;
        private EffectEventId effectEventId = null;
        private EndNotify endNotify = null;

        public LocalEndNotify(EffectEventId effectEventIdParam, EndNotify endNotifyParam) {
            this.effectEventId = effectEventIdParam;
            this.endNotify = endNotifyParam;
        }

        public void enable() {
            this.enabled = true;
        }

        @Override
        public void perform() {
            if (this.enabled) {
                for (int i = 0; i < Screen.this.layerElements.size(); ++i) {
                    Element w = (Element)Screen.this.layerElements.get(i);
                    if (!w.isEffectActive(this.effectEventId)) continue;
                    return;
                }
                if (this.endNotify != null) {
                    this.endNotify.perform();
                }
            }
        }
    }
}

