/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlAttributes;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.mapping.DefaultInputMapping;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.loaderv2.types.EffectsType;
import de.lessvoid.nifty.loaderv2.types.InteractType;
import de.lessvoid.nifty.loaderv2.types.StyleType;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.loaderv2.types.helper.CollectionLogger;
import de.lessvoid.nifty.loaderv2.types.helper.ElementRendererCreator;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolver;
import de.lessvoid.nifty.loaderv2.types.resolver.style.StyleResolverControlDefinintion;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.StringHelper;
import de.lessvoid.xml.tools.ClassHelper;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class ElementType
extends XmlBaseType {
    protected String tagName;
    protected ElementRendererCreator elementRendererCreator;
    protected InteractType interact = new InteractType();
    protected EffectsType effects = new EffectsType();
    protected List<ElementType> elements = new ArrayList<ElementType>(0);
    protected LinkedList<Object> controllers = new LinkedList();
    protected Controller controller;

    public ElementType() {
    }

    public ElementType(ElementType src) {
        super(src);
        this.tagName = src.tagName;
        this.elementRendererCreator = src.elementRendererCreator;
        this.interact = new InteractType(src.interact);
        this.effects = new EffectsType(src.effects);
        this.copyElements(src);
    }

    public ElementType(Attributes attributes) {
        super(attributes);
    }

    void mergeFromElementType(ElementType src) {
        this.tagName = src.tagName;
        this.elementRendererCreator = src.elementRendererCreator;
        this.mergeFromAttributes(src.getAttributes());
        this.interact.mergeFromInteractType(src.getInteract());
        this.effects.mergeFromEffectsType(src.getEffects());
        this.copyElements(src);
    }

    void copyElements(ElementType src) {
        this.elements.clear();
        for (ElementType element : src.elements) {
            this.elements.add(element.copy());
        }
    }

    public ElementType copy() {
        return new ElementType(this);
    }

    void setElementRendererCreator(ElementRendererCreator elementRendererCreatorParam) {
        this.elementRendererCreator = elementRendererCreatorParam;
    }

    void setTagName(String tagNameParam) {
        this.tagName = tagNameParam;
    }

    protected void makeFlat() {
        for (ElementType element : this.elements) {
            element.makeFlat();
        }
    }

    public boolean hasElements() {
        return !this.elements.isEmpty();
    }

    public ElementType getFirstElement() {
        return this.elements.iterator().next();
    }

    public void addElementType(ElementType type) {
        this.elements.add(type);
    }

    public void addPanel(ElementType panel) {
        this.elements.add(panel);
    }

    public void addImage(ElementType image) {
        this.elements.add(image);
    }

    public void addLabel(ElementType label) {
        this.elements.add(label);
    }

    public void addText(ElementType text) {
        this.elements.add(text);
    }

    public void addControl(ElementType text) {
        this.elements.add(text);
    }

    public void setInteract(InteractType interactParam) {
        this.interact = interactParam;
    }

    public void setEffect(EffectsType effectsParam) {
        this.effects = effectsParam;
    }

    @Override
    public String output(int offset) {
        String result = StringHelper.whitespace(offset) + this.tagName + " [element] " + super.output(offset);
        if (this.interact != null) {
            result = result + "\n" + this.interact.output(offset + 1);
        }
        if (this.effects != null) {
            result = result + "\n" + this.effects.output(offset + 1);
        }
        result = result + "\n" + CollectionLogger.out(offset + 1, this.elements, "elements");
        return result;
    }

    public Element create(Element parent, Nifty nifty, Screen screen, LayoutPart layoutPart) {
        Element element = this.internalCreateElement(parent, nifty, screen, layoutPart, this.getAttributes());
        this.applyStandard(nifty, screen, element);
        return element;
    }

    private Element internalCreateElement(Element parent, Nifty nifty, Screen screen, LayoutPart layoutPart, Attributes attrib) {
        Element element = new Element(nifty, this, attrib.get("id"), parent, layoutPart, screen.getFocusHandler(), false, nifty.getTimeProvider(), this.elementRendererCreator.createElementRenderer(nifty));
        parent.add(element);
        return element;
    }

    private void applyStandard(Nifty nifty, Screen screen, Element element) {
        this.applyAttributes(screen, element, this.getAttributes(), nifty.getRenderEngine());
        this.applyEffects(nifty, screen, element);
        this.applyInteract(nifty, screen, element);
        this.applyChildren(element, screen, nifty);
        this.enforceChildLayout(this.getAttributes(), this.elements.size());
        this.applyPostAttributes(element, this.getAttributes(), nifty.getRenderEngine());
        if (this.controller != null) {
            NiftyInputControl niftyInputControl = this.createNiftyInputControl(element.getId(), this.getAttributes(), this.controller);
            element.attachInputControl(niftyInputControl);
        }
    }

    private void enforceChildLayout(Attributes attributes, int childCount) {
        if (!attributes.isSet("childLayout") && childCount > 0) {
            throw new RuntimeException("missing childLayout attribute for an element with [" + childCount + "] child elements. Attributes of error element [" + attributes.toString() + "]");
        }
    }

    LinkedList<Object> getControllersWithScreenController(Screen screen) {
        LinkedList<Object> withScreenController = new LinkedList<Object>(this.controllers);
        withScreenController.addLast(screen.getScreenController());
        return withScreenController;
    }

    private Controller createLocalController(String controllerClassParam) {
        if (controllerClassParam == null) {
            return null;
        }
        return ClassHelper.getInstance(controllerClassParam, Controller.class);
    }

    private NiftyInputControl createNiftyInputControl(String elementId, Attributes controlDefinitionAttributes, Controller controller) {
        String inputMappingClass = controlDefinitionAttributes.get("inputMapping");
        if (inputMappingClass == null) {
            inputMappingClass = DefaultInputMapping.class.getName();
        }
        NiftyInputMapping inputMapping = ClassHelper.getInstance(inputMappingClass, NiftyInputMapping.class);
        return new NiftyInputControl(controller, inputMapping);
    }

    public void applyAttributes(Screen screen, Element element, Attributes work, NiftyRenderEngine renderEngine) {
        if (work == null) {
            return;
        }
        element.initializeFromAttributes(screen, work, renderEngine);
    }

    public void applyPostAttributes(Element element, Attributes work, NiftyRenderEngine renderEngine) {
        if (work == null) {
            return;
        }
        element.initializeFromPostAttributes(work);
    }

    public void applyEffects(Nifty nifty, Screen screen, Element element) {
        if (this.effects != null) {
            this.effects.materialize(nifty, element, screen, this.getControllersWithScreenController(screen));
        }
    }

    public void applyInteract(Nifty nifty, Screen screen, Element element) {
        if (this.interact != null) {
            this.interact.materialize(nifty, element, this.getControllersWithScreenController(screen).toArray());
        }
    }

    protected void applyChildren(Element parent, Screen screen, Nifty nifty) {
        for (ElementType elementType : this.elements) {
            elementType.create(parent, nifty, screen, new LayoutPart());
        }
    }

    public void refreshAttributes(Nifty nifty, Screen screen, Element element, ControlAttributes attributes) {
        Attributes attrib = new Attributes(this.getAttributes());
        attributes.refreshAttributes(attrib);
        this.applyAttributes(screen, element, attrib, nifty.getRenderEngine());
        this.applyPostAttributes(element, attrib, nifty.getRenderEngine());
        attributes.refreshEffects(this.effects);
        screen.layoutLayers();
    }

    public InteractType getInteract() {
        return this.interact;
    }

    public EffectsType getEffects() {
        return this.effects;
    }

    public Collection<ElementType> getElements() {
        return this.elements;
    }

    public void prepare(Nifty nifty, Screen screen, ElementType rootElementType) {
        this.translateSpecialValues(nifty, screen);
        this.makeFlat();
        this.applyControls(nifty);
        this.applyStyles(nifty.getDefaultStyleResolver());
        this.resolveParameters(rootElementType.getAttributes());
        this.makeFlatControls();
        this.translateSpecialValues(nifty, screen);
        this.resolveControllers(new LinkedList<Object>());
    }

    @Override
    public void translateSpecialValues(Nifty nifty, Screen screen) {
        super.translateSpecialValues(nifty, screen);
        this.interact.translateSpecialValues(nifty, screen);
        this.effects.translateSpecialValues(nifty, screen);
        for (ElementType e : this.elements) {
            e.translateSpecialValues(nifty, screen);
        }
    }

    void resolveParameters(Attributes parentAttributes) {
        this.getAttributes().resolveParameters(parentAttributes);
        Attributes newParent = new Attributes(parentAttributes);
        newParent.merge(this.getAttributes());
        this.interact.resolveParameters(newParent);
        this.effects.resolveParameters(newParent);
        for (ElementType elementType : this.elements) {
            elementType.resolveParameters(newParent);
        }
    }

    void applyControls(Nifty nifty) {
        this.internalApplyControl(nifty);
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).applyControls(nifty);
        }
    }

    void internalApplyControl(Nifty nifty) {
    }

    void makeFlatControls() {
        for (ElementType elementType : this.elements) {
            elementType.makeFlatControls();
        }
        this.makeFlatControlsInternal();
    }

    void makeFlatControlsInternal() {
    }

    public void applyStyles(StyleResolver styleResolver) {
        StyleResolver childStyleResolver = this.applyStyleInternal(styleResolver);
        for (ElementType elementType : this.elements) {
            elementType.applyStyles(childStyleResolver);
        }
    }

    StyleResolver applyStyleInternal(StyleResolver styleResolver) {
        String style = this.getAttributes().get("style");
        if (style != null) {
            StyleType styleType = styleResolver.resolve(style);
            if (styleType != null) {
                styleType.applyTo(this, styleResolver);
            }
            if (!style.startsWith("#")) {
                return new StyleResolverControlDefinintion(styleResolver, style);
            }
        }
        return styleResolver;
    }

    void resolveControllers(LinkedList<Object> controllerParam) {
        this.controllers = new LinkedList<Object>(controllerParam);
        this.controller = this.createLocalController(this.getAttributes().get("controller"));
        if (this.controller != null) {
            this.controllers.addFirst(this.controller);
        }
        for (ElementType elementType : this.elements) {
            elementType.resolveControllers(this.controllers);
        }
    }

    public void removeWithTag(String styleId) {
        this.getAttributes().removeWithTag(styleId);
        this.effects.removeWithTag(styleId);
        this.interact.getAttributes().removeWithTag(styleId);
    }

    public void connectParentControls(Element parent) {
        Controller controller;
        if (parent == null) {
            return;
        }
        NiftyInputControl control = parent.getAttachedInputControl();
        if (control != null && (controller = control.getController()) != null) {
            this.controllers.addLast(controller);
        }
        this.connectParentControls(parent.getParent());
    }
}

