/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.batch;

import de.lessvoid.nifty.batch.TextureAtlasGenerator;
import de.lessvoid.nifty.batch.TextureAtlasGeneratorException;
import de.lessvoid.nifty.batch.spi.BatchRenderBackend;
import de.lessvoid.nifty.spi.render.RenderImage;
import java.util.logging.Logger;

public class BatchRenderImage
implements RenderImage {
    private static final Logger log = Logger.getLogger(BatchRenderImage.class.getName());
    private final TextureAtlasGenerator generator;
    private final String filename;
    private final BatchRenderBackend renderBackend;
    private final BatchRenderBackend.Image image;
    private int x;
    private int y;
    private boolean uploaded;

    public BatchRenderImage(BatchRenderBackend.Image image, TextureAtlasGenerator generator, String filename, BatchRenderBackend renderBackend) {
        this.image = image;
        this.generator = generator;
        this.filename = filename;
        this.renderBackend = renderBackend;
        this.x = 0;
        this.y = 0;
        this.uploaded = false;
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public void dispose() {
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void upload() {
        if (this.uploaded) {
            return;
        }
        try {
            TextureAtlasGenerator.Result result = this.generator.addImage(this.image.getWidth(), this.image.getHeight(), this.filename, 5);
            this.renderBackend.addImageToTexture(this.image, result.getX(), result.getY());
            this.x = result.getX();
            this.y = result.getY();
            this.uploaded = true;
            log.finer("image [" + this.filename + "] uploaded (texture atlas)");
        }
        catch (TextureAtlasGeneratorException e) {
            log.severe("Image [" + this.filename + "] did not fit into the texture atlas and will be missing in your screen");
        }
    }

    public void unload() {
        if (!this.uploaded) {
            return;
        }
        TextureAtlasGenerator.Result result = this.generator.removeImage(this.filename);
        this.renderBackend.removeFromTexture(this.image, result.getX(), result.getY(), result.getOriginalImageWidth(), result.getOriginalImageHeight());
        this.uploaded = false;
        log.finer("image [" + this.filename + "] unloaded (texture atlas)");
    }

    public boolean isUploaded() {
        return this.uploaded;
    }

    public void markAsUnloaded() {
        this.uploaded = false;
        log.finer("image [" + this.filename + "] marked as unloaded (texture atlas)");
    }

    public String toString() {
        return super.toString() + " {" + this.filename + "}";
    }
}

