/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.textfield;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.TextFieldChangedEvent;
import de.lessvoid.nifty.controls.textfield.InputCharFilterWrapper;
import de.lessvoid.nifty.controls.textfield.InputCharSequenceFilterWrapper;
import de.lessvoid.nifty.controls.textfield.TextFieldLogic;
import de.lessvoid.nifty.controls.textfield.TextFieldView;
import de.lessvoid.nifty.controls.textfield.filter.delete.TextFieldDeleteFilter;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptDigits;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptFloat;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptLetters;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptLowerCase;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptNegativeDigits;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptRegex;
import de.lessvoid.nifty.controls.textfield.filter.input.FilterAcceptUpperCase;
import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputCharFilter;
import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputCharSequenceFilter;
import de.lessvoid.nifty.controls.textfield.filter.input.TextFieldInputFilter;
import de.lessvoid.nifty.controls.textfield.format.FormatPassword;
import de.lessvoid.nifty.controls.textfield.format.TextFieldDisplayFormat;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.elements.tools.FontHelper;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

@Deprecated
public class TextFieldControl
extends AbstractController
implements TextField,
TextFieldView {
    private Nifty nifty;
    private Screen screen;
    private Element textElement;
    private Element fieldElement;
    private Element cursorElement;
    private TextFieldLogic textField;
    private int firstVisibleCharacterIndex;
    private int lastVisibleCharacterIndex;
    private int fieldWidth;
    private int fromClickCursorPos;
    private int toClickCursorPos;
    private FocusHandler focusHandler;

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, Attributes controlDefinitionAttributes) {
        this.bind(newElement);
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.fromClickCursorPos = -1;
        this.toClickCursorPos = -1;
        this.textField = new TextFieldLogic(properties.getProperty("text", ""), this.nifty.getClipboard(), this);
        this.textField.toFirstPosition();
        this.textElement = this.getElement().findElementByName("#text");
        this.fieldElement = this.getElement().findElementByName("#field");
        this.cursorElement = this.getElement().findElementByName("#cursor");
        if (properties.containsKey("passwordChar")) {
            this.textField.setFormat(new FormatPassword(properties.getProperty("passwordChar").charAt(0)));
        }
        if (properties.containsKey("maxLength")) {
            this.setMaxLength(Integer.parseInt(properties.getProperty("maxLength")));
        }
        if (properties.containsKey("filter")) {
            this.activateFilter(properties.getProperty("filter"));
        }
    }

    private void activateFilter(String filter) {
        if ("all".equals(filter)) {
            this.disableInputFilter();
        } else if ("digits".equals(filter)) {
            this.enableInputFilter(new FilterAcceptDigits());
        } else if ("negative digits".equals(filter)) {
            this.enableInputFilter(new FilterAcceptNegativeDigits());
        } else if ("float".equals(filter)) {
            this.enableInputFilter(new FilterAcceptFloat());
        } else if ("letters".equals(filter)) {
            this.enableInputFilter(new FilterAcceptLetters());
        } else if ("upper case".equals(filter)) {
            this.enableInputFilter(new FilterAcceptUpperCase());
        } else if ("lower case".equals(filter)) {
            this.enableInputFilter(new FilterAcceptLowerCase());
        } else {
            this.enableInputFilter(new FilterAcceptRegex(filter));
        }
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
        this.focusHandler = this.screen.getFocusHandler();
        this.textField.setTextAndNotify(((TextRenderer)this.textElement.getRenderer(TextRenderer.class)).getOriginalText());
        this.fieldWidth = this.fieldElement.getWidth() - this.cursorElement.getWidth();
        TextRenderer textRenderer = (TextRenderer)this.textElement.getRenderer(TextRenderer.class);
        this.firstVisibleCharacterIndex = 0;
        this.lastVisibleCharacterIndex = FontHelper.getVisibleCharactersFromStart((RenderFont)textRenderer.getFont(), (CharSequence)this.textField.getDisplayedText(), (int)this.fieldWidth, (float)1.0f);
        this.updateCursor();
        super.init(parameter, controlDefinitionAttributes);
    }

    public void onStartScreen() {
    }

    public void layoutCallback() {
        this.fieldWidth = this.fieldElement.getWidth() - this.cursorElement.getWidth();
    }

    private CharSequence getVisibleText() {
        return this.textField.getDisplayedText().subSequence(this.firstVisibleCharacterIndex, this.lastVisibleCharacterIndex);
    }

    public void onClick(int mouseX, int mouseY) {
        CharSequence visibleString = this.getVisibleText();
        int indexFromPixel = this.getCursorPosFromMouse(mouseX, visibleString);
        if (indexFromPixel != -1) {
            this.fromClickCursorPos = this.firstVisibleCharacterIndex + indexFromPixel;
        }
        this.textField.resetSelection();
        this.textField.setCursorPosition(this.fromClickCursorPos);
        this.updateCursor();
    }

    public void onClickMouseMove(int mouseX, int mouseY) {
        CharSequence visibleString = this.getVisibleText();
        int indexFromPixel = this.getCursorPosFromMouse(mouseX, visibleString);
        if (indexFromPixel != -1) {
            this.toClickCursorPos = this.firstVisibleCharacterIndex + indexFromPixel;
        }
        this.textField.setCursorPosition(this.fromClickCursorPos);
        this.textField.startSelecting();
        this.textField.setCursorPosition(this.toClickCursorPos);
        this.textField.endSelecting();
        this.updateCursor();
    }

    private int getCursorPosFromMouse(int mouseX, CharSequence visibleString) {
        TextRenderer textRenderer = (TextRenderer)this.textElement.getRenderer(TextRenderer.class);
        return FontHelper.getCharacterIndexFromPixelPosition((RenderFont)textRenderer.getFont(), (CharSequence)visibleString, (int)(mouseX - this.fieldElement.getX()), (float)1.0f);
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == null) {
            return false;
        }
        switch (inputEvent) {
            case MoveCursorLeft: {
                this.textField.cursorLeft();
                break;
            }
            case MoveCursorRight: {
                this.textField.cursorRight();
                break;
            }
            case Delete: {
                this.textField.delete();
                break;
            }
            case Backspace: {
                this.textField.backspace();
                break;
            }
            case MoveCursorToLastPosition: {
                this.textField.toLastPosition();
                break;
            }
            case MoveCursorToFirstPosition: {
                this.textField.toFirstPosition();
                break;
            }
            case SelectionStart: {
                this.textField.startSelecting();
                break;
            }
            case SelectionEnd: {
                this.textField.endSelecting();
                break;
            }
            case Cut: {
                this.textField.cut();
                break;
            }
            case Copy: {
                this.textField.copy();
                break;
            }
            case Paste: {
                this.textField.put();
                break;
            }
            case SelectAll: {
                this.textField.selectAll();
                break;
            }
            case Character: {
                this.textField.insert(inputEvent.getCharacter());
                break;
            }
            case NextInputElement: {
                this.focusHandler.getNext(this.fieldElement).setFocus();
                break;
            }
            case PrevInputElement: {
                this.focusHandler.getPrev(this.fieldElement).setFocus();
                break;
            }
            default: {
                this.updateCursor();
                return false;
            }
        }
        this.updateCursor();
        return true;
    }

    private void updateCursor() {
        TextRenderer textRenderer = (TextRenderer)this.textElement.getRenderer(TextRenderer.class);
        String text = this.textField.getDisplayedText().toString();
        this.checkBounds(text, textRenderer);
        this.calcLastVisibleIndex(textRenderer);
        textRenderer.setText(text);
        textRenderer.setSelection(this.textField.getSelectionStart(), this.textField.getSelectionEnd());
        int cursorPos = this.textField.getCursorPosition();
        this.calcFirstVisibleIndex(cursorPos);
        this.calcLastVisibleIndex(textRenderer);
        String substring2 = text.substring(0, this.firstVisibleCharacterIndex);
        int d = textRenderer.getFont().getWidth(substring2);
        textRenderer.setXoffsetHack(-d);
        String substring = text.substring(0, cursorPos);
        int textWidth = textRenderer.getFont().getWidth(substring);
        int cursorPixelPos = textWidth - d;
        StringBuilder tempBuilder = new StringBuilder(5);
        tempBuilder.append(cursorPixelPos);
        tempBuilder.append("px");
        this.cursorElement.setConstraintX(new SizeValue(tempBuilder.toString()));
        tempBuilder.setLength(0);
        tempBuilder.append((this.getElement().getHeight() - this.cursorElement.getHeight()) / 2);
        tempBuilder.append("px");
        this.cursorElement.setConstraintY(new SizeValue(tempBuilder.toString()));
        this.cursorElement.startEffect(EffectEventId.onActive, null);
        this.cursorElement.getParent().layoutElements();
    }

    private void calcFirstVisibleIndex(int cursorPos) {
        if (cursorPos > this.lastVisibleCharacterIndex) {
            int cursorPosDelta = cursorPos - this.lastVisibleCharacterIndex;
            this.firstVisibleCharacterIndex += cursorPosDelta;
        } else if (cursorPos < this.firstVisibleCharacterIndex) {
            int cursorPosDelta = this.firstVisibleCharacterIndex - cursorPos;
            this.firstVisibleCharacterIndex -= cursorPosDelta;
        }
    }

    private void checkBounds(CharSequence text, TextRenderer textRenderer) {
        int textLen = text.length();
        if (this.firstVisibleCharacterIndex > textLen) {
            this.lastVisibleCharacterIndex = textLen;
            this.firstVisibleCharacterIndex = FontHelper.getVisibleCharactersFromEnd((RenderFont)textRenderer.getFont(), (CharSequence)text, (int)this.fieldWidth, (float)1.0f);
        }
    }

    private void calcLastVisibleIndex(TextRenderer textRenderer) {
        CharSequence currentText = this.textField.getDisplayedText();
        if (this.firstVisibleCharacterIndex < currentText.length()) {
            CharSequence textToCheck = currentText.subSequence(this.firstVisibleCharacterIndex, currentText.length());
            int lengthFitting = FontHelper.getVisibleCharactersFromStart((RenderFont)textRenderer.getFont(), (CharSequence)textToCheck, (int)this.fieldWidth, (float)1.0f);
            this.lastVisibleCharacterIndex = lengthFitting + this.firstVisibleCharacterIndex;
        } else {
            this.lastVisibleCharacterIndex = this.firstVisibleCharacterIndex;
        }
    }

    public void onFocus(boolean getFocus) {
        if (this.cursorElement != null) {
            super.onFocus(getFocus);
            if (getFocus) {
                this.cursorElement.startEffect(EffectEventId.onCustom);
            } else {
                this.cursorElement.stopEffect(EffectEventId.onCustom);
            }
            this.updateCursor();
        }
    }

    @Override
    public String getText() {
        return this.getRealText();
    }

    @Override
    public String getRealText() {
        return this.textField.getRealText().toString();
    }

    @Override
    public String getDisplayedText() {
        return this.textField.getDisplayedText().toString();
    }

    @Override
    public void setText(CharSequence text) {
        this.textField.setText(this.nifty.specialValuesReplace(text.toString()));
        this.updateCursor();
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.textField.setMaxLength(maxLength);
        this.updateCursor();
    }

    @Override
    public void setCursorPosition(int position) {
        this.textField.setCursorPosition(position);
        this.updateCursor();
    }

    @Override
    public void enableInputFilter(TextFieldInputFilter filter) {
        this.textField.setInputFilterSingle(filter);
        this.textField.setInputFilterSequence(filter);
    }

    @Override
    public void enableInputFilter(TextFieldInputCharFilter filter) {
        this.textField.setInputFilterSingle(filter);
        this.textField.setInputFilterSequence(new InputCharFilterWrapper(filter));
    }

    @Override
    public void enableInputFilter(TextFieldInputCharSequenceFilter filter) {
        this.textField.setInputFilterSingle(new InputCharSequenceFilterWrapper(filter));
        this.textField.setInputFilterSequence(filter);
    }

    @Override
    public void disableInputFilter() {
        this.textField.setInputFilterSingle(null);
        this.textField.setInputFilterSequence(null);
    }

    @Override
    public void enableDeleteFilter(TextFieldDeleteFilter filter) {
        this.textField.setDeleteFilter(filter);
    }

    @Override
    public void disableDeleteFilter() {
        this.textField.setDeleteFilter(null);
    }

    @Override
    public void setFormat(TextFieldDisplayFormat format) {
        this.textField.setFormat(format);
    }

    @Override
    public void textChangeEvent(String newText) {
        this.nifty.publishEvent(this.getElement().getId(), (NiftyEvent)new TextFieldChangedEvent(this, newText));
    }

    @Override
    public void enablePasswordChar(char passwordChar) {
        this.setFormat(new FormatPassword(passwordChar));
        this.updateCursor();
    }

    @Override
    public void disablePasswordChar() {
        this.setFormat(null);
        this.updateCursor();
    }

    @Override
    public boolean isPasswordCharEnabled() {
        return this.textField.getFormat() instanceof FormatPassword;
    }
}

