/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dropdown;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.DropDownSelectionChangedEvent;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.dropdown.DropDownControl;
import de.lessvoid.nifty.controls.listbox.ListBoxControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;
import java.util.List;
import org.bushe.swing.event.EventTopicSubscriber;

public class DropDownListBoxSelectionChangedEventSubscriber
implements EventTopicSubscriber<ListBoxSelectionChangedEvent> {
    private Nifty nifty;
    private Screen screen;
    private ListBox listBox;
    private DropDown dropDown;
    private Element popupInstance;

    public DropDownListBoxSelectionChangedEventSubscriber(Nifty nifty, Screen screen, ListBox listBox, DropDown dropDown, Element popupInstance) {
        this.nifty = nifty;
        this.screen = screen;
        this.listBox = listBox;
        this.dropDown = dropDown;
        this.popupInstance = popupInstance;
    }

    public void onEvent(String topic, ListBoxSelectionChangedEvent data) {
        final Object selectedItem = this.getSelectedItem(data.getSelection());
        ListBoxControl listBoxControl = (ListBoxControl)this.listBox;
        listBoxControl.getViewConverter().display(this.dropDown.getElement().findElementByName("#text"), selectedItem);
        final int selectedItemIndex = this.getSelectedIndex(data);
        if (this.screen.isActivePopup(this.popupInstance)) {
            ((DropDownControl)this.dropDown.getElement().getControl(DropDownControl.class)).close(new EndNotify(){

                public void perform() {
                    DropDownListBoxSelectionChangedEventSubscriber.this.nifty.publishEvent(DropDownListBoxSelectionChangedEventSubscriber.this.dropDown.getId(), new DropDownSelectionChangedEvent<Object>(DropDownListBoxSelectionChangedEventSubscriber.this.dropDown, selectedItem, selectedItemIndex));
                }
            });
        } else {
            this.nifty.publishEvent(this.dropDown.getId(), new DropDownSelectionChangedEvent<Object>(this.dropDown, selectedItem, selectedItemIndex));
        }
    }

    private int getSelectedIndex(ListBoxSelectionChangedEvent data) {
        int selectedItemIndex = -1;
        List<Integer> selectionIndices = data.getSelectionIndices();
        if (!selectionIndices.isEmpty()) {
            selectedItemIndex = selectionIndices.get(0);
        }
        return selectedItemIndex;
    }

    private Object getSelectedItem(List selection) {
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(0);
    }
}

