/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dropdown;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.dropdown.DropDownListBoxSelectionChangedEventSubscriber;
import de.lessvoid.nifty.controls.dropdown.DropDownPopup;
import de.lessvoid.nifty.controls.listbox.ListBoxControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class DropDownControl<T>
extends AbstractController
implements DropDown<T> {
    private static Logger log = Logger.getLogger(DropDownControl.class.getName());
    private Nifty nifty;
    private boolean alreadyOpen = false;
    private FocusHandler focusHandler;
    private Screen screen;
    private Element popup;
    private ListBox<T> listBox;

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, Attributes controlDefinitionAttributesParam) {
        super.bind(newElement);
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.focusHandler = this.screen.getFocusHandler();
        String elementId = this.getElement().getId();
        if (elementId == null) {
            log.warning("The DropDownControl requires an id but this one is missing it.");
            return;
        }
        Attributes parameters = new Attributes(new String[]{"displayItems", properties.getProperty("displayItems", "4")});
        this.popup = this.nifty.createPopupWithStyle("dropDownBoxSelectPopup", this.getElement().getElementType().getAttributes().get("style"), parameters);
        ((DropDownPopup)this.popup.getControl(DropDownPopup.class)).setDropDownElement(this, this.popup);
        this.listBox = (ListBox)this.popup.findNiftyControl("#listBox", ListBox.class);
        DropDown.DropDownViewConverter<T> converter = this.createViewConverter(properties.getProperty("viewConverterClass"));
        if (converter != null) {
            this.setViewConverter(converter);
        }
    }

    private DropDown.DropDownViewConverter<T> createViewConverter(String className) {
        if (className == null) {
            return null;
        }
        try {
            return (DropDown.DropDownViewConverter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to instantiate given class [" + className + "] with error: " + e.getMessage(), e);
            return null;
        }
    }

    public void onStartScreen() {
        this.updateEnabled();
        ListBoxControl listBoxControl = (ListBoxControl)this.listBox;
        listBoxControl.getViewConverter().display(this.getElement().findElementByName("#text"), this.getSelection());
        this.nifty.subscribe(this.screen, this.listBox.getId(), ListBoxSelectionChangedEvent.class, (EventTopicSubscriber)new DropDownListBoxSelectionChangedEventSubscriber(this.nifty, this.screen, this.listBox, this, this.popup));
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyInputEvent.NextInputElement) {
            this.focusHandler.getNext(this.getElement()).setFocus();
            return true;
        }
        if (inputEvent == NiftyInputEvent.PrevInputElement) {
            this.focusHandler.getPrev(this.getElement()).setFocus();
            return true;
        }
        if (inputEvent == NiftyInputEvent.Activate) {
            this.dropDownClicked();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorUp) {
            this.listBox.selectPrevious();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorDown) {
            this.listBox.selectNext();
            return true;
        }
        return false;
    }

    public void dropDownClicked() {
        if (this.popup == null) {
            return;
        }
        if (this.alreadyOpen) {
            return;
        }
        this.alreadyOpen = true;
        this.nifty.showPopup(this.nifty.getCurrentScreen(), this.popup.getId(), null);
    }

    public void close() {
        this.closeInternal(null);
    }

    public void close(EndNotify endNotify) {
        this.closeInternal(endNotify);
    }

    private void closeInternal(final EndNotify endNotify) {
        this.alreadyOpen = false;
        this.nifty.closePopup(this.popup.getId(), new EndNotify(){

            public void perform() {
                DropDownControl.this.nifty.subscribe(DropDownControl.this.screen, DropDownControl.this.listBox.getId(), ListBoxSelectionChangedEvent.class, (EventTopicSubscriber)new DropDownListBoxSelectionChangedEventSubscriber(DropDownControl.this.nifty, DropDownControl.this.screen, DropDownControl.this.listBox, DropDownControl.this, DropDownControl.this.popup));
                if (endNotify != null) {
                    endNotify.perform();
                }
            }
        });
    }

    public void refresh() {
    }

    private void updateEnabled() {
        this.setEnabled(!this.listBox.getItems().isEmpty());
    }

    @Override
    public void setViewConverter(final DropDown.DropDownViewConverter<T> viewConverter) {
        this.listBox.setListBoxViewConverter(new ListBox.ListBoxViewConverter<T>(){

            @Override
            public void display(Element listBoxItem, T item) {
                viewConverter.display(listBoxItem, item);
            }

            @Override
            public int getWidth(Element element, T item) {
                return viewConverter.getWidth(element, item);
            }
        });
    }

    @Override
    public void addItem(T newItem) {
        this.listBox.addItem(newItem);
        this.updateEnabled();
    }

    @Override
    public void insertItem(T item, int index) {
        this.listBox.insertItem(item, index);
        this.updateEnabled();
    }

    @Override
    public int itemCount() {
        return this.listBox.itemCount();
    }

    @Override
    public void clear() {
        this.listBox.clear();
        this.updateEnabled();
    }

    @Override
    public void selectItemByIndex(int selectionIndex) {
        this.listBox.selectItemByIndex(selectionIndex);
    }

    @Override
    public void selectItem(T item) {
        this.listBox.selectItem(item);
    }

    @Override
    public T getSelection() {
        List<T> selection = this.listBox.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return selection.get(0);
    }

    @Override
    public int getSelectedIndex() {
        List<Integer> selection = this.listBox.getSelectedIndices();
        if (selection.isEmpty()) {
            return -1;
        }
        return selection.get(0);
    }

    @Override
    public void removeItemByIndex(int itemIndex) {
        this.listBox.removeItemByIndex(itemIndex);
        this.updateEnabled();
    }

    @Override
    public void removeItem(T item) {
        this.listBox.removeItem(item);
        this.updateEnabled();
    }

    @Override
    public List<T> getItems() {
        return this.listBox.getItems();
    }

    @Override
    public void addAllItems(List<T> itemsToAdd) {
        this.listBox.addAllItems(itemsToAdd);
        this.updateEnabled();
    }

    @Override
    public void removeAllItems(List<T> itemsToRemove) {
        this.listBox.removeAllItems(itemsToRemove);
        this.updateEnabled();
    }
}

