/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleCommandSplitter;
import de.lessvoid.nifty.controls.ConsoleExecuteCommandEvent;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.KeyInputHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConsoleCommands
implements KeyInputHandler {
    private boolean commandCompletion = false;
    private ConsoleCommandSplitter splitter = new ConsoleCommandSplitter();
    private Map<String, ConsoleCommand> commands = new TreeMap<String, ConsoleCommand>();
    private List<String> commandHistory = new ArrayList<String>();
    private int commandHistoryLastCommand = -1;
    private Nifty nifty;
    private Console console;
    private TextField textfield;

    public ConsoleCommands(Nifty nifty, Console console) {
        this.nifty = nifty;
        this.console = console;
        this.textfield = console.getTextField();
        this.textfield.getElement().addPreInputHandler((KeyInputHandler)this);
    }

    public void enableCommandCompletion(boolean enabled) {
        this.commandCompletion = enabled;
    }

    public void registerCommand(String commandText, ConsoleCommand command) {
        this.commands.put(commandText, command);
    }

    public List<String> getRegisteredCommands() {
        return Collections.unmodifiableList(Arrays.asList(this.commands.keySet().toArray(new String[0])));
    }

    public boolean keyEvent(NiftyInputEvent inputEvent) {
        if (!this.commandCompletion) {
            return false;
        }
        if (NiftyInputEvent.NextInputElement.equals((Object)inputEvent)) {
            List<String> matches = this.findMatches(this.textfield.getText());
            if (matches.size() == 1) {
                this.changeText(matches.get(0));
                return true;
            }
            if (matches.size() > 1) {
                String shortest = this.findShortestMatch(matches);
                if (shortest.length() == this.textfield.getText().length()) {
                    StringBuffer buffer = new StringBuffer("\n");
                    for (String match : matches) {
                        buffer.append("\\#cccf#" + match + "\n");
                    }
                    this.console.output(buffer.toString());
                }
                this.changeText(shortest);
            }
            return true;
        }
        if (NiftyInputEvent.MoveCursorUp.equals((Object)inputEvent)) {
            if (this.commandHistoryLastCommand > 0) {
                --this.commandHistoryLastCommand;
                this.changeText(this.commandHistory.get(this.commandHistoryLastCommand));
            }
            return true;
        }
        if (NiftyInputEvent.MoveCursorDown.equals((Object)inputEvent)) {
            if (this.commandHistoryLastCommand < this.commandHistory.size() - 1) {
                ++this.commandHistoryLastCommand;
                this.changeText(this.commandHistory.get(this.commandHistoryLastCommand));
            } else {
                this.commandHistoryLastCommand = this.commandHistory.size();
                this.changeText("");
            }
            return true;
        }
        if (NiftyInputEvent.SubmitText.equals((Object)inputEvent)) {
            String text = this.textfield.getText();
            this.console.output(text);
            this.textfield.setText("");
            String[] split = this.splitter.split(text);
            if (split.length != 0) {
                String command = split[0];
                for (Map.Entry<String, ConsoleCommand> registeredCommand : this.commands.entrySet()) {
                    String start;
                    String[] s = registeredCommand.getKey().split(" ");
                    if (s.length == 0 || !command.equals(start = s[0])) continue;
                    ConsoleCommand consoleCommand = registeredCommand.getValue();
                    consoleCommand.execute(split);
                    this.addCommandToHistory(text);
                    return true;
                }
            }
            this.console.outputError("Unknown command: " + text);
            this.nifty.publishEvent(this.console.getId(), (NiftyEvent)new ConsoleExecuteCommandEvent(this.console, text));
            this.addCommandToHistory(text);
            return true;
        }
        return false;
    }

    public ConsoleCommand findCommand(String commandText) {
        ConsoleCommand command = this.commands.get(commandText);
        if (command != null) {
            return command;
        }
        List<String> commandMatches = this.findMatches(commandText);
        if (commandMatches.size() == 1) {
            return this.commands.get(commandMatches.get(0));
        }
        return null;
    }

    private void changeText(String newText) {
        this.textfield.setText(newText);
        this.textfield.setCursorPosition(this.textfield.getText().length());
    }

    private void addCommandToHistory(String text) {
        this.commandHistory.add(text);
        this.commandHistoryLastCommand = this.commandHistory.size();
    }

    List<String> findMatches(String text) {
        ArrayList<String> result = new ArrayList<String>();
        if (text == null || text.length() == 0) {
            return result;
        }
        for (String command : this.commands.keySet()) {
            if (command.equals(text)) {
                result.add(command);
                continue;
            }
            if (!command.startsWith(text)) continue;
            result.add(command);
        }
        return result;
    }

    String findShortestMatch(List<String> matches) {
        String longest = "";
        for (String match : matches) {
            if (match.length() <= longest.length()) continue;
            longest = match;
        }
        String lastCheck = longest.substring(0, 1);
        for (int i = 1; i < longest.length(); ++i) {
            String check = longest.substring(0, i);
            for (String match : matches) {
                if (match.startsWith(check)) continue;
                return lastCheck;
            }
            lastCheck = check;
        }
        return lastCheck;
    }

    public static interface ConsoleCommand {
        public void execute(String[] var1);
    }
}

