/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jogamp.common.Debug;

public final class ReflectionUtil {
    public static final boolean DEBUG = Debug.debug("ReflectionUtil");
    private static final Class[] zeroTypes = new Class[0];

    public static final boolean isClassAvailable(String clazzName, ClassLoader cl) {
        try {
            return null != Class.forName(clazzName, false, cl);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static final Class getClass(String clazzName, boolean initialize, ClassLoader cl) throws JogampRuntimeException {
        try {
            return ReflectionUtil.getClassImpl(clazzName, initialize, cl);
        }
        catch (ClassNotFoundException e) {
            throw new JogampRuntimeException(clazzName + " not available", e);
        }
    }

    private static Class getClassImpl(String clazzName, boolean initialize, ClassLoader cl) throws ClassNotFoundException {
        return Class.forName(clazzName, initialize, cl);
    }

    public static final Constructor getConstructor(String clazzName, Class[] cstrArgTypes, ClassLoader cl) throws JogampRuntimeException {
        try {
            return ReflectionUtil.getConstructor(ReflectionUtil.getClassImpl(clazzName, true, cl), cstrArgTypes);
        }
        catch (ClassNotFoundException ex) {
            throw new JogampRuntimeException(clazzName + " not available", ex);
        }
    }

    static final String asString(Class[] argTypes) {
        StringBuffer args = new StringBuffer();
        boolean coma = false;
        if (null != argTypes) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (coma) {
                    args.append(", ");
                }
                args.append(argTypes[i].getName());
                coma = true;
            }
        }
        return args.toString();
    }

    public static final Constructor getConstructor(Class clazz, Class[] cstrArgTypes) throws JogampRuntimeException {
        try {
            if (null == cstrArgTypes) {
                cstrArgTypes = zeroTypes;
            }
            return clazz.getDeclaredConstructor(cstrArgTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new JogampRuntimeException("Constructor: '" + clazz + "(" + ReflectionUtil.asString(cstrArgTypes) + ")' not found", ex);
        }
    }

    public static final Constructor getConstructor(String clazzName, ClassLoader cl) throws JogampRuntimeException {
        return ReflectionUtil.getConstructor(clazzName, null, cl);
    }

    public static final Object createInstance(Class clazz, Class[] cstrArgTypes, Object[] cstrArgs) throws JogampRuntimeException, RuntimeException {
        try {
            return ReflectionUtil.getConstructor(clazz, cstrArgTypes).newInstance(cstrArgs);
        }
        catch (Exception e) {
            Throwable t = e;
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new JogampRuntimeException("can not create instance of " + clazz, t);
        }
    }

    public static final Object createInstance(Class clazz, Object[] cstrArgs) throws JogampRuntimeException, RuntimeException {
        Class[] cstrArgTypes = null;
        if (null != cstrArgs) {
            cstrArgTypes = new Class[cstrArgs.length];
            for (int i = 0; i < cstrArgs.length; ++i) {
                cstrArgTypes[i] = cstrArgs[i].getClass();
            }
        }
        return ReflectionUtil.createInstance(clazz, cstrArgTypes, cstrArgs);
    }

    public static final Object createInstance(String clazzName, Class[] cstrArgTypes, Object[] cstrArgs, ClassLoader cl) throws JogampRuntimeException, RuntimeException {
        try {
            return ReflectionUtil.createInstance(ReflectionUtil.getClassImpl(clazzName, true, cl), cstrArgTypes, cstrArgs);
        }
        catch (ClassNotFoundException ex) {
            throw new JogampRuntimeException(clazzName + " not available", ex);
        }
    }

    public static final Object createInstance(String clazzName, Object[] cstrArgs, ClassLoader cl) throws JogampRuntimeException, RuntimeException {
        Class[] cstrArgTypes = null;
        if (null != cstrArgs) {
            cstrArgTypes = new Class[cstrArgs.length];
            for (int i = 0; i < cstrArgs.length; ++i) {
                cstrArgTypes[i] = cstrArgs[i].getClass();
            }
        }
        return ReflectionUtil.createInstance(clazzName, cstrArgTypes, cstrArgs, cl);
    }

    public static final Object createInstance(String clazzName, ClassLoader cl) throws JogampRuntimeException, RuntimeException {
        return ReflectionUtil.createInstance(clazzName, null, null, cl);
    }

    public static final boolean instanceOf(Object obj, String clazzName) {
        return ReflectionUtil.instanceOf(obj.getClass(), clazzName);
    }

    public static final boolean instanceOf(Class clazz, String clazzName) {
        do {
            if (!clazz.getName().equals(clazzName)) continue;
            return true;
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public static final boolean implementationOf(Object obj, String faceName) {
        return ReflectionUtil.implementationOf(obj.getClass(), faceName);
    }

    public static final boolean implementationOf(Class clazz, String faceName) {
        do {
            Class<?>[] clazzes = clazz.getInterfaces();
            for (int i = clazzes.length - 1; i >= 0; --i) {
                Class<?> face = clazzes[i];
                if (!face.getName().equals(faceName)) continue;
                return true;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public static boolean isAWTComponent(Object target) {
        return ReflectionUtil.instanceOf(target, "java.awt.Component");
    }

    public static boolean isAWTComponent(Class clazz) {
        return ReflectionUtil.instanceOf(clazz, "java.awt.Component");
    }

    public static final Method getMethod(Class clazz, String methodName, Class[] argTypes, ClassLoader cl) throws JogampRuntimeException, RuntimeException {
        try {
            return clazz.getDeclaredMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new JogampRuntimeException("Method: '" + clazz + "." + methodName + "(" + ReflectionUtil.asString(argTypes) + ")' not found", ex);
        }
    }

    public static final Method getMethod(String clazzName, String methodName, Class[] argTypes, ClassLoader cl) throws JogampRuntimeException, RuntimeException {
        try {
            return ReflectionUtil.getMethod(ReflectionUtil.getClassImpl(clazzName, true, cl), methodName, argTypes, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new JogampRuntimeException(clazzName + " not available", ex);
        }
    }

    public static final Object callMethod(Object instance, Method method, Object[] args) throws JogampRuntimeException, RuntimeException {
        try {
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            Throwable t = e;
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new JogampRuntimeException("calling " + method + " failed", t);
        }
    }

    public static final Object callStaticMethod(String clazzName, String methodName, Class[] argTypes, Object[] args, ClassLoader cl) throws JogampRuntimeException, RuntimeException {
        return ReflectionUtil.callMethod(null, ReflectionUtil.getMethod(clazzName, methodName, argTypes, cl), args);
    }

    public static String getBaseName(Class clazz) {
        String s = clazz.toString();
        return s.substring(s.lastIndexOf(".") + 1);
    }
}

