/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.slider;

import de.lessvoid.nifty.controls.slider.SliderView;

public class SliderImpl {
    private SliderView view;
    private float value;
    private float oldValue;
    private float min;
    private float max;
    private float stepSize;
    private float buttonStepSize;

    public void bindToView(SliderView view, float min, float max, float stepSize, float buttonStepSize) {
        this.view = view;
        this.min = min;
        this.max = max;
        this.stepSize = stepSize;
        this.buttonStepSize = buttonStepSize;
        this.oldValue = -1.0f;
        this.updateView();
        this.changeValue(0.0f);
    }

    public void setValue(float value) {
        this.changeValue(value);
        this.updateView();
    }

    public float getValue() {
        return this.value;
    }

    public void stepUp() {
        this.changeValue(this.value + this.buttonStepSize);
        this.updateView();
    }

    public void stepDown() {
        this.changeValue(this.value - this.buttonStepSize);
        this.updateView();
    }

    public void setValueFromPosition(int pixelX, int pixelY) {
        this.setValue(this.ensureStepSize(this.viewToWorld(this.view.filter(pixelX, pixelY))));
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
        this.changeValue(this.value);
        this.updateView();
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
        this.changeValue(this.value);
        this.updateView();
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
        this.changeValue(this.value);
        this.updateView();
    }

    public float getButtonStepSize() {
        return this.buttonStepSize;
    }

    public void setButtonStepSize(float buttonStepSize) {
        this.buttonStepSize = buttonStepSize;
        this.changeValue(this.value);
        this.updateView();
    }

    public void setup(float min, float max, float current, float stepSize, float buttonStepSize) {
        this.min = min;
        this.max = max;
        this.value = current;
        this.stepSize = stepSize;
        this.buttonStepSize = buttonStepSize;
        this.changeValue(this.value);
        this.updateView();
    }

    private void changeValue(float newValue) {
        this.value = newValue;
        if (this.value > this.max) {
            this.value = this.max;
        } else if (newValue < this.min) {
            this.value = this.min;
        }
        this.value = this.ensureStepSize(this.value);
        if (this.value != this.oldValue) {
            this.oldValue = this.value;
            this.view.valueChanged(this.value);
        }
    }

    public void updateView() {
        this.view.update((int)this.worldToView(this.value));
    }

    private float ensureStepSize(float value) {
        return (float)Math.round(value / this.stepSize) * this.stepSize;
    }

    private float viewToWorld(float viewValue) {
        return viewValue / (float)this.view.getSize() * (this.max - this.min) + this.min;
    }

    private float worldToView(float worldValue) {
        return (worldValue - this.min) / (this.max - this.min) * (float)this.view.getSize();
    }
}

