/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.slider;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.NextPrevHelper;
import de.lessvoid.nifty.controls.Slider;
import de.lessvoid.nifty.controls.SliderChangedEvent;
import de.lessvoid.nifty.controls.slider.SliderImpl;
import de.lessvoid.nifty.controls.slider.SliderView;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

@Deprecated
public class SliderControl
extends AbstractController
implements Slider {
    private SliderImpl sliderImpl = new SliderImpl();
    private SliderView sliderView;
    private Nifty nifty;
    private Element element;
    private Element elementPosition;
    private Element elementBackground;
    private NextPrevHelper nextPrevHelper;
    private float min;
    private float max;
    private float initial;
    private float stepSize;
    private float buttonStepSize;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(element);
        this.nifty = nifty;
        this.element = element;
        this.elementBackground = element.findElementByName("#background");
        this.elementPosition = element.findElementByName("#position");
        this.nextPrevHelper = new NextPrevHelper(element, screen.getFocusHandler());
        if ("verticalSlider".equals(parameter.getProperty("name"))) {
            this.sliderView = new SliderViewVertical(this);
        } else if ("horizontalSlider".equals(parameter.getProperty("name"))) {
            this.sliderView = new SliderViewHorizontal(this);
        }
        this.min = Float.valueOf(parameter.getProperty("min", "0.0")).floatValue();
        this.max = Float.valueOf(parameter.getProperty("max", "100.0")).floatValue();
        this.initial = Float.valueOf(parameter.getProperty("initial", "0.0")).floatValue();
        this.stepSize = Float.valueOf(parameter.getProperty("stepSize", "1.0")).floatValue();
        this.buttonStepSize = Float.valueOf(parameter.getProperty("buttonStepSize", "25.0")).floatValue();
        this.sliderImpl.bindToView(this.sliderView, this.min, this.max, this.stepSize, this.buttonStepSize);
        this.sliderImpl.setValue(this.initial);
    }

    public void onStartScreen() {
    }

    public void layoutCallback() {
        this.sliderImpl.updateView();
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (this.nextPrevHelper.handleNextPrev(inputEvent)) {
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorUp || inputEvent == NiftyInputEvent.MoveCursorLeft) {
            this.sliderImpl.stepDown();
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorDown || inputEvent == NiftyInputEvent.MoveCursorRight) {
            this.sliderImpl.stepUp();
            return true;
        }
        return false;
    }

    public void upClick() {
        this.sliderImpl.stepDown();
    }

    public void downClick() {
        this.sliderImpl.stepUp();
    }

    public void mouseClick(int mouseX, int mouseY) {
        this.sliderImpl.setValueFromPosition(mouseX - this.elementBackground.getX() - this.elementPosition.getWidth() / 2, mouseY - this.elementBackground.getY() - this.elementPosition.getHeight() / 2);
    }

    public void mouseWheel(Element element, NiftyMouseInputEvent inputEvent) {
        int mouseWheel = inputEvent.getMouseWheel();
        float currentValue = this.sliderImpl.getValue();
        if (mouseWheel < 0) {
            this.sliderImpl.setValue(currentValue - this.sliderImpl.getButtonStepSize() * (float)mouseWheel);
        } else if (mouseWheel > 0) {
            this.sliderImpl.setValue(currentValue - this.sliderImpl.getButtonStepSize() * (float)mouseWheel);
        }
    }

    @Override
    public void setValue(float value) {
        this.sliderImpl.setValue(value);
    }

    @Override
    public float getValue() {
        return this.sliderImpl.getValue();
    }

    @Override
    public void setMin(float min) {
        this.sliderImpl.setMin(min);
    }

    @Override
    public float getMin() {
        return this.sliderImpl.getMin();
    }

    @Override
    public void setMax(float max) {
        this.sliderImpl.setMax(max);
    }

    @Override
    public float getMax() {
        return this.sliderImpl.getMax();
    }

    @Override
    public void setStepSize(float stepSize) {
        this.sliderImpl.setStepSize(stepSize);
    }

    @Override
    public float getStepSize() {
        return this.sliderImpl.getStepSize();
    }

    @Override
    public void setButtonStepSize(float buttonStepSize) {
        this.sliderImpl.setButtonStepSize(buttonStepSize);
    }

    @Override
    public float getButtonStepSize() {
        return this.sliderImpl.getButtonStepSize();
    }

    @Override
    public void setup(float min, float max, float current, float stepSize, float buttonStepSize) {
        this.sliderImpl.setup(min, max, current, stepSize, buttonStepSize);
    }

    private class SliderViewHorizontal
    implements SliderView {
        private Slider slider;

        public SliderViewHorizontal(Slider slider) {
            this.slider = slider;
        }

        @Override
        public int getSize() {
            return SliderControl.this.elementBackground.getWidth() - SliderControl.this.elementPosition.getWidth();
        }

        @Override
        public void update(int position) {
            SliderControl.this.elementPosition.setConstraintX(new SizeValue(position + "px"));
            SliderControl.this.elementBackground.layoutElements();
        }

        @Override
        public int filter(int pixelX, int pixelY) {
            return pixelX;
        }

        @Override
        public void valueChanged(float value) {
            if (SliderControl.this.element.getId() != null) {
                SliderControl.this.nifty.publishEvent(SliderControl.this.element.getId(), (NiftyEvent)new SliderChangedEvent(this.slider, value));
            }
        }
    }

    private class SliderViewVertical
    implements SliderView {
        private Slider slider;

        public SliderViewVertical(Slider slider) {
            this.slider = slider;
        }

        @Override
        public int getSize() {
            return SliderControl.this.elementBackground.getHeight() - SliderControl.this.elementPosition.getHeight();
        }

        @Override
        public void update(int position) {
            SliderControl.this.elementPosition.setConstraintY(new SizeValue(position + "px"));
            SliderControl.this.elementBackground.layoutElements();
        }

        @Override
        public int filter(int pixelX, int pixelY) {
            return pixelY;
        }

        @Override
        public void valueChanged(float value) {
            if (SliderControl.this.element.getId() != null) {
                SliderControl.this.nifty.publishEvent(SliderControl.this.element.getId(), (NiftyEvent)new SliderChangedEvent(this.slider, value));
            }
        }
    }
}

