/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyIdCreator;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.controls.ScrollbarChangedEvent;
import de.lessvoid.nifty.controls.dynamic.CustomControlCreator;
import de.lessvoid.nifty.controls.listbox.ListBoxImpl;
import de.lessvoid.nifty.controls.listbox.ListBoxItemController;
import de.lessvoid.nifty.controls.listbox.ListBoxPanel;
import de.lessvoid.nifty.controls.listbox.ListBoxView;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.ElementShowEvent;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.loaderv2.types.ControlType;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.bushe.swing.event.EventTopicSubscriber;

@Deprecated
public class ListBoxControl<T>
extends AbstractController
implements ListBox<T>,
ListBoxView<T> {
    private Logger log = Logger.getLogger(ListBoxControl.class.getName());
    private ListBoxImpl<T> listBoxImpl = new ListBoxImpl(this);
    private Element[] labelElements;
    private Nifty nifty;
    private Screen screen;
    private ScrollbarMode verticalScrollbar;
    private Element verticalScrollbarTemplate;
    private Element scrollElement;
    private ScrollbarMode horizontalScrollbar;
    private Element horizontalScrollbarTemplate;
    private Element childRootElement;
    private Element labelTemplateElement;
    private Element listBoxPanelElement;
    private Element bottomRightTemplate;
    private int labelTemplateHeight;
    private Properties parameter;
    private int displayItems;
    private ListBox.ListBoxViewConverter<T> viewConverter;
    private EventTopicSubscriber<ScrollbarChangedEvent> verticalScrollbarSubscriber = new EventTopicSubscriber<ScrollbarChangedEvent>(){

        public void onEvent(String id, ScrollbarChangedEvent event) {
            ListBoxControl.this.listBoxImpl.updateView((int)(event.getValue() / (float)ListBoxControl.this.labelTemplateHeight));
        }
    };
    private EventTopicSubscriber<ScrollbarChangedEvent> horizontalScrollbarSubscriber = new EventTopicSubscriber<ScrollbarChangedEvent>(){

        public void onEvent(String id, ScrollbarChangedEvent event) {
            if (ListBoxControl.this.childRootElement != null) {
                ListBoxControl.this.childRootElement.setConstraintX(new SizeValue(-((int)event.getValue()) + "px"));
                ListBoxControl.this.childRootElement.getParent().layoutElements();
            }
        }
    };
    private EventTopicSubscriber<ElementShowEvent> listBoxControlShowEventSubscriber = new EventTopicSubscriber<ElementShowEvent>(){

        public void onEvent(String id, ElementShowEvent event) {
            ListBoxControl.this.listBoxImpl.updateView();
        }
    };
    private int lastMaxWidth;
    private int applyWidthConstraintsLastWidth = -1;

    public void bind(Nifty niftyParam, Screen screenParam, Element elementParam, Properties parameterParam, Attributes controlDefinitionAttributes) {
        super.bind(elementParam);
        this.nifty = niftyParam;
        this.screen = screenParam;
        this.parameter = parameterParam;
        this.viewConverter = this.createViewConverter(this.parameter.getProperty("viewConverterClass", ListBox.ListBoxViewConverterSimple.class.getName()));
        this.verticalScrollbar = this.getScrollbarMode("vertical");
        this.verticalScrollbarTemplate = this.getElement().findElementByName("#vertical-scrollbar");
        this.horizontalScrollbar = this.getScrollbarMode("horizontal");
        this.horizontalScrollbarTemplate = this.getElement().findElementByName("#horizontal-scrollbar-parent");
        this.bottomRightTemplate = this.getElement().findElementByName("#bottom-right");
        this.displayItems = new Integer(this.parameter.getProperty("displayItems", "2"));
        this.scrollElement = this.getElement().findElementByName("#scrollpanel");
        this.applyWidthConstraintsLastWidth = -1;
        this.childRootElement = this.getElement().findElementByName("#child-root");
        if (!this.childRootElement.getElements().isEmpty()) {
            this.labelTemplateElement = (Element)this.childRootElement.getElements().get(0);
        }
        this.labelElements = new Element[this.displayItems];
        this.listBoxPanelElement = this.getElement().findElementByName("#panel");
        this.initSelectionMode(this.listBoxImpl, this.parameter.getProperty("selectionMode", "Single"), this.parameter.getProperty("forceSelection", "false"));
        this.connectListBoxAndListBoxPanel();
        this.listBoxImpl.bindToView(this, this.displayItems);
        this.lastMaxWidth = this.childRootElement.getWidth();
        this.ensureVerticalScrollbar();
        this.initLabelTemplateData();
        this.createLabels();
        this.initializeScrollPanel(this.screen);
        this.setElementHeight();
        this.initializeScrollElementHeight();
        this.listBoxImpl.updateView(0);
        this.initializeHorizontalScrollbar();
        this.initializeVerticalScrollbar(this.screen, this.labelTemplateHeight, 0);
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
        this.listBoxImpl.updateViewTotalCount();
        this.subscribeHorizontalScrollbar();
        this.subscribeVerticalScrollbar();
        this.nifty.subscribe(this.screen, this.getId(), ElementShowEvent.class, this.listBoxControlShowEventSubscriber);
        super.init(parameter, controlDefinitionAttributes);
    }

    public void onStartScreen() {
    }

    public void mouseWheel(Element e, NiftyMouseInputEvent inputEvent) {
        int mouseWheel = inputEvent.getMouseWheel();
        Scrollbar scrollbar = this.getVerticalScrollbar();
        if (scrollbar != null) {
            float currentValue = scrollbar.getValue();
            if (mouseWheel < 0) {
                scrollbar.setValue(currentValue - scrollbar.getButtonStepSize() * (float)mouseWheel);
            } else if (mouseWheel > 0) {
                scrollbar.setValue(currentValue - scrollbar.getButtonStepSize() * (float)mouseWheel);
            }
        }
    }

    private void subscribeVerticalScrollbar() {
        Element scrollbar = this.getElement().findElementByName("#vertical-scrollbar");
        if (scrollbar != null) {
            this.nifty.subscribe(this.screen, scrollbar.getId(), ScrollbarChangedEvent.class, this.verticalScrollbarSubscriber);
        }
    }

    private void subscribeHorizontalScrollbar() {
        Element scrollbar = this.getElement().findElementByName("#horizontal-scrollbar");
        if (scrollbar != null) {
            this.nifty.subscribe(this.screen, scrollbar.getId(), ScrollbarChangedEvent.class, this.horizontalScrollbarSubscriber);
        }
    }

    private void unsubscribeVerticalScrollbar() {
        Element scrollbar = this.getElement().findElementByName("#vertical-scrollbar");
        if (scrollbar != null) {
            this.nifty.unsubscribe(scrollbar.getId(), this.verticalScrollbarSubscriber);
        }
    }

    private void unsubscribeHorizontalScrollbar() {
        Element scrollbar = this.getElement().findElementByName("#horizontal-scrollbar");
        if (scrollbar != null) {
            this.nifty.unsubscribe(scrollbar.getId(), this.horizontalScrollbarSubscriber);
        }
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
    }

    public void setFocus() {
        this.childRootElement.setFocus();
    }

    private ListBox.ListBoxViewConverter<T> createViewConverter(String className) {
        try {
            return (ListBox.ListBoxViewConverter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            this.log.warning("Unable to instantiate given class [" + className + "] with error: " + e.getMessage());
            e.printStackTrace();
            return new ListBox.ListBoxViewConverterSimple();
        }
    }

    public ListBox.ListBoxViewConverter<T> getViewConverter() {
        return this.viewConverter;
    }

    @Override
    public void display(List<T> visibleItems, int focusElement, List<Integer> selectedElements) {
        this.ensureWidthConstraints();
        for (int i = 0; i < visibleItems.size(); ++i) {
            T item = visibleItems.get(i);
            if (this.labelElements[i] == null) continue;
            this.labelElements[i].setVisible(item != null && this.getElement().isVisible());
            if (item == null) continue;
            this.displayElement(i, item);
            this.setListBoxItemIndex(i);
            this.handleElementFocus(i, focusElement);
            this.handleElementSelection(i, item, selectedElements);
        }
    }

    @Override
    public void updateTotalCount(int newCount) {
        if (this.verticalScrollbar == ScrollbarMode.optional) {
            Element vertical = this.getElement().findElementByName("#vertical-scrollbar");
            if (newCount > this.displayItems) {
                if (vertical == null) {
                    ElementType templateType = this.verticalScrollbarTemplate.getElementType().copy();
                    CustomControlCreator create = new CustomControlCreator((ControlType)templateType);
                    Element e = create.create(this.nifty, this.screen, this.scrollElement);
                    if (e.getHeight() < 46) {
                        this.nifty.removeElement(this.screen, e);
                        return;
                    }
                    this.subscribeVerticalScrollbar();
                    this.ensureWidthConstraints();
                    this.updateBottomRightElement();
                    this.nifty.executeEndOfFrameElementActions();
                    this.screen.layoutLayers();
                }
            } else if (newCount <= this.displayItems && vertical != null) {
                this.unsubscribeVerticalScrollbar();
                this.nifty.removeElement(this.screen, vertical);
                this.nifty.executeEndOfFrameElementActions();
                this.ensureWidthConstraints();
                this.updateBottomRightElement();
                this.nifty.executeEndOfFrameElementActions();
                this.screen.layoutLayers();
            }
        }
        this.initializeVerticalScrollbar(this.screen, this.labelTemplateHeight, newCount);
    }

    @Override
    public void updateTotalWidth(int newWidth) {
        this.lastMaxWidth = newWidth;
        if (this.horizontalScrollbar == ScrollbarMode.optional) {
            Element horizontal = this.getElement().findElementByName("#horizontal-scrollbar-parent");
            if (newWidth > this.listBoxPanelElement.getWidth()) {
                if (horizontal == null) {
                    this.nifty.createElementFromType(this.screen, this.getElement(), this.horizontalScrollbarTemplate.getElementType());
                    this.updateBottomRightElement();
                    this.nifty.executeEndOfFrameElementActions();
                    this.screen.layoutLayers();
                    this.setElementHeight();
                    this.subscribeHorizontalScrollbar();
                }
            } else if (newWidth <= this.listBoxPanelElement.getWidth() && horizontal != null) {
                this.unsubscribeHorizontalScrollbar();
                this.nifty.removeElement(this.screen, horizontal);
                this.nifty.executeEndOfFrameElementActions();
                this.setElementHeight();
            }
        }
        this.initializeHorizontalScrollbar();
        this.ensureWidthConstraints();
    }

    public void ensureWidthConstraints() {
        this.applyWidthConstraints(Math.max(this.lastMaxWidth, this.listBoxPanelElement.getWidth()));
    }

    public void layoutCallback() {
        if (this.listBoxPanelElement == null) {
            return;
        }
        this.ensureWidthConstraints();
        this.initializeHorizontalScrollbar();
    }

    private void applyWidthConstraints(int width) {
        if (this.applyWidthConstraintsLastWidth == width) {
            return;
        }
        this.applyWidthConstraintsLastWidth = width;
        SizeValue newWidthSizeValue = new SizeValue(width + "px");
        for (Element element : this.labelElements) {
            if (element == null) continue;
            element.setConstraintWidth(newWidthSizeValue);
        }
        this.childRootElement.setConstraintWidth(newWidthSizeValue);
        this.getElement().layoutElements();
    }

    @Override
    public void scrollTo(int newPosition) {
        Scrollbar verticalS = this.getVerticalScrollbar();
        if (verticalS != null) {
            verticalS.setValue(newPosition * this.labelTemplateHeight);
        }
    }

    @Override
    public int getWidth(T item) {
        return this.viewConverter.getWidth(this.labelElements[0], item);
    }

    @Override
    public void changeSelectionMode(ListBox.SelectionMode listBoxSelectionMode, boolean forceSelection) {
        this.listBoxImpl.changeSelectionMode(listBoxSelectionMode, forceSelection);
    }

    @Override
    public void addItem(T newItem) {
        this.listBoxImpl.addItem(newItem);
    }

    @Override
    public void insertItem(T item, int index) {
        this.listBoxImpl.insertItem(item, index);
    }

    @Override
    public int itemCount() {
        return this.listBoxImpl.itemCount();
    }

    @Override
    public void clear() {
        this.listBoxImpl.clear();
    }

    @Override
    public void selectItemByIndex(int selectionIndex) {
        this.listBoxImpl.selectItemByIndex(selectionIndex);
    }

    @Override
    public void selectItem(T item) {
        this.listBoxImpl.selectItem(item);
    }

    @Override
    public void selectNext() {
        this.listBoxImpl.selectNext();
    }

    @Override
    public void selectPrevious() {
        this.listBoxImpl.selectPrevious();
    }

    @Override
    public void deselectItemByIndex(int itemIndex) {
        this.listBoxImpl.deselectItemByIndex(itemIndex);
    }

    @Override
    public void deselectItem(T item) {
        this.listBoxImpl.deselectItem(item);
    }

    @Override
    public List<T> getSelection() {
        return this.listBoxImpl.getSelection();
    }

    @Override
    public List<Integer> getSelectedIndices() {
        return this.listBoxImpl.getSelectedIndices();
    }

    @Override
    public void removeItemByIndex(int itemIndex) {
        this.listBoxImpl.removeItemByIndex(itemIndex);
    }

    @Override
    public void removeItem(T item) {
        this.listBoxImpl.removeItem(item);
    }

    @Override
    public List<T> getItems() {
        return this.listBoxImpl.getItems();
    }

    @Override
    public void showItem(T item) {
        this.listBoxImpl.showItem(item);
    }

    @Override
    public void showItemByIndex(int itemIndex) {
        this.listBoxImpl.showItemByIndex(itemIndex);
    }

    @Override
    public void setFocusItem(T item) {
        this.listBoxImpl.setFocusItem(item);
    }

    @Override
    public void setFocusItemByIndex(int itemIndex) {
        this.listBoxImpl.setFocusItemByIndex(itemIndex);
    }

    @Override
    public T getFocusItem() {
        return this.listBoxImpl.getFocusItem();
    }

    @Override
    public int getFocusItemIndex() {
        return this.listBoxImpl.getFocusItemIndex();
    }

    @Override
    public void setListBoxViewConverter(ListBox.ListBoxViewConverter<T> viewConverter) {
        this.viewConverter = viewConverter;
    }

    @Override
    public void publish(ListBoxSelectionChangedEvent<T> event) {
        if (this.getElement().getId() != null) {
            this.nifty.publishEvent(this.getElement().getId(), event);
        }
    }

    @Override
    public void addAllItems(List<T> itemsToAdd) {
        this.listBoxImpl.addAllItems(itemsToAdd);
    }

    @Override
    public void removeAllItems(List<T> itemsToRemove) {
        this.listBoxImpl.removeAllItems(itemsToRemove);
    }

    @Override
    public void sortAllItems() {
        this.listBoxImpl.sortItems(null);
    }

    @Override
    public void sortAllItems(Comparator<T> comperator) {
        this.listBoxImpl.sortItems(comperator);
    }

    @Override
    public int getDisplayItemCount() {
        return this.displayItems;
    }

    @Override
    public void refresh() {
        this.listBoxImpl.updateView();
    }

    private void initSelectionMode(ListBoxImpl<T> listBoxImpl, String selectionMode, String forceSelection) {
        ListBox.SelectionMode listBoxSelectionMode = ListBox.SelectionMode.Single;
        try {
            listBoxSelectionMode = ListBox.SelectionMode.valueOf(selectionMode);
        }
        catch (RuntimeException e) {
            this.log.warning("Unsupported value for selectionMode [" + selectionMode + "]. Fall back to using single selection mode.");
        }
        listBoxImpl.changeSelectionMode(listBoxSelectionMode, "true".equalsIgnoreCase(forceSelection));
    }

    private void initializeScrollPanel(Screen screen) {
        Element vertical;
        Element horizontal;
        if ((this.horizontalScrollbar == ScrollbarMode.off || this.horizontalScrollbar == ScrollbarMode.optional) && (horizontal = this.getElement().findElementByName("#horizontal-scrollbar-parent")) != null) {
            this.nifty.removeElement(screen, horizontal);
        }
        if ((this.verticalScrollbar == ScrollbarMode.off || this.verticalScrollbar == ScrollbarMode.optional) && (vertical = this.getElement().findElementByName("#vertical-scrollbar")) != null) {
            this.nifty.removeElement(screen, vertical);
        }
        this.childRootElement.setConstraintX(new SizeValue("0px"));
        this.childRootElement.setConstraintY(new SizeValue("0px"));
        this.updateBottomRightElement();
        this.nifty.executeEndOfFrameElementActions();
        screen.layoutLayers();
    }

    private void updateBottomRightElement() {
        Element horizontal = this.getElement().findElementByName("#horizontal-scrollbar-parent");
        Element vertical = this.getElement().findElementByName("#vertical-scrollbar");
        Element bottomRight = this.getElement().findElementByName("#bottom-right");
        if (horizontal != null) {
            if (vertical == null) {
                if (bottomRight != null) {
                    this.nifty.removeElement(this.screen, bottomRight);
                    this.nifty.executeEndOfFrameElementActions();
                    this.initializeHorizontalScrollbar();
                }
            } else if (bottomRight == null) {
                this.nifty.createElementFromType(this.screen, horizontal, this.bottomRightTemplate.getElementType());
                this.initializeHorizontalScrollbar();
            }
        }
    }

    private void initializeHorizontalScrollbar() {
        Scrollbar horizontalS = this.getHorizontalScrollbar();
        if (horizontalS != null && horizontalS.isBound()) {
            horizontalS.setWorldMax(this.lastMaxWidth);
            horizontalS.setWorldPageSize(this.listBoxPanelElement.getWidth());
        }
    }

    private void initializeVerticalScrollbar(Screen screen, float labelTemplateHeight, int itemCount) {
        Scrollbar verticalS = this.getVerticalScrollbar();
        if (verticalS != null && verticalS.isBound()) {
            verticalS.setWorldMax((float)itemCount * labelTemplateHeight);
            verticalS.setWorldPageSize((float)this.displayItems * labelTemplateHeight);
            verticalS.setButtonStepSize(labelTemplateHeight);
        }
    }

    private void createLabels() {
        if (this.labelTemplateElement == null) {
            return;
        }
        for (Element e : this.childRootElement.getElements()) {
            this.nifty.removeElement(this.screen, e);
        }
        for (int i = 0; i < this.displayItems; ++i) {
            ElementType templateType = this.labelTemplateElement.getElementType().copy();
            templateType.getAttributes().set("id", NiftyIdCreator.generate());
            this.labelElements[i] = this.nifty.createElementFromType(this.screen, this.childRootElement, templateType);
            ListBoxItemController listBoxItemController = (ListBoxItemController)this.labelElements[i].getControl(ListBoxItemController.class);
            if (listBoxItemController == null) continue;
            listBoxItemController.setListBox(this.listBoxImpl);
        }
    }

    private void initializeScrollElementHeight() {
        this.scrollElement.setConstraintHeight(new SizeValue(this.displayItems * this.labelTemplateHeight + "px"));
    }

    private void ensureVerticalScrollbar() {
        if (this.displayItems == 1) {
            this.verticalScrollbar = ScrollbarMode.off;
        }
    }

    private void setElementHeight() {
        this.getElement().setConstraintHeight(new SizeValue(this.displayItems * this.labelTemplateHeight + this.findHorizontalScrollbarHeight() + "px"));
        this.screen.layoutLayers();
    }

    private int findHorizontalScrollbarHeight() {
        int horizontalScrollbarElementHeight = 0;
        Element horizontalScrollbarElement = this.getElement().findElementByName("#horizontal-scrollbar");
        if (horizontalScrollbarElement != null) {
            horizontalScrollbarElementHeight = horizontalScrollbarElement.getHeight();
        }
        return horizontalScrollbarElementHeight;
    }

    private void initLabelTemplateData() {
        if (this.labelTemplateElement == null) {
            return;
        }
        this.labelTemplateElement.getParent().layoutElements();
        this.labelTemplateHeight = this.labelTemplateElement.getHeight();
        this.nifty.removeElement(this.screen, this.labelTemplateElement);
    }

    private void connectListBoxAndListBoxPanel() {
        ListBoxPanel listBoxPanel = (ListBoxPanel)this.listBoxPanelElement.getControl(ListBoxPanel.class);
        listBoxPanel.setListBox(this.listBoxImpl);
    }

    private void displayElement(int index, T item) {
        this.viewConverter.display(this.labelElements[index], item);
    }

    private void handleElementSelection(int index, T item, List<Integer> selectedElements) {
        if (item != null && selectedElements.contains(index)) {
            this.labelElements[index].startEffect(EffectEventId.onCustom, null, "select");
        } else {
            this.labelElements[index].resetSingleEffect(EffectEventId.onCustom, "select");
        }
    }

    private void handleElementFocus(int index, int focusElement) {
        ListBoxPanel listBoxPanel = (ListBoxPanel)this.listBoxPanelElement.getControl(ListBoxPanel.class);
        if (listBoxPanel.hasFocus()) {
            if (focusElement == index) {
                this.labelElements[index].startEffect(EffectEventId.onCustom, null, "focus");
            } else {
                this.labelElements[index].resetSingleEffect(EffectEventId.onCustom, "focus");
            }
        } else {
            this.labelElements[index].resetSingleEffect(EffectEventId.onCustom, "focus");
        }
    }

    private void setListBoxItemIndex(int itemIndex) {
        ListBoxItemController listBoxItemController = (ListBoxItemController)this.labelElements[itemIndex].getControl(ListBoxItemController.class);
        if (listBoxItemController != null) {
            listBoxItemController.setItemIndex(itemIndex);
        }
    }

    private Scrollbar getVerticalScrollbar() {
        return this.getScrollbar("#vertical-scrollbar");
    }

    private Scrollbar getHorizontalScrollbar() {
        return this.getScrollbar("#horizontal-scrollbar");
    }

    private Scrollbar getScrollbar(String id) {
        return (Scrollbar)this.getElement().findNiftyControl(id, Scrollbar.class);
    }

    private ScrollbarMode getScrollbarMode(String key) {
        try {
            return ScrollbarMode.valueOf(this.parameter.getProperty(key, ScrollbarMode.on.toString()));
        }
        catch (Exception e) {
            this.log.warning("unknown scrollbar mode [" + key + "] falling back to 'on'");
            return ScrollbarMode.on;
        }
    }

    private static enum ScrollbarMode {
        off,
        on,
        optional;

    }
}

