/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ant_deb_task;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class GZipOutputStream
extends DeflaterOutputStream {
    private static final int GZIP_MAGIC = 35615;
    private static final int TRAILER_SIZE = 8;
    public static final byte FS_FAT = 0;
    public static final byte FS_AMIGA = 1;
    public static final byte FS_VMS = 2;
    public static final byte FS_UNIX = 3;
    public static final byte FS_VM_CMS = 4;
    public static final byte FS_ATARI = 5;
    public static final byte FS_HPFS = 6;
    public static final byte FS_MAC = 7;
    public static final byte FS_Z_SYSTEM = 8;
    public static final byte FS_CPM = 9;
    public static final byte FS_TOPS_20 = 10;
    public static final byte FS_NTFS = 11;
    public static final byte FS_QDOS = 12;
    public static final byte FS_ACORN_RISC = 11;
    public static final byte FS_UNKNOWN = -1;
    protected CRC32 crc = new CRC32();
    private boolean closed = false;
    private int level;
    private byte fileSystem = 0;
    private boolean headerWritten = false;

    public GZipOutputStream(OutputStream out, int level) throws IOException {
        super(out, new Deflater(level, true), 512);
        this.level = level;
        this.fileSystem = 0;
        this.crc.reset();
    }

    public void setFileSystem(byte value) {
        this.fileSystem = value;
    }

    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.def.end();
            this.closed = true;
        }
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        if (!this.headerWritten) {
            this.writeHeader();
        }
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    public void finish() throws IOException {
        if (!this.headerWritten) {
            this.writeHeader();
        }
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                int len = this.def.deflate(this.buf, 0, this.buf.length);
                if (this.def.finished() && len <= this.buf.length - 8) {
                    this.writeTrailer(this.buf, len);
                    this.out.write(this.buf, 0, len += 8);
                    return;
                }
                if (len <= 0) continue;
                this.out.write(this.buf, 0, len);
            }
            byte[] trailer = new byte[8];
            this.writeTrailer(trailer, 0);
            this.out.write(trailer);
        }
    }

    private void writeHeader() throws IOException {
        byte[] header = new byte[10];
        header[0] = 31;
        header[1] = -117;
        header[2] = 8;
        header[3] = 0;
        header[4] = 0;
        header[5] = 0;
        header[6] = 0;
        header[7] = 0;
        switch (this.level) {
            case 9: {
                header[8] = 2;
                break;
            }
            case 1: {
                header[8] = 4;
                break;
            }
            default: {
                header[8] = 0;
            }
        }
        header[9] = this.fileSystem;
        this.out.write(header);
        this.headerWritten = true;
    }

    private void writeTrailer(byte[] buf, int offset) throws IOException {
        GZipOutputStream.writeInt((int)this.crc.getValue(), buf, offset);
        GZipOutputStream.writeInt(this.def.getTotalIn(), buf, offset + 4);
    }

    private static void writeInt(int i, byte[] buf, int offset) throws IOException {
        GZipOutputStream.writeShort(i & 0xFFFF, buf, offset);
        GZipOutputStream.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
    }

    private static void writeShort(int s, byte[] buf, int offset) throws IOException {
        buf[offset] = (byte)(s & 0xFF);
        buf[offset + 1] = (byte)(s >> 8 & 0xFF);
    }
}

