/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.tutorial;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyImageMode;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageMode;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.spi.time.impl.AccurateTimeProvider;
import java.util.Random;

public class SnowEffect
implements EffectImpl {
    private Snowflake[] snow = new Snowflake[256];
    private int screenWidth;
    private int screenHeight;
    private Random random = new Random();
    private TimeProvider timeProvider = new AccurateTimeProvider();
    private NiftyImage niftyImage;
    private NiftyImageMode image0 = NiftyImageMode.subImage((int)0, (int)0, (int)1, (int)1);
    private NiftyImageMode image1 = NiftyImageMode.subImage((int)2, (int)0, (int)3, (int)3);
    private NiftyImageMode image2 = NiftyImageMode.subImage((int)6, (int)0, (int)4, (int)4);
    private NiftyImageMode image3 = NiftyImageMode.subImage((int)0, (int)4, (int)4, (int)4);
    private NiftyImageMode image4 = NiftyImageMode.subImage((int)5, (int)5, (int)5, (int)5);

    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.niftyImage = nifty.getRenderEngine().createImage(nifty.getCurrentScreen(), "tutorial/snow.png", true);
        this.screenWidth = nifty.getCurrentScreen().getRootElement().getWidth();
        this.screenHeight = nifty.getCurrentScreen().getRootElement().getHeight();
        for (int i = 0; i < this.snow.length; ++i) {
            this.snow[i] = new Snowflake(this.timeProvider.getMsTime());
        }
    }

    public void deactivate() {
        this.niftyImage.dispose();
    }

    public void execute(Element element, float effectTime, Falloff falloff, NiftyRenderEngine r) {
        for (Snowflake snowflake : this.snow) {
            snowflake.update(this.timeProvider.getMsTime());
            snowflake.render(r);
        }
    }

    private class Snowflake {
        private int x;
        private int initialX;
        private int y;
        private NiftyImageMode imageMode;
        private int sizeX;
        private int sizeY;
        private long speed;
        private boolean enabled = true;
        private long startTime;
        private int speedX;
        private int dir;
        private int timeX;

        public Snowflake(long startTime) {
            this.initPosition(startTime);
            this.y = SnowEffect.this.random.nextInt(SnowEffect.this.screenHeight);
            this.speed = this.getNewSpeed();
            this.startTime = startTime + (long)SnowEffect.this.random.nextInt((int)this.speed);
        }

        private int getNewSpeed() {
            return SnowEffect.this.random.nextInt(5000) + 8000;
        }

        private void initPosition(long currentTime) {
            this.initialX = this.x = SnowEffect.this.random.nextInt(SnowEffect.this.screenWidth);
            switch (SnowEffect.this.random.nextInt(5)) {
                case 0: {
                    this.imageMode = SnowEffect.this.image0;
                    this.sizeX = 1;
                    this.sizeY = 1;
                    break;
                }
                case 1: {
                    this.imageMode = SnowEffect.this.image1;
                    this.sizeX = 3;
                    this.sizeY = 3;
                    break;
                }
                case 2: {
                    this.imageMode = SnowEffect.this.image2;
                    this.sizeX = 4;
                    this.sizeY = 4;
                    break;
                }
                case 3: {
                    this.imageMode = SnowEffect.this.image3;
                    this.sizeX = 4;
                    this.sizeY = 4;
                    break;
                }
                case 4: {
                    this.imageMode = SnowEffect.this.image4;
                    this.sizeX = 5;
                    this.sizeY = 5;
                }
            }
            this.speed = this.getNewSpeed();
            this.initWind();
            this.startTime = currentTime;
        }

        private void initWind() {
            this.dir = SnowEffect.this.random.nextInt(2) * -1;
            this.speedX = SnowEffect.this.random.nextInt(50) + 50;
            this.timeX = SnowEffect.this.random.nextInt(5000) + 2500;
        }

        public void update(long currentTime) {
            long time = currentTime - this.startTime;
            float t = this.getSinusValue(currentTime);
            this.x = (int)(t * (float)this.speedX * (float)this.dir + (float)this.initialX);
            float value = (float)(1.0 - (double)((float)(this.speed - time) / (float)this.speed));
            this.y = (int)((float)SnowEffect.this.screenHeight * value);
            if (this.y > SnowEffect.this.screenHeight) {
                this.initPosition(currentTime);
                this.enabled = true;
            }
        }

        public void render(NiftyRenderEngine r) {
            if (this.enabled) {
                SnowEffect.this.niftyImage.setImageMode((ImageMode)this.imageMode);
                if (this.y < 100) {
                    return;
                }
                if (this.y < 140) {
                    r.setColorAlpha(1.0f - (140.0f - (float)this.y) / 40.0f);
                } else if (this.y > 628 && this.y < 668) {
                    float max = 628.0f;
                    r.setColorAlpha(1.0f - ((float)this.y - max) / 40.0f);
                } else {
                    if (this.y >= 668) {
                        return;
                    }
                    r.setColorAlpha(1.0f);
                }
                r.renderImage(SnowEffect.this.niftyImage, this.x, this.y, this.sizeX, this.sizeY);
            }
        }

        private float getSinusValue(long x) {
            return (float)((Math.sin(Math.PI * (double)x / (double)this.timeX) + 1.0) / 2.0);
        }
    }
}

