/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.resolution;

import de.lessvoid.nifty.examples.resolution.ResolutionControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

public class ResolutionControlLWJGL
implements ResolutionControl<DisplayMode> {
    private final boolean coreProfile;

    public ResolutionControlLWJGL(boolean coreProfile) {
        this.coreProfile = coreProfile;
    }

    @Override
    public Collection<DisplayMode> getResolutions() {
        try {
            DisplayMode currentMode = Display.getDisplayMode();
            ArrayList<DisplayMode> sorted = new ArrayList<DisplayMode>();
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                DisplayMode mode = modes[i];
                if (mode.getBitsPerPixel() != 32 || mode.getFrequency() != currentMode.getFrequency()) continue;
                sorted.add(mode);
            }
            Collections.sort(sorted, new Comparator<DisplayMode>(){

                @Override
                public int compare(DisplayMode o1, DisplayMode o2) {
                    int widthCompare = Integer.valueOf(o1.getWidth()).compareTo(o2.getWidth());
                    if (widthCompare != 0) {
                        return widthCompare;
                    }
                    int heightCompare = Integer.valueOf(o1.getHeight()).compareTo(o2.getHeight());
                    if (heightCompare != 0) {
                        return heightCompare;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            });
            return sorted;
        }
        catch (Exception exception) {
            return new ArrayList<DisplayMode>();
        }
    }

    @Override
    public void setResolution(DisplayMode newResolution) {
        try {
            Display.setDisplayMode((DisplayMode)newResolution);
            if (!this.coreProfile) {
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glOrtho((double)0.0, (double)newResolution.getWidth(), (double)newResolution.getHeight(), (double)0.0, (double)-9999.0, (double)9999.0);
                GL11.glMatrixMode((int)5888);
            }
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DisplayMode getCurrentResolution() {
        return Display.getDisplayMode();
    }
}

