/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.dropdown;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.DropDownSelectionChangedEvent;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.RadioButtonGroup;
import de.lessvoid.nifty.controls.RadioButtonGroupStateChangedEvent;
import de.lessvoid.nifty.controls.RadioButtonStateChangedEvent;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.TextFieldChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.examples.defaultcontrols.common.JustAnExampleModelClass;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class DropDownDialogController
implements Controller {
    private Screen screen;
    private TextField addDropDownItemText;
    private Button addDropDownItemButton;
    private DropDown<JustAnExampleModelClass> dropDown;
    private Label selectedItem;
    private Button removeDropDownItemButton;
    private Label selectedIndices;
    private RadioButtonGroup radioButtonGroup1;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        this.screen = screen;
        this.addDropDownItemText = (TextField)screen.findNiftyControl("addDropDownItemText", TextField.class);
        this.addDropDownItemButton = (Button)screen.findNiftyControl("addDropDownItemButton", Button.class);
        this.dropDown = (DropDown)screen.findNiftyControl("dropDown", DropDown.class);
        this.selectedItem = (Label)screen.findNiftyControl("selectedItem", Label.class);
        this.removeDropDownItemButton = (Button)screen.findNiftyControl("removeDropDownItemButton", Button.class);
        this.selectedIndices = (Label)element.findNiftyControl("#selectedIndices", Label.class);
        this.radioButtonGroup1 = (RadioButtonGroup)screen.findNiftyControl("RadioGroup-1", RadioButtonGroup.class);
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
        this.setDropDownItemButtonState();
        this.setRemoveDropDownItemButtonState(null);
        this.updateSelectedIndexLabel(this.dropDown.getSelectedIndex());
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    @NiftyEventSubscriber(id="addDropDownItemText")
    public void onAppendTextFieldChanged(String id, TextFieldChangedEvent event) {
        this.setDropDownItemButtonState();
    }

    @NiftyEventSubscriber(id="addDropDownItemText")
    public void onAddTextFieldInputEvent(String id, NiftyInputEvent event) {
        if (NiftyInputEvent.SubmitText.equals((Object)event)) {
            this.addDropDownItemButton.activate();
        }
    }

    @NiftyEventSubscriber(id="addDropDownItemButton")
    public void onAppendButtonClicked(String id, ButtonClickedEvent event) {
        if (this.addDropDownItemText.getText().length() == 0) {
            return;
        }
        JustAnExampleModelClass newItem = new JustAnExampleModelClass(this.addDropDownItemText.getText());
        this.dropDown.addItem((Object)newItem);
        this.dropDown.selectItem((Object)newItem);
    }

    @NiftyEventSubscriber(id="dropDown")
    public void onDropDownSelectionChanged(String id, DropDownSelectionChangedEvent<JustAnExampleModelClass> event) {
        if (event.getSelection() == null) {
            this.selectedItem.setText("");
        } else {
            this.selectedItem.setText(((JustAnExampleModelClass)event.getSelection()).toString());
        }
        this.setRemoveDropDownItemButtonState((JustAnExampleModelClass)event.getSelection());
        this.updateSelectedIndexLabel(event.getSelectionItemIndex());
    }

    @NiftyEventSubscriber(id="removeDropDownItemButton")
    public void onRemoveDropDownItemClicked(String id, ButtonClickedEvent event) {
        this.dropDown.removeItem(this.dropDown.getSelection());
    }

    @NiftyEventSubscriber(id="option-1")
    public void onOption1Changed(String id, RadioButtonStateChangedEvent event) {
        ((Label)this.screen.findNiftyControl("option-1-changed", Label.class)).setText(String.valueOf(event.isSelected()));
    }

    @NiftyEventSubscriber(id="option-2")
    public void onOption2Changed(String id, RadioButtonStateChangedEvent event) {
        ((Label)this.screen.findNiftyControl("option-2-changed", Label.class)).setText(String.valueOf(event.isSelected()));
    }

    @NiftyEventSubscriber(id="option-3")
    public void onOption3Changed(String id, RadioButtonStateChangedEvent event) {
        ((Label)this.screen.findNiftyControl("option-3-changed", Label.class)).setText(String.valueOf(event.isSelected()));
    }

    @NiftyEventSubscriber(id="option-4")
    public void onOption4Changed(String id, RadioButtonStateChangedEvent event) {
        ((Label)this.screen.findNiftyControl("option-4-changed", Label.class)).setText(String.valueOf(event.isSelected()));
    }

    @NiftyEventSubscriber(id="radioGroupAllowDeselection")
    public void onRadioGroupAllowDeselectionChanged(String id, CheckBoxStateChangedEvent event) {
        this.radioButtonGroup1.allowDeselection(event.isChecked());
    }

    @NiftyEventSubscriber(id="RadioGroup-1")
    public void onRadioGroup1Changed(String id, RadioButtonGroupStateChangedEvent event) {
        ((Label)this.screen.findNiftyControl("RadioGroup-1-changed", Label.class)).setText(event.getSelectedId() + " (" + event.getPreviousSelectedId() + ")");
    }

    @NiftyEventSubscriber(id="radioGroupDisable")
    public void onRadioGroupDisableCheckBox(String id, CheckBoxStateChangedEvent event) {
        this.radioButtonGroup1.setEnabled(!event.isChecked());
    }

    private void setDropDownItemButtonState() {
        if (this.addDropDownItemText.getText().isEmpty()) {
            this.addDropDownItemButton.disable();
        } else {
            this.addDropDownItemButton.enable();
        }
    }

    private void setRemoveDropDownItemButtonState(JustAnExampleModelClass item) {
        if (item == null) {
            this.removeDropDownItemButton.disable();
        } else {
            this.removeDropDownItemButton.enable();
        }
    }

    private void updateSelectedIndexLabel(int selectedItemIndex) {
        if (selectedItemIndex == -1) {
            this.selectedIndices.setText("N/A");
            return;
        }
        this.selectedIndices.setText(String.valueOf(selectedItemIndex));
    }
}

