/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont.impl.format.angelcode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jglfont.impl.format.BitmapFontData;
import org.jglfont.impl.format.BitmapFontLoader;
import org.jglfont.impl.format.angelcode.AngelCodeLine;
import org.jglfont.impl.format.angelcode.AngelCodeLineData;
import org.jglfont.impl.format.angelcode.AngelCodeLineParser;
import org.jglfont.impl.format.angelcode.AngelCodeLineProcessors;

public class AngelCodeBitmapFontLoader
implements BitmapFontLoader {
    private static final Logger log = Logger.getLogger(AngelCodeBitmapFontLoader.class.getName());
    private final AngelCodeLineParser parser = new AngelCodeLineParser();
    private final AngelCodeLineData parsed = new AngelCodeLineData();
    private final AngelCodeLineProcessors lineProcessors;

    public AngelCodeBitmapFontLoader(AngelCodeLineProcessors lineProcessors) {
        this.lineProcessors = lineProcessors;
    }

    @Override
    public BitmapFontData load(InputStream in) throws IOException {
        BitmapFontData result = new BitmapFontData();
        this.load(in, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream in, BitmapFontData bitmapFont) throws IOException {
        if (in == null) {
            throw new IOException("InputStream is null");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                if (split[0].length() == 0) {
                    break;
                }
                this.parser.parse(line, this.parsed);
                AngelCodeLine processor = this.lineProcessors.get(split[0]);
                if (processor == null || processor.process(this.parsed, bitmapFont)) continue;
                log.warning("parsing error for line [" + line + "] using " + processor + " with " + this.parsed);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "error while parsing font file: ", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }
}

