/*
 * Decompiled with CFR 0.152.
 */
package tgaimageplugin;

import java.awt.image.Raster;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import tgaimageplugin.TGAHeader;
import tgaimageplugin.TGAImageWriterSpi;

public class TGAImageWriter
extends ImageWriter {
    public TGAImageWriter(TGAImageWriterSpi spi) {
        super(spi);
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        Raster ri = image.getRaster();
        if (ri == null) {
            ri = image.getRenderedImage().getData();
        }
        ImageOutputStream out = (ImageOutputStream)this.getOutput();
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        out.writeByte(0);
        out.writeByte((byte)TGAHeader.ColorMapType.NO_COLOR_MAP.ordinal());
        out.writeByte((byte)TGAHeader.ImageType.UNCOMPRESSED_TRUE_COLOR.code());
        out.writeShort(0);
        out.writeShort(0);
        out.writeByte(0);
        out.writeShort(0);
        out.writeShort(0);
        out.writeShort(ri.getWidth());
        out.writeShort(ri.getHeight());
        out.writeByte(24);
        out.writeByte(32);
        int[] buffer = new int[ri.getNumBands()];
        for (int y = 0; y < ri.getHeight(); ++y) {
            for (int x = 0; x < ri.getWidth(); ++x) {
                int red;
                int green;
                int blue;
                ri.getPixel(x, y, buffer);
                if (buffer.length < 2) {
                    green = blue = buffer[0];
                    red = blue;
                } else {
                    red = buffer[0];
                    green = buffer[1];
                    blue = buffer[2];
                }
                out.writeByte(blue);
                out.writeByte(green);
                out.writeByte(red);
            }
        }
    }
}

