/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.optimize;

import com.jme3.light.Light;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jme3tools.optimize.OCTTriangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriangleCollector {
    private static final GeomTriComparator comparator = new GeomTriComparator();

    /*
     * WARNING - void declaration
     */
    public static final List<Geometry> gatherTris(Geometry[] inGeoms, List<OCTTriangle> tris) {
        Collections.sort(tris, comparator);
        HashMap<Integer, Range> ranges = new HashMap<Integer, Range>();
        for (int i = 0; i < tris.size(); ++i) {
            Range r = (Range)ranges.get(tris.get(i).getGeometryIndex());
            if (r != null) {
                r.setLength(r.getLength() + 1);
                continue;
            }
            ranges.put(tris.get(i).getGeometryIndex(), new Range(i, 1));
        }
        ArrayList<Geometry> newGeoms = new ArrayList<Geometry>();
        int[] vertIndicies = new int[3];
        int[] newIndices = new int[3];
        boolean[] vertexCreated = new boolean[3];
        HashMap<Integer, Integer> indexCache = new HashMap<Integer, Integer>();
        for (Map.Entry entry : ranges.entrySet()) {
            void var20_26;
            int inGeomIndex = (Integer)entry.getKey();
            int outOffset = ((Range)entry.getValue()).start;
            int outLength = ((Range)entry.getValue()).length;
            Geometry inGeom = inGeoms[inGeomIndex];
            Mesh in = inGeom.getMesh();
            Mesh out = new Mesh();
            int outElementCount = outLength * 3;
            ShortBuffer ib = BufferUtils.createShortBuffer(outElementCount);
            out.setBuffer(VertexBuffer.Type.Index, 3, ib);
            IntMap<VertexBuffer> bufs = in.getBuffers();
            for (IntMap.Entry<VertexBuffer> entry2 : bufs) {
                VertexBuffer vb = entry2.getValue();
                if (vb.getBufferType() == VertexBuffer.Type.Index) continue;
                Buffer buffer = VertexBuffer.createBuffer(vb.getFormat(), vb.getNumComponents(), outElementCount);
                VertexBuffer outVb = new VertexBuffer(vb.getBufferType());
                outVb.setNormalized(vb.isNormalized());
                outVb.setupData(vb.getUsage(), vb.getNumComponents(), vb.getFormat(), buffer);
                out.setBuffer(outVb);
            }
            int currentVertex = 0;
            int n = outOffset;
            while (var20_26 < outOffset + outLength) {
                OCTTriangle t = tris.get((int)var20_26);
                in.getTriangle(t.getTriangleIndex(), vertIndicies);
                Integer n2 = (Integer)indexCache.get(vertIndicies[0]);
                Integer i1 = (Integer)indexCache.get(vertIndicies[1]);
                Integer i2 = (Integer)indexCache.get(vertIndicies[2]);
                if (n2 == null) {
                    vertexCreated[0] = true;
                    newIndices[0] = currentVertex++;
                    indexCache.put(vertIndicies[0], newIndices[0]);
                } else {
                    newIndices[0] = n2;
                    vertexCreated[0] = false;
                }
                if (i1 == null) {
                    vertexCreated[1] = true;
                    newIndices[1] = currentVertex++;
                    indexCache.put(vertIndicies[1], newIndices[1]);
                } else {
                    newIndices[1] = i1;
                    vertexCreated[1] = false;
                }
                if (i2 == null) {
                    vertexCreated[2] = true;
                    newIndices[2] = currentVertex++;
                    indexCache.put(vertIndicies[2], newIndices[2]);
                } else {
                    newIndices[2] = i2;
                    vertexCreated[2] = false;
                }
                IntMap<VertexBuffer> inbufs = in.getBuffers();
                for (IntMap.Entry<VertexBuffer> entry3 : inbufs) {
                    VertexBuffer vb = entry3.getValue();
                    if (vb.getBufferType() == VertexBuffer.Type.Index) continue;
                    VertexBuffer outVb = out.getBuffer(vb.getBufferType());
                    for (int v = 0; v < 3; ++v) {
                        if (!vertexCreated[v]) continue;
                        vb.copyElement(vertIndicies[v], outVb, newIndices[v]);
                    }
                }
                ib.put((short)newIndices[0]).put((short)newIndices[1]).put((short)newIndices[2]);
                ++var20_26;
            }
            ib.clear();
            indexCache.clear();
            IntMap<VertexBuffer> intMap = out.getBuffers();
            for (IntMap.Entry<VertexBuffer> entry4 : intMap) {
                VertexBuffer vb = entry4.getValue();
                if (vb.getBufferType() == VertexBuffer.Type.Index) continue;
                vb.compact(currentVertex);
            }
            out.updateBound();
            out.updateCounts();
            out.setStatic();
            Geometry outGeom = new Geometry("Geom" + entry.getKey(), out);
            outGeom.setLocalTransform(inGeom.getWorldTransform());
            outGeom.setMaterial(inGeom.getMaterial());
            for (Light light : inGeom.getWorldLightList()) {
                outGeom.addLight(light);
            }
            outGeom.updateGeometricState();
            newGeoms.add(outGeom);
        }
        return newGeoms;
    }

    private static class Range {
        private int start;
        private int length;

        public Range(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GeomTriComparator
    implements Comparator<OCTTriangle> {
        private GeomTriComparator() {
        }

        @Override
        public int compare(OCTTriangle a, OCTTriangle b) {
            if (a.getGeometryIndex() < b.getGeometryIndex()) {
                return -1;
            }
            if (a.getGeometryIndex() > b.getGeometryIndex()) {
                return 1;
            }
            return 0;
        }
    }
}

