/*
 * Decompiled with CFR 0.152.
 */
package jme3test.android;

import android.app.Activity;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.view.View;
import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeSystem;
import com.jme3.system.android.OGLESContext;
import java.util.logging.Logger;

public class AndroidActivity
extends Activity {
    private static final Logger logger = Logger.getLogger(AndroidActivity.class.getName());
    private OGLESContext ctx;
    private GLSurfaceView view;
    private boolean useVA = false;
    private boolean verboseLogging = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        JmeSystem.setResources(this.getResources());
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        AppSettings settings = new AppSettings(true);
        String testClassName = this.getIntent().getStringExtra(AndroidActivity.class.getName() + ".TEST_CLASS_NAME");
        logger.info("test class name: [" + testClassName + "]");
        String appClass = testClassName != null ? testClassName : "jme3test.android.SimpleTexturedTest";
        this.useVA = this.getIntent().getBooleanExtra(AndroidActivity.class.getName() + ".USE_VA", false);
        logger.info("USE_VA -> [" + this.useVA + "]");
        settings.putBoolean("USE_VA", this.useVA);
        this.verboseLogging = this.getIntent().getBooleanExtra(AndroidActivity.class.getName() + ".VERBOSE_LOGGING", false);
        settings.putBoolean("VERBOSE_LOGGING", this.verboseLogging);
        Application app = null;
        try {
            Class<?> clazz = Class.forName(appClass);
            app = (Application)clazz.newInstance();
            if (app instanceof SimpleApplication) {
                ((SimpleApplication)app).setShowSettings(false);
            }
            logger.info("setting settings ...");
            app.setSettings(settings);
            logger.info("setting settings ... done.");
            logger.info("starting app ...");
            app.start();
            logger.info("starting app ... done.");
            if (app instanceof SimpleApplication) {
                ((SimpleApplication)app).getGuiNode().detachAllChildren();
            }
            logger.info("creating context ...");
            this.ctx = (OGLESContext)app.getContext();
            logger.info("creating context ... done.");
            this.ctx.setSettings(settings);
            logger.info("creating view ...");
            this.view = this.ctx.createView(this);
            logger.info("creating view ... done.");
            logger.info("setting content view ...");
            this.setContentView((View)this.view);
            logger.info("setting content done ...");
        }
        catch (Throwable exception) {
            logger.warning("exception: " + exception);
            exception.printStackTrace(System.err);
        }
    }

    protected void onResume() {
        logger.info("onResume ...");
        super.onResume();
        logger.info("view.onResume ...");
        this.view.onResume();
        logger.info("view.onResume ... done.");
        logger.info("onResume ... done.");
    }

    protected void onPause() {
        super.onPause();
        this.view.onPause();
    }
}

