/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

public final class FastInteger {
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int SIZE = 32;
    private static final int[] decimalScale = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};

    public static boolean toCharArray(int value, char[] output) {
        int count;
        if (value == 0) {
            output[0] = 48;
            output[1] = '\u0000';
            return true;
        }
        if (value < 1000 && value > -1000) {
            int res;
            int positive_value = value < 0 ? -value : value;
            int first_digit = 0;
            if (value < 0) {
                output[0] = 45;
                ++first_digit;
            }
            int last_digit = first_digit;
            int quot = positive_value;
            do {
                res = quot / 10;
                int digit_value = quot - ((res << 3) + (res << 1));
                output[last_digit++] = (char)(digit_value += 48);
            } while ((quot = res) != 0);
            int count2 = last_digit--;
            do {
                char tmp = output[last_digit];
                output[last_digit--] = output[first_digit];
                output[first_digit++] = tmp;
            } while (first_digit < last_digit);
            output[count2] = '\u0000';
            return true;
        }
        if (value == Integer.MIN_VALUE) {
            System.arraycopy("-2147483648".toCharArray(), 0, output, 0, 12);
            output[12] = '\u0000';
            return true;
        }
        int positive_value = value < 0 ? -value : value;
        int first_digit = 0;
        if (value < 0) {
            output[0] = 45;
            first_digit = (byte)(first_digit + 1);
        }
        int last_digit = first_digit;
        boolean start = false;
        for (int i = 0; i < 9; ++i) {
            count = 0;
            int number = decimalScale[i];
            if (positive_value < number) {
                if (!start) continue;
                int n = last_digit;
                last_digit = (byte)(last_digit + 1);
                output[n] = 48;
                continue;
            }
            if (i > 0) {
                number = decimalScale[i] << 3;
                if (positive_value >= number) {
                    positive_value -= number;
                    count = (byte)(count + 8);
                }
                if (positive_value >= (number = decimalScale[i] << 2)) {
                    positive_value -= number;
                    count = (byte)(count + 4);
                }
            }
            if (positive_value >= (number = decimalScale[i] << 1)) {
                positive_value -= number;
                count = (byte)(count + 2);
            }
            if (positive_value >= decimalScale[i]) {
                positive_value -= decimalScale[i];
                count = (byte)(count + 1);
            }
            if (count > 0 && !start) {
                start = true;
            }
            if (!start) continue;
            int n = last_digit;
            last_digit = (byte)(last_digit + 1);
            output[n] = (char)(count + 48);
        }
        int n = last_digit;
        last_digit = (byte)(last_digit + 1);
        output[n] = (char)(positive_value + 48);
        output[last_digit] = '\u0000';
        int n2 = last_digit;
        last_digit = (byte)(last_digit - 1);
        count = n2;
        return true;
    }

    public static int highestOneBit(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i & ~(i >>> 1);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    public static int numberOfLeadingZeros(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return FastInteger.bitCount(~i);
    }

    public static int numberOfTrailingZeros(int i) {
        return FastInteger.bitCount((i & -i) - 1);
    }

    public static int bitCount(int i) {
        i -= i >> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >> 2 & 0x33333333);
        i = (i >> 4) + i & 0xF0F0F0F;
        i += i >> 8;
        i += i >> 16;
        return i & 0x3F;
    }

    public static int rotateLeft(int i, int distance) {
        if (distance == 0) {
            return i;
        }
        return i << distance | i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        if (distance == 0) {
            return i;
        }
        return i >>> distance | i << -distance;
    }

    public static int reverseBytes(int i) {
        int b3 = i >>> 24;
        int b2 = i >>> 8 & 0xFF00;
        int b1 = (i & 0xFF00) << 8;
        int b0 = i << 24;
        return b0 | b1 | b2 | b3;
    }

    public static int reverse(int i) {
        i = (i & 0x55555555) << 1 | i >> 1 & 0x55555555;
        i = (i & 0x33333333) << 2 | i >> 2 & 0x33333333;
        i = (i & 0xF0F0F0F) << 4 | i >> 4 & 0xF0F0F0F;
        return FastInteger.reverseBytes(i);
    }

    public static int signum(int i) {
        return i == 0 ? 0 : (i < 0 ? -1 : 1);
    }

    public static Integer valueOf(int i) {
        if (i < -128 || i > 127) {
            return new Integer(i);
        }
        return valueOfCache.CACHE[i + 128];
    }

    static class valueOfCache {
        static final Integer[] CACHE = new Integer[256];

        valueOfCache() {
        }

        static {
            for (int i = -128; i <= 127; ++i) {
                valueOfCache.CACHE[i + 128] = new Integer(i);
            }
        }
    }
}

