/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.math.FastMath;
import com.jme3.terrain.heightmap.AbstractHeightMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;

public class MidpointDisplacementHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(MidpointDisplacementHeightMap.class.getName());
    private float range;
    private float persistence;
    private long seed;

    public MidpointDisplacementHeightMap(int size, float range, float persistence, long seed) throws Exception {
        if (size < 0 || !FastMath.isPowerOfTwo(size - 1)) {
            throw new JMException("The size is negative or not of the form 2^N +1 (a power of two plus one)");
        }
        this.size = size;
        this.range = range;
        this.persistence = persistence;
        this.seed = seed;
        this.load();
    }

    public MidpointDisplacementHeightMap(int size, float range, float persistence) throws Exception {
        this(size, range, persistence, new Random().nextLong());
    }

    public boolean load() {
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new float[this.size * this.size];
        float[][] tempBuffer = new float[this.size][this.size];
        Random random = new Random(this.seed);
        tempBuffer[0][0] = random.nextFloat();
        tempBuffer[0][this.size - 1] = random.nextFloat();
        tempBuffer[this.size - 1][0] = random.nextFloat();
        tempBuffer[this.size - 1][this.size - 1] = random.nextFloat();
        float offsetRange = this.range;
        int stepSize = this.size - 1;
        while (stepSize > 1) {
            int[] nextCoords = new int[]{0, 0};
            while (nextCoords != null) {
                nextCoords = this.doSquareStep(tempBuffer, nextCoords, stepSize, offsetRange, random);
            }
            nextCoords = new int[]{0, 0};
            while (nextCoords != null) {
                nextCoords = this.doDiamondStep(tempBuffer, nextCoords, stepSize, offsetRange, random);
            }
            stepSize /= 2;
            offsetRange *= this.persistence;
        }
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                this.setHeightAtPoint(tempBuffer[i][j], j, i);
            }
        }
        this.normalizeTerrain(NORMALIZE_RANGE);
        logger.log(Level.INFO, "Midpoint displacement heightmap generated");
        return true;
    }

    protected int[] doSquareStep(float[][] tempBuffer, int[] coords, int stepSize, float offsetRange, Random random) {
        float cornerAverage = 0.0f;
        int x = coords[0];
        int y = coords[1];
        cornerAverage += tempBuffer[x][y];
        cornerAverage += tempBuffer[x + stepSize][y];
        cornerAverage += tempBuffer[x + stepSize][y + stepSize];
        cornerAverage += tempBuffer[x][y + stepSize];
        float offset = this.getOffset(random, offsetRange, coords, cornerAverage /= 4.0f);
        tempBuffer[x + stepSize / 2][y + stepSize / 2] = cornerAverage + offset;
        if (x + stepSize * 3 / 2 < this.size) {
            return new int[]{x + stepSize, y};
        }
        if (y + stepSize * 3 / 2 < this.size) {
            return new int[]{0, y + stepSize};
        }
        return null;
    }

    protected int[] doDiamondStep(float[][] tempBuffer, int[] coords, int stepSize, float offsetRange, Random random) {
        int cornerNbr = 0;
        float cornerAverage = 0.0f;
        int x = coords[0];
        int y = coords[1];
        int[] dxs = new int[]{0, stepSize / 2, stepSize, stepSize / 2};
        int[] dys = new int[]{0, -stepSize / 2, 0, stepSize / 2};
        for (int d = 0; d < 4; ++d) {
            int j;
            int i = x + dxs[d];
            if (i < 0 || i > this.size - 1 || (j = y + dys[d]) < 0 || j > this.size - 1) continue;
            cornerAverage += tempBuffer[i][j];
            ++cornerNbr;
        }
        float offset = this.getOffset(random, offsetRange, coords, cornerAverage /= (float)cornerNbr);
        tempBuffer[x + stepSize / 2][y] = cornerAverage + offset;
        if (x + stepSize * 3 / 2 < this.size) {
            return new int[]{x + stepSize, y};
        }
        if (y + stepSize / 2 < this.size) {
            if (x + stepSize == this.size - 1) {
                return new int[]{-stepSize / 2, y + stepSize / 2};
            }
            return new int[]{0, y + stepSize / 2};
        }
        return null;
    }

    protected float getOffset(Random random, float offsetRange, int[] coords, float average) {
        return 2.0f * (random.nextFloat() - 0.5f) * offsetRange;
    }

    public float getPersistence() {
        return this.persistence;
    }

    public void setPersistence(float persistence) {
        this.persistence = persistence;
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }
}

