/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap.picking;

import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.math.Ray;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.TerrainQuad;
import com.jme3.terrain.geomipmap.picking.BresenhamYUpGridTracer;
import com.jme3.terrain.geomipmap.picking.TerrainPickData;
import com.jme3.terrain.geomipmap.picking.TerrainPicker;
import java.util.ArrayList;
import java.util.Collections;

public class BresenhamTerrainPicker
implements TerrainPicker {
    private final Triangle gridTriA = new Triangle(new Vector3f(), new Vector3f(), new Vector3f());
    private final Triangle gridTriB = new Triangle(new Vector3f(), new Vector3f(), new Vector3f());
    private final Vector3f calcVec1 = new Vector3f();
    private final Ray workRay = new Ray();
    private final Ray worldPickRay = new Ray();
    private final TerrainQuad root;
    private final BresenhamYUpGridTracer tracer = new BresenhamYUpGridTracer();

    public BresenhamTerrainPicker(TerrainQuad root) {
        this.root = root;
    }

    public Vector3f getTerrainIntersection(Ray worldPick, CollisionResults results) {
        this.worldPickRay.set(worldPick);
        ArrayList<TerrainPickData> pickData = new ArrayList<TerrainPickData>();
        this.root.findPick(worldPick.clone(), pickData);
        Collections.sort(pickData);
        if (pickData.isEmpty()) {
            return null;
        }
        this.workRay.set(worldPick);
        for (TerrainPickData pd : pickData) {
            Triangle hit;
            TerrainPatch patch = pd.targetPatch;
            this.tracer.getGridSpacing().set(patch.getWorldScale());
            this.tracer.setGridOrigin(patch.getWorldTranslation());
            this.workRay.getOrigin().set(worldPick.getDirection()).multLocal(pd.cr.getDistance() - 0.1f).addLocal(worldPick.getOrigin());
            this.tracer.startWalk(this.workRay);
            Vector3f intersection = new Vector3f();
            Vector2f loc = this.tracer.getGridLocation();
            if (this.tracer.isRayPerpendicularToGrid()) {
                hit = new Triangle();
                this.checkTriangles(loc.x, loc.y, this.workRay, intersection, patch, hit);
                float distance = this.worldPickRay.origin.distance(intersection);
                CollisionResult cr = new CollisionResult(intersection, distance);
                cr.setGeometry(patch);
                cr.setContactNormal(hit.getNormal());
                results.addCollision(cr);
                return intersection;
            }
            while (loc.x >= -1.0f && loc.x <= (float)patch.getSize() && loc.y >= -1.0f && loc.y <= (float)patch.getSize()) {
                hit = new Triangle();
                if (this.checkTriangles(loc.x, loc.y, this.workRay, intersection, patch, hit)) {
                    float distance = this.worldPickRay.origin.distance(intersection);
                    CollisionResult cr = new CollisionResult(intersection, distance);
                    cr.setGeometry(patch);
                    results.addCollision(cr);
                    cr.setContactNormal(hit.getNormal());
                    return intersection;
                }
                boolean dx = false;
                boolean dz = false;
                BresenhamYUpGridTracer.Direction d = this.tracer.getLastStepDirection();
                switch (d) {
                    case PositiveX: 
                    case NegativeX: {
                        dx = false;
                        dz = true;
                        break;
                    }
                    case PositiveZ: 
                    case NegativeZ: {
                        dx = true;
                        dz = false;
                    }
                }
                if (this.checkTriangles(loc.x + (float)dx, loc.y + (float)dz, this.workRay, intersection, patch, hit)) {
                    float distance = this.worldPickRay.origin.distance(intersection);
                    CollisionResult cr = new CollisionResult(intersection, distance);
                    results.addCollision(cr);
                    cr.setGeometry(patch);
                    cr.setContactNormal(hit.getNormal());
                    return intersection;
                }
                this.tracer.next();
            }
        }
        return null;
    }

    protected boolean checkTriangles(float gridX, float gridY, Ray pick, Vector3f intersection, TerrainPatch patch, Triangle store) {
        if (!this.getTriangles(gridX, gridY, patch)) {
            return false;
        }
        if (pick.intersectWhere(this.gridTriA, intersection)) {
            store.set(this.gridTriA.get1(), this.gridTriA.get2(), this.gridTriA.get3());
            return true;
        }
        if (pick.intersectWhere(this.gridTriB, intersection)) {
            store.set(this.gridTriB.get1(), this.gridTriB.get2(), this.gridTriB.get3());
            return true;
        }
        return false;
    }

    protected boolean getTriangles(float gridX, float gridY, TerrainPatch patch) {
        this.calcVec1.set(gridX, 0.0f, gridY);
        int index = this.findClosestHeightIndex(this.calcVec1, patch);
        if (index == -1) {
            return false;
        }
        Triangle[] t = patch.getGridTriangles(gridX, gridY);
        if (t == null || t.length == 0) {
            return false;
        }
        this.gridTriA.set1(t[0].get1());
        this.gridTriA.set2(t[0].get2());
        this.gridTriA.set3(t[0].get3());
        this.gridTriB.set1(t[1].get1());
        this.gridTriB.set2(t[1].get2());
        this.gridTriB.set3(t[1].get3());
        return true;
    }

    protected int findClosestHeightIndex(Vector3f position, TerrainPatch patch) {
        int x = (int)position.x;
        int z = (int)position.z;
        if (x < 0 || x >= patch.getSize() - 1) {
            return -1;
        }
        if (z < 0 || z >= patch.getSize() - 1) {
            return -1;
        }
        return z * patch.getSize() + x;
    }
}

