/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class NoiseGenerator
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(NoiseGenerator.class.getName());
    protected static final int TEX_INT = 0;
    protected static final int TEX_RGB = 1;
    protected static final int TEX_NOR = 2;
    protected static final int TEX_NOISESOFT = 0;
    protected static final int TEX_NOISEPERL = 1;
    protected static final int TEX_DEFAULT = 0;
    protected static final int TEX_COLOR = 1;
    protected static final int TEX_COLORBAND = 1;
    protected static final int TEX_FLIPBLEND = 2;
    protected static final int TEX_NEGALPHA = 4;
    protected static final int TEX_CHECKER_ODD = 8;
    protected static final int TEX_CHECKER_EVEN = 16;
    protected static final int TEX_PRV_ALPHA = 32;
    protected static final int TEX_PRV_NOR = 64;
    protected static final int TEX_REPEAT_XMIR = 128;
    protected static final int TEX_REPEAT_YMIR = 256;
    protected static final int TEX_FLAG_MASK = 511;
    protected static final int TEX_SIN = 0;
    protected static final int TEX_SAW = 1;
    protected static final int TEX_TRI = 2;
    protected static final int TEX_SOFT = 0;
    protected static final int TEX_SHARP = 1;
    protected static final int TEX_SHARPER = 2;
    protected static final int TEX_BAND = 0;
    protected static final int TEX_RING = 1;
    protected static final int TEX_BANDNOISE = 2;
    protected static final int TEX_RINGNOISE = 3;
    protected static final int TEX_LIN = 0;
    protected static final int TEX_QUAD = 1;
    protected static final int TEX_EASE = 2;
    protected static final int TEX_DIAG = 3;
    protected static final int TEX_SPHERE = 4;
    protected static final int TEX_HALO = 5;
    protected static final int TEX_RAD = 6;
    protected static final int TEX_PLASTIC = 0;
    protected static final int TEX_WALLIN = 1;
    protected static final int TEX_WALLOUT = 2;
    protected static final int TEX_MFRACTAL = 0;
    protected static final int TEX_RIDGEDMF = 1;
    protected static final int TEX_HYBRIDMF = 2;
    protected static final int TEX_FBM = 3;
    protected static final int TEX_HTERRAIN = 4;
    protected static final int KEY_LINEAR = 0;
    protected static final int KEY_CARDINAL = 1;
    protected static final int KEY_BSPLINE = 2;
    protected static float[] hashpntf;
    protected static short[] hash;
    protected static float[] hashvectf;
    protected static short[] p;
    protected static float[][] g;
    protected static Map<Integer, AbstractNoiseFunc> noiseFunctions;
    protected static Map<Integer, DistanceFunc> distanceFunctions;
    protected static Map<Integer, MusgraveFunction> musgraveFunctions;
    protected static IWaveForm[] waveformFunctions;

    public NoiseGenerator(String blenderVersion) {
        super(blenderVersion);
        this.loadConstants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConstants() {
        InputStream is = NoiseGenerator.class.getResourceAsStream("noiseconstants.dat");
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            hashpntf = (float[])ois.readObject();
            hash = (short[])ois.readObject();
            hashvectf = (float[])ois.readObject();
            p = (short[])ois.readObject();
            g = (float[][])ois.readObject();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (ClassNotFoundException e) {
            assert (false) : "Constants' classes should be arrays of primitive types, so they are ALWAYS known!";
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage());
                }
            }
        }
    }

    protected void brightnesAndContrast(TextureHelper.TexResult texres, float contrast, float brightness) {
        texres.tin = (texres.tin - 0.5f) * contrast + brightness - 0.5f;
        if (texres.tin < 0.0f) {
            texres.tin = 0.0f;
        } else if (texres.tin > 1.0f) {
            texres.tin = 1.0f;
        }
    }

    protected void brightnesAndContrastRGB(Structure tex, TextureHelper.TexResult texres) {
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float bright = ((Number)tex.getFieldValue("bright")).floatValue();
        float rfac = ((Number)tex.getFieldValue("rfac")).floatValue();
        float gfac = ((Number)tex.getFieldValue("gfac")).floatValue();
        float bfac = ((Number)tex.getFieldValue("bfac")).floatValue();
        texres.tr = rfac * ((texres.tr - 0.5f) * contrast + bright - 0.5f);
        if (texres.tr < 0.0f) {
            texres.tr = 0.0f;
        }
        texres.tg = gfac * ((texres.tg - 0.5f) * contrast + bright - 0.5f);
        if (texres.tg < 0.0f) {
            texres.tg = 0.0f;
        }
        texres.tb = bfac * ((texres.tb - 0.5f) * contrast + bright - 0.5f);
        if (texres.tb < 0.0f) {
            texres.tb = 0.0f;
        }
    }

    public void texNormalDerivate(TextureHelper.ColorBand colorBand, TextureHelper.TexResult texres, DataRepository dataRepository) {
        if (texres.nor != null) {
            TextureHelper.TexResult fakeTexresult;
            try {
                fakeTexresult = (TextureHelper.TexResult)texres.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Texture result class MUST support cloning!", e);
            }
            float fac0 = fakeTexresult.tr + fakeTexresult.tg + fakeTexresult.tb;
            fakeTexresult.tin = texres.nor[0];
            this.doColorband(colorBand, fakeTexresult, dataRepository);
            float fac1 = fakeTexresult.tr + fakeTexresult.tg + fakeTexresult.tb;
            fakeTexresult.tin = texres.nor[1];
            this.doColorband(colorBand, fakeTexresult, dataRepository);
            float fac2 = fakeTexresult.tr + fakeTexresult.tg + fakeTexresult.tb;
            fakeTexresult.tin = texres.nor[2];
            this.doColorband(colorBand, fakeTexresult, dataRepository);
            float fac3 = fakeTexresult.tr + fakeTexresult.tg + fakeTexresult.tb;
            texres.nor[0] = 0.3333f * (fac0 - fac1);
            texres.nor[1] = 0.3333f * (fac0 - fac2);
            texres.nor[2] = 0.3333f * (fac0 - fac3);
            texres.nor[0] = texres.tin - texres.nor[0];
            texres.nor[1] = texres.tin - texres.nor[1];
            texres.nor[2] = texres.tin - texres.nor[2];
        }
    }

    public boolean doColorband(TextureHelper.ColorBand colorBand, TextureHelper.TexResult texres, DataRepository dataRepository) {
        int i1 = 0;
        int i2 = 0;
        float[] t = new float[4];
        if (colorBand == null || colorBand.tot == 0) {
            return true;
        }
        TextureHelper.CBData cbd1 = colorBand.data[0];
        if (colorBand.tot == 1) {
            texres.tr = cbd1.r;
            texres.tg = cbd1.g;
            texres.tb = cbd1.b;
            texres.ta = cbd1.a;
        } else if (texres.tin <= cbd1.pos && colorBand.ipotype < 2) {
            texres.tr = cbd1.r;
            texres.tg = cbd1.g;
            texres.tb = cbd1.b;
            texres.ta = cbd1.a;
        } else {
            TextureHelper.CBData cbd2;
            int a = 0;
            while (a < colorBand.tot) {
                cbd1 = colorBand.data[i1];
                if (cbd1.pos > texres.tin) break;
                ++a;
                ++i1;
            }
            if (a == colorBand.tot) {
                cbd2 = colorBand.data[i1 - 1];
                try {
                    cbd1 = (TextureHelper.CBData)cbd2.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new IllegalStateException("Clone not supported for " + TextureHelper.CBData.class.getName() + " class! Fix that!");
                }
                cbd1.pos = 1.0f;
            } else if (a == 0) {
                try {
                    cbd2 = (TextureHelper.CBData)cbd1.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new IllegalStateException("Clone not supported for " + TextureHelper.CBData.class.getName() + " class! Fix that!");
                }
                cbd2.pos = 0.0f;
            } else {
                cbd2 = colorBand.data[i1 - 1];
            }
            if (texres.tin >= cbd1.pos && colorBand.ipotype < 2) {
                texres.tr = cbd1.r;
                texres.tg = cbd1.g;
                texres.tb = cbd1.b;
                texres.ta = cbd1.a;
            } else {
                float fac = cbd2.pos != cbd1.pos ? (texres.tin - cbd1.pos) / (cbd2.pos - cbd1.pos) : 0.0f;
                if (colorBand.ipotype == 4) {
                    texres.tr = cbd2.r;
                    texres.tg = cbd2.g;
                    texres.tb = cbd2.b;
                    texres.ta = cbd2.a;
                    return true;
                }
                if (colorBand.ipotype >= 2) {
                    TextureHelper.CBData cbd0 = a >= colorBand.tot - 1 ? cbd1 : colorBand.data[i1 + 1];
                    TextureHelper.CBData cbd3 = a < 2 ? cbd2 : colorBand.data[i2 - 1];
                    fac = FastMath.clamp(fac, 0.0f, 1.0f);
                    if (colorBand.ipotype == 3) {
                        this.setFourIpo(fac, t, 1);
                    } else {
                        this.setFourIpo(fac, t, 2);
                    }
                    texres.tr = t[3] * cbd3.r + t[2] * cbd2.r + t[1] * cbd1.r + t[0] * cbd0.r;
                    texres.tg = t[3] * cbd3.g + t[2] * cbd2.g + t[1] * cbd1.g + t[0] * cbd0.g;
                    texres.tb = t[3] * cbd3.b + t[2] * cbd2.b + t[1] * cbd1.b + t[0] * cbd0.b;
                    texres.ta = t[3] * cbd3.a + t[2] * cbd2.a + t[1] * cbd1.a + t[0] * cbd0.a;
                    texres.tr = FastMath.clamp(texres.tr, 0.0f, 1.0f);
                    texres.tg = FastMath.clamp(texres.tg, 0.0f, 1.0f);
                    texres.tb = FastMath.clamp(texres.tb, 0.0f, 1.0f);
                    texres.ta = FastMath.clamp(texres.ta, 0.0f, 1.0f);
                } else {
                    float mfac;
                    if (colorBand.ipotype == 1) {
                        mfac = fac * fac;
                        fac = 3.0f * mfac - 2.0f * mfac * fac;
                    }
                    mfac = 1.0f - fac;
                    texres.tr = mfac * cbd1.r + fac * cbd2.r;
                    texres.tg = mfac * cbd1.g + fac * cbd2.g;
                    texres.tb = mfac * cbd1.b + fac * cbd2.b;
                    texres.ta = mfac * cbd1.a + fac * cbd2.a;
                }
            }
        }
        return true;
    }

    protected void setFourIpo(float d, float[] data, int type) {
        if (type == 0) {
            data[0] = 0.0f;
            data[1] = 1.0f - d;
            data[2] = d;
            data[3] = 0.0f;
        } else {
            float d2 = d * d;
            float d3 = d2 * d;
            if (type == 1) {
                float fc = 0.71f;
                data[0] = -fc * d3 + 2.0f * fc * d2 - fc * d;
                data[1] = (2.0f - fc) * d3 + (fc - 3.0f) * d2 + 1.0f;
                data[2] = (fc - 2.0f) * d3 + (3.0f - 2.0f * fc) * d2 + fc * d;
                data[3] = fc * d3 - fc * d2;
            } else if (type == 2) {
                data[0] = -0.16666666f * d3 + 0.5f * d2 - 0.5f * d + 0.16666666f;
                data[1] = 0.5f * d3 - d2 + 0.6666666f;
                data[2] = -0.5f * d3 + 0.5f * d2 + 0.5f * d + 0.16666666f;
                data[3] = 0.16666666f * d3;
            }
        }
    }

    public float woodInt(Structure tex, float x, float y, float z, DataRepository dataRepository) {
        int noisebasis2 = ((Number)tex.getFieldValue("noisebasis2")).intValue();
        int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        float turbul = ((Number)tex.getFieldValue("turbul")).floatValue();
        int noiseType = ((Number)tex.getFieldValue("noisetype")).intValue();
        float wi = 0.0f;
        int waveform = noisebasis2;
        int wt = stype;
        if (waveform > 2 || waveform < 0) {
            waveform = 0;
        }
        if (wt == 0) {
            wi = waveformFunctions[waveform].execute((x + y + z) * 10.0f);
        } else if (wt == 1) {
            wi = waveformFunctions[waveform].execute((float)Math.sqrt(x * x + y * y + z * z) * 20.0f);
        } else if (wt == 2) {
            wi = turbul * this.bliGNoise(noisesize, x, y, z, noiseType != 0, noisebasis);
            wi = waveformFunctions[waveform].execute((x + y + z) * 10.0f + wi);
        } else if (wt == 3) {
            wi = turbul * this.bliGNoise(noisesize, x, y, z, noiseType != 0, noisebasis);
            wi = waveformFunctions[waveform].execute((float)Math.sqrt(x * x + y * y + z * z) * 20.0f + wi);
        }
        return wi;
    }

    public float marbleInt(Structure tex, float x, float y, float z, DataRepository dataRepository) {
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        int noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float turbul = ((Number)tex.getFieldValue("turbul")).floatValue();
        int noisetype = ((Number)tex.getFieldValue("noisetype")).intValue();
        int waveform = ((Number)tex.getFieldValue("noisebasis2")).intValue();
        if (waveform > 2 || waveform < 0) {
            waveform = 0;
        }
        float n = 5.0f * (x + y + z);
        float mi = n + turbul * this.bliGTurbulence(noisesize, x, y, z, noisedepth, noisetype != 0, noisebasis);
        if (stype >= 0) {
            mi = waveformFunctions[waveform].execute(mi);
            if (stype == 1) {
                mi = (float)Math.sqrt(mi);
            } else if (stype == 2) {
                mi = (float)Math.sqrt(Math.sqrt(mi));
            }
        }
        return mi;
    }

    public void voronoi(float x, float y, float z, float[] da, float[] pa, float me, int dtype) {
        AbstractNoiseFunc.voronoi(x, y, z, da, pa, me, dtype);
    }

    public void cellNoiseV(float x, float y, float z, float[] ca) {
        AbstractNoiseFunc.cellNoiseV(x, y, z, ca);
    }

    private float bliHnoise(float noisesize, float x, float y, float z) {
        if ((double)noisesize == 0.0) {
            return 0.0f;
        }
        x = (1.0f + x) / noisesize;
        y = (1.0f + y) / noisesize;
        z = (1.0f + z) / noisesize;
        return noiseFunctions.get(0).execute(x, y, z);
    }

    public float bliTurbulence(float noisesize, float x, float y, float z, int nr) {
        float d = 0.5f;
        float div = 1.0f;
        float s = this.bliHnoise(noisesize, x, y, z);
        while (nr > 0) {
            s += d * this.bliHnoise(noisesize * d, x, y, z);
            div += d;
            d = (float)((double)d * 0.5);
            --nr;
        }
        return s / div;
    }

    public float bliTurbulence1(float noisesize, float x, float y, float z, int nr) {
        float d = 0.5f;
        float div = 1.0f;
        float s = FastMath.abs(-1.0f + 2.0f * this.bliHnoise(noisesize, x, y, z));
        while (nr > 0) {
            s += Math.abs(d * (-1.0f + 2.0f * this.bliHnoise(noisesize * d, x, y, z)));
            div += d;
            d = (float)((double)d * 0.5);
            --nr;
        }
        return s / div;
    }

    public float bliHnoisep(float noisesize, float x, float y, float z) {
        return noiseFunctions.get(0).noise3Perlin(new float[]{x / noisesize, y / noisesize, z / noisesize});
    }

    public float turbulencePerlin(float[] point, float lofreq, float hifreq) {
        float t = 0.0f;
        float[] p = new float[]{point[0] + 123.456f, point[1], point[2]};
        float freq = lofreq;
        while (freq < hifreq) {
            t += Math.abs(noiseFunctions.get(0).noise3Perlin(p)) / freq;
            p[0] = p[0] * 2.0f;
            p[1] = p[1] * 2.0f;
            p[2] = p[2] * 2.0f;
            freq = (float)((double)freq * 2.0);
        }
        return t - 0.3f;
    }

    public float turbulencep(float noisesize, float x, float y, float z, int nr) {
        float[] vec = new float[]{x / noisesize, y / noisesize, z / noisesize};
        return this.turbulencePerlin(vec, 1.0f, 1 << ++nr);
    }

    public float bliGNoise(float noisesize, float x, float y, float z, boolean isHard, int noisebasis) {
        AbstractNoiseFunc abstractNoiseFunc = noiseFunctions.get(noisebasis);
        if (abstractNoiseFunc == null) {
            abstractNoiseFunc = noiseFunctions.get(0);
            noisebasis = 0;
        }
        if (noisebasis == 0) {
            x += 1.0f;
            y += 1.0f;
            z += 1.0f;
        }
        if ((double)noisesize != 0.0) {
            noisesize = 1.0f / noisesize;
            x *= noisesize;
            y *= noisesize;
            z *= noisesize;
        }
        if (isHard) {
            return Math.abs(2.0f * abstractNoiseFunc.execute(x, y, z) - 1.0f);
        }
        return abstractNoiseFunc.execute(x, y, z);
    }

    public float bliGTurbulence(float noisesize, float x, float y, float z, int oct, boolean isHard, int noisebasis) {
        AbstractNoiseFunc abstractNoiseFunc = noiseFunctions.get(noisebasis);
        if (abstractNoiseFunc == null) {
            abstractNoiseFunc = noiseFunctions.get(0);
            noisebasis = 0;
        }
        if (noisebasis == 0) {
            x += 1.0f;
            y += 1.0f;
            z += 1.0f;
        }
        float sum = 0.0f;
        float amp = 1.0f;
        float fscale = 1.0f;
        if ((double)noisesize != 0.0) {
            noisesize = 1.0f / noisesize;
            x *= noisesize;
            y *= noisesize;
            z *= noisesize;
        }
        int i = 0;
        while (i <= oct) {
            float t = abstractNoiseFunc.execute(fscale * x, fscale * y, fscale * z);
            if (isHard) {
                t = FastMath.abs(2.0f * t - 1.0f);
            }
            sum += t * amp;
            ++i;
            amp = (float)((double)amp * 0.5);
            fscale *= 2.0f;
        }
        return sum *= (float)(1 << oct) / (float)((1 << oct + 1) - 1);
    }

    public float mgVLNoise(float x, float y, float z, float distortion, int nbas1, int nbas2) {
        AbstractNoiseFunc abstractNoiseFunc2;
        AbstractNoiseFunc abstractNoiseFunc1 = noiseFunctions.get(nbas1);
        if (abstractNoiseFunc1 == null) {
            abstractNoiseFunc1 = noiseFunctions.get(0);
        }
        if ((abstractNoiseFunc2 = noiseFunctions.get(nbas2)) == null) {
            abstractNoiseFunc2 = noiseFunctions.get(0);
        }
        float rx = abstractNoiseFunc1.execute(x + 13.5f, y + 13.5f, z + 13.5f) * distortion;
        float ry = abstractNoiseFunc1.execute(x, y, z) * distortion;
        float rz = abstractNoiseFunc1.execute(x - 13.5f, y - 13.5f, z - 13.5f) * distortion;
        return abstractNoiseFunc2.executeS(x + rx, y + ry, z + rz);
    }

    public void mgMFractalOrfBmTex(Structure tex, float[] texvec, TextureHelper.ColorBand colorBand, TextureHelper.TexResult texres, DataRepository dataRepository) {
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float nsOutscale = ((Number)tex.getFieldValue("ns_outscale")).floatValue();
        float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        MusgraveFunction mgravefunc = stype == 0 ? musgraveFunctions.get(stype) : musgraveFunctions.get(3);
        texres.tin = nsOutscale * mgravefunc.execute(tex, texvec[0], texvec[1], texvec[2]);
        if (texres.nor != null) {
            float offs = nabla / noisesize;
            texres.nor[0] = nsOutscale * mgravefunc.execute(tex, texvec[0] + offs, texvec[1], texvec[2]);
            texres.nor[1] = nsOutscale * mgravefunc.execute(tex, texvec[0], texvec[1] + offs, texvec[2]);
            texres.nor[2] = nsOutscale * mgravefunc.execute(tex, texvec[0], texvec[1], texvec[2] + offs);
            this.texNormalDerivate(colorBand, texres, dataRepository);
        }
        this.brightnesAndContrast(texres, contrast, brightness);
    }

    public void mgRidgedOrHybridMFTex(Structure tex, float[] texvec, TextureHelper.ColorBand colorBand, TextureHelper.TexResult texres, DataRepository dataRepository) {
        int stype = ((Number)tex.getFieldValue("stype")).intValue();
        float nsOutscale = ((Number)tex.getFieldValue("ns_outscale")).floatValue();
        float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        MusgraveFunction mgravefunc = stype == 1 ? musgraveFunctions.get(stype) : musgraveFunctions.get(2);
        texres.tin = nsOutscale * mgravefunc.execute(tex, texvec[0], texvec[1], texvec[2]);
        if (texres.nor != null) {
            float offs = nabla / noisesize;
            texres.nor[0] = nsOutscale * mgravefunc.execute(tex, texvec[0] + offs, texvec[1], texvec[2]);
            texres.nor[1] = nsOutscale * mgravefunc.execute(tex, texvec[0], texvec[1] + offs, texvec[2]);
            texres.nor[2] = nsOutscale * mgravefunc.execute(tex, texvec[0], texvec[1], texvec[2] + offs);
            this.texNormalDerivate(colorBand, texres, dataRepository);
        }
        this.brightnesAndContrast(texres, contrast, brightness);
    }

    public void mgHTerrainTex(Structure tex, float[] texvec, TextureHelper.ColorBand colorBand, TextureHelper.TexResult texres, DataRepository dataRepository) {
        float nsOutscale = ((Number)tex.getFieldValue("ns_outscale")).floatValue();
        float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        MusgraveFunction musgraveFunction = musgraveFunctions.get(4);
        texres.tin = nsOutscale * musgraveFunction.execute(tex, texvec[0], texvec[1], texvec[2]);
        if (texres.nor != null) {
            float offs = nabla / noisesize;
            texres.nor[0] = nsOutscale * musgraveFunction.execute(tex, texvec[0] + offs, texvec[1], texvec[2]);
            texres.nor[1] = nsOutscale * musgraveFunction.execute(tex, texvec[0], texvec[1] + offs, texvec[2]);
            texres.nor[2] = nsOutscale * musgraveFunction.execute(tex, texvec[0], texvec[1], texvec[2] + offs);
            this.texNormalDerivate(colorBand, texres, dataRepository);
        }
        this.brightnesAndContrast(texres, contrast, brightness);
    }

    public boolean shouldBeLoaded(Structure structure, DataRepository dataRepository) {
        return true;
    }

    static {
        noiseFunctions = new HashMap<Integer, AbstractNoiseFunc>();
        noiseFunctions.put(0, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                return this.orgBlenderNoise(x, y, z);
            }

            public float executeS(float x, float y, float z) {
                return 2.0f * this.orgBlenderNoise(x, y, z) - 1.0f;
            }
        });
        noiseFunctions.put(1, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                return 0.5f + 0.5f * this.noise3Perlin(new float[]{x, y, z});
            }

            public float executeS(float x, float y, float z) {
                return this.noise3Perlin(new float[]{x, y, z});
            }
        });
        noiseFunctions.put(2, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                return 0.5f + 0.5f * this.newPerlin(x, y, z);
            }

            public float executeS(float x, float y, float z) {
                return this.execute(x, y, z);
            }
        });
        noiseFunctions.put(3, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return da[0];
            }

            public float executeS(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return 2.0f * da[0] - 1.0f;
            }
        });
        noiseFunctions.put(4, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return da[1];
            }

            public float executeS(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return 2.0f * da[1] - 1.0f;
            }
        });
        noiseFunctions.put(5, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return da[2];
            }

            public float executeS(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return 2.0f * da[2] - 1.0f;
            }
        });
        noiseFunctions.put(6, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return da[3];
            }

            public float executeS(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return 2.0f * da[3] - 1.0f;
            }
        });
        noiseFunctions.put(7, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return da[1] - da[0];
            }

            public float executeS(float x, float y, float z) {
                float[] da = new float[4];
                float[] pa = new float[12];
                AbstractNoiseFunc.voronoi(x, y, z, da, pa, 1.0f, 0);
                return 2.0f * (da[1] - da[0]) - 1.0f;
            }
        });
        noiseFunctions.put(8, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                float t = 10.0f * noiseFunctions.get(7).execute(x, y, z);
                return t > 1.0f ? 1.0f : t;
            }

            public float executeS(float x, float y, float z) {
                float t = 10.0f * noiseFunctions.get(7).execute(x, y, z);
                return t > 1.0f ? 1.0f : 2.0f * t - 1.0f;
            }
        });
        noiseFunctions.put(14, new AbstractNoiseFunc(){

            public float execute(float x, float y, float z) {
                int xi = (int)Math.floor(x);
                int yi = (int)Math.floor(y);
                int zi = (int)Math.floor(z);
                long n = xi + yi * 1301 + zi * 314159;
                n ^= n << 13;
                return (float)(n * (n * n * 15731L + 789221L) + 1376312589L) / 4.2949673E9f;
            }

            public float executeS(float x, float y, float z) {
                return 2.0f * this.execute(x, y, z) - 1.0f;
            }
        });
        distanceFunctions = new HashMap<Integer, DistanceFunc>();
        distanceFunctions.put(0, new DistanceFunc(){

            public float execute(float x, float y, float z, float e) {
                return (float)Math.sqrt(x * x + y * y + z * z);
            }
        });
        distanceFunctions.put(1, new DistanceFunc(){

            public float execute(float x, float y, float z, float e) {
                return x * x + y * y + z * z;
            }
        });
        distanceFunctions.put(2, new DistanceFunc(){

            public float execute(float x, float y, float z, float e) {
                return FastMath.abs(x) + FastMath.abs(y) + FastMath.abs(z);
            }
        });
        distanceFunctions.put(3, new DistanceFunc(){

            public float execute(float x, float y, float z, float e) {
                x = FastMath.abs(x);
                y = FastMath.abs(y);
                z = FastMath.abs(z);
                float t = x > y ? x : y;
                return z > t ? z : t;
            }
        });
        distanceFunctions.put(4, new DistanceFunc(){

            public float execute(float x, float y, float z, float e) {
                float d = (float)(Math.sqrt(FastMath.abs(x)) + Math.sqrt(FastMath.abs(y)) + Math.sqrt(FastMath.abs(z)));
                return d * d;
            }
        });
        distanceFunctions.put(5, new DistanceFunc(){

            public float execute(float x, float y, float z, float e) {
                x *= x;
                y *= y;
                z *= z;
                return (float)Math.sqrt(Math.sqrt(x * x + y * y + z * z));
            }
        });
        distanceFunctions.put(6, new DistanceFunc(){

            public float execute(float x, float y, float z, float e) {
                return (float)Math.pow(Math.pow(FastMath.abs(x), e) + Math.pow(FastMath.abs(y), e) + Math.pow(FastMath.abs(z), e), 1.0f / e);
            }
        });
        musgraveFunctions = new HashMap<Integer, MusgraveFunction>();
        musgraveFunctions.put(0, new MusgraveFunction(){

            public float execute(Structure tex, float x, float y, float z) {
                float mg_H = ((Number)tex.getFieldValue("mg_H")).floatValue();
                float mg_lacunarity = ((Number)tex.getFieldValue("mg_lacunarity")).floatValue();
                float mg_octaves = ((Number)tex.getFieldValue("mg_octaves")).floatValue();
                int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
                float value = 1.0f;
                float pwr = 1.0f;
                float pwHL = (float)Math.pow(mg_lacunarity, -mg_H);
                AbstractNoiseFunc abstractNoiseFunc = noiseFunctions.get(noisebasis);
                if (abstractNoiseFunc == null) {
                    abstractNoiseFunc = noiseFunctions.get(0);
                }
                for (int i = 0; i < (int)mg_octaves; ++i) {
                    value *= pwr * abstractNoiseFunc.executeS(x, y, z) + 1.0f;
                    pwr *= pwHL;
                    x *= mg_lacunarity;
                    y *= mg_lacunarity;
                    z *= mg_lacunarity;
                }
                float rmd = (float)((double)mg_octaves - Math.floor(mg_octaves));
                if (rmd != 0.0f) {
                    value *= rmd * abstractNoiseFunc.executeS(x, y, z) * pwr + 1.0f;
                }
                return value;
            }
        });
        musgraveFunctions.put(1, new MusgraveFunction(){

            public float execute(Structure tex, float x, float y, float z) {
                float pwHL;
                float mg_H = ((Number)tex.getFieldValue("mg_H")).floatValue();
                float mg_lacunarity = ((Number)tex.getFieldValue("mg_lacunarity")).floatValue();
                float mg_octaves = ((Number)tex.getFieldValue("mg_octaves")).floatValue();
                float mg_offset = ((Number)tex.getFieldValue("mg_offset")).floatValue();
                int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
                float mg_gain = ((Number)tex.getFieldValue("mg_gain")).floatValue();
                float pwr = pwHL = (float)Math.pow(mg_lacunarity, -mg_H);
                AbstractNoiseFunc abstractNoiseFunc = noiseFunctions.get(noisebasis);
                if (abstractNoiseFunc == null) {
                    abstractNoiseFunc = noiseFunctions.get(0);
                }
                float signal = mg_offset - FastMath.abs(abstractNoiseFunc.executeS(x, y, z));
                signal *= signal;
                float result = signal;
                float weight = 1.0f;
                for (int i = 1; i < (int)mg_octaves; ++i) {
                    x *= mg_lacunarity;
                    y *= mg_lacunarity;
                    z *= mg_lacunarity;
                    weight = signal * mg_gain;
                    if (weight > 1.0f) {
                        weight = 1.0f;
                    } else if ((double)weight < 0.0) {
                        weight = 0.0f;
                    }
                    signal = mg_offset - FastMath.abs(abstractNoiseFunc.executeS(x, y, z));
                    signal *= signal;
                    result += (signal *= weight) * pwr;
                    pwr *= pwHL;
                }
                return result;
            }
        });
        musgraveFunctions.put(2, new MusgraveFunction(){

            public float execute(Structure tex, float x, float y, float z) {
                float pwHL;
                float mg_H = ((Number)tex.getFieldValue("mg_H")).floatValue();
                float mg_lacunarity = ((Number)tex.getFieldValue("mg_lacunarity")).floatValue();
                float mg_octaves = ((Number)tex.getFieldValue("mg_octaves")).floatValue();
                float mg_offset = ((Number)tex.getFieldValue("mg_offset")).floatValue();
                int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
                float mg_gain = ((Number)tex.getFieldValue("mg_gain")).floatValue();
                float pwr = pwHL = (float)Math.pow(mg_lacunarity, -mg_H);
                AbstractNoiseFunc abstractNoiseFunc = noiseFunctions.get(noisebasis);
                if (abstractNoiseFunc == null) {
                    abstractNoiseFunc = noiseFunctions.get(0);
                }
                float result = abstractNoiseFunc.executeS(x, y, z) + mg_offset;
                float weight = mg_gain * result;
                x *= mg_lacunarity;
                y *= mg_lacunarity;
                z *= mg_lacunarity;
                for (int i = 1; weight > 0.001f && i < (int)mg_octaves; ++i) {
                    if (weight > 1.0f) {
                        weight = 1.0f;
                    }
                    float signal = (abstractNoiseFunc.executeS(x, y, z) + mg_offset) * pwr;
                    pwr *= pwHL;
                    result += weight * signal;
                    weight *= mg_gain * signal;
                    x *= mg_lacunarity;
                    y *= mg_lacunarity;
                    z *= mg_lacunarity;
                }
                float rmd = mg_octaves - (float)Math.floor(mg_octaves);
                if (rmd != 0.0f) {
                    result += rmd * (abstractNoiseFunc.executeS(x, y, z) + mg_offset) * pwr;
                }
                return result;
            }
        });
        musgraveFunctions.put(3, new MusgraveFunction(){

            public float execute(Structure tex, float x, float y, float z) {
                float mg_H = ((Number)tex.getFieldValue("mg_H")).floatValue();
                float mg_lacunarity = ((Number)tex.getFieldValue("mg_lacunarity")).floatValue();
                float mg_octaves = ((Number)tex.getFieldValue("mg_octaves")).floatValue();
                int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
                float value = 0.0f;
                float pwr = 1.0f;
                float pwHL = (float)Math.pow(mg_lacunarity, -mg_H);
                AbstractNoiseFunc abstractNoiseFunc = noiseFunctions.get(noisebasis);
                if (abstractNoiseFunc == null) {
                    abstractNoiseFunc = noiseFunctions.get(0);
                }
                for (int i = 0; i < (int)mg_octaves; ++i) {
                    value += abstractNoiseFunc.executeS(x, y, z) * pwr;
                    pwr *= pwHL;
                    x *= mg_lacunarity;
                    y *= mg_lacunarity;
                    z *= mg_lacunarity;
                }
                float rmd = (float)((double)mg_octaves - Math.floor(mg_octaves));
                if (rmd != 0.0f) {
                    value += rmd * abstractNoiseFunc.executeS(x, y, z) * pwr;
                }
                return value;
            }
        });
        musgraveFunctions.put(4, new MusgraveFunction(){

            public float execute(Structure tex, float x, float y, float z) {
                float increment;
                float pwHL;
                float mg_H = ((Number)tex.getFieldValue("mg_H")).floatValue();
                float mg_lacunarity = ((Number)tex.getFieldValue("mg_lacunarity")).floatValue();
                float mg_octaves = ((Number)tex.getFieldValue("mg_octaves")).floatValue();
                int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
                float mg_offset = ((Number)tex.getFieldValue("mg_offset")).floatValue();
                float pwr = pwHL = (float)Math.pow(mg_lacunarity, -mg_H);
                AbstractNoiseFunc abstractNoiseFunc = noiseFunctions.get(noisebasis);
                if (abstractNoiseFunc == null) {
                    abstractNoiseFunc = noiseFunctions.get(0);
                }
                float value = mg_offset + abstractNoiseFunc.executeS(x, y, z);
                x *= mg_lacunarity;
                y *= mg_lacunarity;
                z *= mg_lacunarity;
                for (int i = 1; i < (int)mg_octaves; ++i) {
                    increment = (abstractNoiseFunc.executeS(x, y, z) + mg_offset) * pwr * value;
                    value += increment;
                    pwr *= pwHL;
                    x *= mg_lacunarity;
                    y *= mg_lacunarity;
                    z *= mg_lacunarity;
                }
                float rmd = mg_octaves - (float)Math.floor(mg_octaves);
                if ((double)rmd != 0.0) {
                    increment = (abstractNoiseFunc.executeS(x, y, z) + mg_offset) * pwr * value;
                    value += rmd * increment;
                }
                return value;
            }
        });
        waveformFunctions = new IWaveForm[3];
        NoiseGenerator.waveformFunctions[0] = new IWaveForm(){

            public float execute(float x) {
                return 0.5f + 0.5f * (float)Math.sin(x);
            }
        };
        NoiseGenerator.waveformFunctions[1] = new IWaveForm(){

            public float execute(float x) {
                int n;
                if ((x -= (float)(n = (int)(x / ((float)Math.PI * 2))) * ((float)Math.PI * 2)) < 0.0f) {
                    x += (float)Math.PI * 2;
                }
                return x / ((float)Math.PI * 2);
            }
        };
        NoiseGenerator.waveformFunctions[2] = new IWaveForm(){

            public float execute(float x) {
                return 1.0f - 2.0f * FastMath.abs((float)Math.floor(x * 1.0f / ((float)Math.PI * 2) + 0.5f) - x * 1.0f / ((float)Math.PI * 2));
            }
        };
    }

    static interface MusgraveFunction {
        public float execute(Structure var1, float var2, float var3, float var4);
    }

    static interface DistanceFunc {
        public float execute(float var1, float var2, float var3, float var4);
    }

    protected static abstract class AbstractNoiseFunc {
        protected AbstractNoiseFunc() {
        }

        public abstract float execute(float var1, float var2, float var3);

        public abstract float executeS(float var1, float var2, float var3);

        protected static void voronoi(float x, float y, float z, float[] da, float[] pa, float me, int dtype) {
            DistanceFunc distanceFunc = distanceFunctions.get(dtype);
            if (distanceFunc == null) {
                distanceFunc = distanceFunctions.get(0);
            }
            int xi = (int)FastMath.floor(x);
            int yi = (int)FastMath.floor(y);
            int zi = (int)FastMath.floor(z);
            da[3] = 1.0E10f;
            da[2] = 1.0E10f;
            da[1] = 1.0E10f;
            da[0] = 1.0E10f;
            for (int xx = xi - 1; xx <= xi + 1; ++xx) {
                for (int yy = yi - 1; yy <= yi + 1; ++yy) {
                    for (int zz = zi - 1; zz <= zi + 1; ++zz) {
                        float zd;
                        float yd;
                        float[] p = AbstractNoiseFunc.hashPoint(xx, yy, zz);
                        float xd = x - (p[0] + (float)xx);
                        float d = distanceFunc.execute(xd, yd = y - (p[1] + (float)yy), zd = z - (p[2] + (float)zz), me);
                        if (d < da[0]) {
                            da[3] = da[2];
                            da[2] = da[1];
                            da[1] = da[0];
                            da[0] = d;
                            pa[9] = pa[6];
                            pa[10] = pa[7];
                            pa[11] = pa[8];
                            pa[6] = pa[3];
                            pa[7] = pa[4];
                            pa[8] = pa[5];
                            pa[3] = pa[0];
                            pa[4] = pa[1];
                            pa[5] = pa[2];
                            pa[0] = p[0] + (float)xx;
                            pa[1] = p[1] + (float)yy;
                            pa[2] = p[2] + (float)zz;
                            continue;
                        }
                        if (d < da[1]) {
                            da[3] = da[2];
                            da[2] = da[1];
                            da[1] = d;
                            pa[9] = pa[6];
                            pa[10] = pa[7];
                            pa[11] = pa[8];
                            pa[6] = pa[3];
                            pa[7] = pa[4];
                            pa[8] = pa[5];
                            pa[3] = p[0] + (float)xx;
                            pa[4] = p[1] + (float)yy;
                            pa[5] = p[2] + (float)zz;
                            continue;
                        }
                        if (d < da[2]) {
                            da[3] = da[2];
                            da[2] = d;
                            pa[9] = pa[6];
                            pa[10] = pa[7];
                            pa[11] = pa[8];
                            pa[6] = p[0] + (float)xx;
                            pa[7] = p[1] + (float)yy;
                            pa[8] = p[2] + (float)zz;
                            continue;
                        }
                        if (!(d < da[3])) continue;
                        da[3] = d;
                        pa[9] = p[0] + (float)xx;
                        pa[10] = p[1] + (float)yy;
                        pa[11] = p[2] + (float)zz;
                    }
                }
            }
        }

        protected static float[] hashPoint(int x, int y, int z) {
            float[] result = new float[]{hashpntf[3 * hash[hash[hash[z & 0xFF] + y & 0xFF] + x & 0xFF]], hashpntf[3 * hash[hash[hash[z & 0xFF] + y & 0xFF] + x & 0xFF] + 1], hashpntf[3 * hash[hash[hash[z & 0xFF] + y & 0xFF] + x & 0xFF] + 2]};
            return result;
        }

        public float noise3Perlin(float[] vec) {
            float t = vec[0] + 10000.0f;
            int bx0 = (int)t & 0xFF;
            int bx1 = bx0 + 1 & 0xFF;
            float rx0 = t - (float)((int)t);
            float rx1 = rx0 - 1.0f;
            t = vec[0] + 10000.0f;
            int by0 = (int)t & 0xFF;
            int by1 = by0 + 1 & 0xFF;
            float ry0 = t - (float)((int)t);
            float ry1 = ry0 - 1.0f;
            t = vec[0] + 10000.0f;
            int bz0 = (int)t & 0xFF;
            int bz1 = bz0 + 1 & 0xFF;
            float rz0 = t - (float)((int)t);
            float rz1 = rz0 - 1.0f;
            short i = p[bx0];
            short j = p[bx1];
            short b00 = p[i + by0];
            short b10 = p[j + by0];
            short b01 = p[i + by1];
            short b11 = p[j + by1];
            float sx = this.surve(rx0);
            float sy = this.surve(ry0);
            float sz = this.surve(rz0);
            float[] q = new float[3];
            q = g[b00 + bz0];
            float u = this.at(rx0, ry0, rz0, q);
            q = g[b10 + bz0];
            float v = this.at(rx1, ry0, rz0, q);
            float a = this.lerp(sx, u, v);
            q = g[b01 + bz0];
            u = this.at(rx0, ry1, rz0, q);
            q = g[b11 + bz0];
            v = this.at(rx1, ry1, rz0, q);
            float b = this.lerp(sx, u, v);
            float c = this.lerp(sy, a, b);
            q = g[b00 + bz1];
            u = this.at(rx0, ry0, rz1, q);
            q = g[b10 + bz1];
            v = this.at(rx1, ry0, rz1, q);
            a = this.lerp(sx, u, v);
            q = g[b01 + bz1];
            u = this.at(rx0, ry1, rz1, q);
            q = g[b11 + bz1];
            v = this.at(rx1, ry1, rz1, q);
            b = this.lerp(sx, u, v);
            float d = this.lerp(sy, a, b);
            return 1.5f * this.lerp(sz, c, d);
        }

        public float orgBlenderNoise(float x, float y, float z) {
            float n = 0.5f;
            int ix = (int)Math.floor(x);
            int iy = (int)Math.floor(y);
            int iz = (int)Math.floor(z);
            float ox = x - (float)ix;
            float oy = y - (float)iy;
            float oz = z - (float)iz;
            float jx = ox - 1.0f;
            float jy = oy - 1.0f;
            float jz = oz - 1.0f;
            float cn1 = ox * ox;
            float cn2 = oy * oy;
            float cn3 = oz * oz;
            float cn4 = jx * jx;
            float cn5 = jy * jy;
            float cn6 = jz * jz;
            cn1 = 1.0f - 3.0f * cn1 + 2.0f * cn1 * ox;
            cn2 = 1.0f - 3.0f * cn2 + 2.0f * cn2 * oy;
            cn3 = 1.0f - 3.0f * cn3 + 2.0f * cn3 * oz;
            cn4 = 1.0f - 3.0f * cn4 - 2.0f * cn4 * jx;
            cn5 = 1.0f - 3.0f * cn5 - 2.0f * cn5 * jy;
            cn6 = 1.0f - 3.0f * cn6 - 2.0f * cn6 * jz;
            short b00 = hash[hash[ix & 0xFF] + (iy & 0xFF)];
            short b10 = hash[hash[ix + 1 & 0xFF] + (iy & 0xFF)];
            short b01 = hash[hash[ix & 0xFF] + (iy + 1 & 0xFF)];
            short b11 = hash[hash[ix + 1 & 0xFF] + (iy + 1 & 0xFF)];
            int b20 = iz & 0xFF;
            int b21 = iz + 1 & 0xFF;
            float i = cn1 * cn2 * cn3;
            int hIndex = 3 * hash[b20 + b00];
            n += i * (hashvectf[hIndex] * ox + hashvectf[hIndex + 1] * oy + hashvectf[hIndex + 2] * oz);
            i = cn1 * cn2 * cn6;
            hIndex = 3 * hash[b21 + b00];
            n += i * (hashvectf[hIndex] * ox + hashvectf[hIndex + 1] * oy + hashvectf[hIndex + 2] * jz);
            i = cn1 * cn5 * cn3;
            hIndex = 3 * hash[b20 + b01];
            n += i * (hashvectf[hIndex] * ox + hashvectf[hIndex + 1] * jy + hashvectf[hIndex + 2] * oz);
            i = cn1 * cn5 * cn6;
            hIndex = 3 * hash[b21 + b01];
            n += i * (hashvectf[hIndex] * ox + hashvectf[hIndex + 1] * jy + hashvectf[hIndex + 2] * jz);
            i = cn4 * cn2 * cn3;
            hIndex = 3 * hash[b20 + b10];
            n += i * (hashvectf[hIndex] * jx + hashvectf[hIndex + 1] * oy + hashvectf[hIndex + 2] * oz);
            i = cn4 * cn2 * cn6;
            hIndex = 3 * hash[b21 + b10];
            n += i * (hashvectf[hIndex] * jx + hashvectf[hIndex + 1] * oy + hashvectf[hIndex + 2] * jz);
            i = cn4 * cn5 * cn3;
            hIndex = 3 * hash[b20 + b11];
            n += i * (hashvectf[hIndex] * jx + hashvectf[hIndex + 1] * jy + hashvectf[hIndex + 2] * oz);
            i = cn4 * cn5 * cn6;
            hIndex = 3 * hash[b21 + b11];
            if ((n += i * (hashvectf[hIndex] * jx + hashvectf[hIndex + 1] * jy + hashvectf[hIndex + 2] * jz)) < 0.0f) {
                n = 0.0f;
            } else if (n > 1.0f) {
                n = 1.0f;
            }
            return n;
        }

        public float newPerlin(float x, float y, float z) {
            float u = (float)Math.floor(x);
            float v = (float)Math.floor(y);
            float w = (float)Math.floor(z);
            int X = (int)u & 0xFF;
            int Y = (int)v & 0xFF;
            int Z = (int)w & 0xFF;
            x -= u;
            y -= v;
            z -= w;
            u = this.npfade(x);
            v = this.npfade(y);
            w = this.npfade(z);
            int A = hash[X] + Y;
            int AA = hash[A] + Z;
            int AB = hash[A + 1] + Z;
            int B = hash[X + 1] + Y;
            int BA = hash[B] + Z;
            int BB = hash[B + 1] + Z;
            return this.lerp(w, this.lerp(v, this.lerp(u, this.grad(hash[AA], x, y, z), this.grad(hash[BA], x - 1.0f, y, z)), this.lerp(u, this.grad(hash[AB], x, y - 1.0f, z), this.grad(hash[BB], x - 1.0f, y - 1.0f, z))), this.lerp(v, this.lerp(u, this.grad(hash[AA + 1], x, y, z - 1.0f), this.grad(hash[BA + 1], x - 1.0f, y, z - 1.0f)), this.lerp(u, this.grad(hash[AB + 1], x, y - 1.0f, z - 1.0f), this.grad(hash[BB + 1], x - 1.0f, y - 1.0f, z - 1.0f))));
        }

        protected static void cellNoiseV(float x, float y, float z, float[] ca) {
            int xi = (int)Math.floor(x);
            int yi = (int)Math.floor(y);
            int zi = (int)Math.floor(z);
            float[] p = AbstractNoiseFunc.hashPoint(xi, yi, zi);
            ca[0] = p[0];
            ca[1] = p[1];
            ca[2] = p[2];
        }

        protected float lerp(float t, float a, float b) {
            return a + t * (b - a);
        }

        protected float npfade(float t) {
            return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
        }

        protected float grad(int hash, float x, float y, float z) {
            float u;
            int h = hash & 0xF;
            float f = u = h < 8 ? x : y;
            float v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
            return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
        }

        protected float dot(float[] a, float[] b) {
            return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
        }

        protected float surve(float t) {
            return t * t * (3.0f - 2.0f * t);
        }

        protected float at(float rx, float ry, float rz, float[] q) {
            return rx * q[0] + ry * q[1] + rz * q[2];
        }
    }

    static interface IWaveForm {
        public float execute(float var1);
    }
}

