/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class MirrorModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(MirrorModifier.class.getName());

    public MirrorModifier(Structure modifier, DataRepository dataRepository) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flag", modifier.getFieldValue("flag"));
        params.put("tolerance", modifier.getFieldValue("tolerance"));
        Pointer pMirrorOb = (Pointer)modifier.getFieldValue("mirror_ob");
        if (pMirrorOb.isNotNull()) {
            params.put("mirrorob", pMirrorOb);
        }
        this.jmeModifierRepresentation = params;
    }

    public Node apply(Node node, DataRepository dataRepository) {
        Map modifierData = (Map)this.jmeModifierRepresentation;
        int flag = ((Number)modifierData.get("flag")).intValue();
        float[] mirrorFactor = new float[]{(flag & 8) != 0 ? -1.0f : 1.0f, (flag & 0x10) != 0 ? -1.0f : 1.0f, (flag & 0x20) != 0 ? -1.0f : 1.0f};
        float[] center = new float[]{0.0f, 0.0f, 0.0f};
        Pointer pObject = (Pointer)modifierData.get("mirrorob");
        if (pObject != null) {
            try {
                Structure objectStructure = pObject.fetchData(dataRepository.getInputStream()).get(0);
                ObjectHelper objectHelper = (ObjectHelper)dataRepository.getHelper(ObjectHelper.class);
                Node object = (Node)objectHelper.toObject(objectStructure, dataRepository);
                if (object != null) {
                    Vector3f translation = object.getWorldTranslation();
                    center[0] = translation.x;
                    center[1] = translation.y;
                    center[2] = translation.z;
                }
            }
            catch (BlenderFileException e) {
                LOGGER.log(Level.SEVERE, "Cannot load mirror''s reference object. Cause: {0}", e.getLocalizedMessage());
            }
        }
        float tolerance = ((Number)modifierData.get("tolerance")).floatValue();
        boolean mirrorU = (flag & 1) != 0;
        boolean mirrorV = (flag & 2) != 0;
        ArrayList<Geometry> geometriesToAdd = new ArrayList<Geometry>();
        for (int mirrorIndex = 0; mirrorIndex < 3; ++mirrorIndex) {
            if (mirrorFactor[mirrorIndex] != -1.0f) continue;
            for (Spatial spatial : node.getChildren()) {
                if (!(spatial instanceof Geometry)) continue;
                Mesh mesh = ((Geometry)spatial).getMesh();
                Mesh clone = mesh.deepClone();
                FloatBuffer position = mesh.getFloatBuffer(VertexBuffer.Type.Position);
                FloatBuffer bindPosePosition = mesh.getFloatBuffer(VertexBuffer.Type.BindPosePosition);
                FloatBuffer clonePosition = clone.getFloatBuffer(VertexBuffer.Type.Position);
                FloatBuffer cloneBindPosePosition = clone.getFloatBuffer(VertexBuffer.Type.BindPosePosition);
                FloatBuffer cloneNormals = clone.getFloatBuffer(VertexBuffer.Type.Normal);
                FloatBuffer cloneBindPoseNormals = clone.getFloatBuffer(VertexBuffer.Type.BindPoseNormal);
                IntBuffer cloneIndexes = (IntBuffer)clone.getBuffer(VertexBuffer.Type.Index).getData();
                for (int i = mirrorIndex; i < clonePosition.limit(); i += 3) {
                    float value = clonePosition.get(i);
                    float d = center[mirrorIndex] - value;
                    if (Math.abs(d) <= tolerance) {
                        clonePosition.put(i, center[mirrorIndex]);
                        cloneBindPosePosition.put(i, center[mirrorIndex]);
                        position.put(i, center[mirrorIndex]);
                        bindPosePosition.put(i, center[mirrorIndex]);
                    } else {
                        clonePosition.put(i, value + 2.0f * d);
                        cloneBindPosePosition.put(i, value + 2.0f * d);
                    }
                    cloneNormals.put(i, -cloneNormals.get(i));
                    cloneBindPoseNormals.put(i, -cloneNormals.get(i));
                    int vertexIndex = (i - mirrorIndex) / 3;
                    if (vertexIndex % 3 != 0 || vertexIndex >= cloneIndexes.limit()) continue;
                    int index = cloneIndexes.get(vertexIndex + 2);
                    cloneIndexes.put(vertexIndex + 2, cloneIndexes.get(vertexIndex + 1));
                    cloneIndexes.put(vertexIndex + 1, index);
                }
                if (mirrorU) {
                    FloatBuffer cloneUVs = (FloatBuffer)clone.getBuffer(VertexBuffer.Type.TexCoord).getData();
                    for (int i = 0; i < cloneUVs.limit(); i += 2) {
                        cloneUVs.put(i, 1.0f - cloneUVs.get(i));
                    }
                }
                if (mirrorV) {
                    FloatBuffer cloneUVs = (FloatBuffer)clone.getBuffer(VertexBuffer.Type.TexCoord).getData();
                    for (int i = 1; i < cloneUVs.limit(); i += 2) {
                        cloneUVs.put(i, 1.0f - cloneUVs.get(i));
                    }
                }
                Geometry geometry = new Geometry(null, clone);
                geometry.setMaterial(((Geometry)spatial).getMaterial());
                geometriesToAdd.add(geometry);
            }
            for (Geometry geometry : geometriesToAdd) {
                node.attachChild(geometry);
            }
            geometriesToAdd.clear();
        }
        return node;
    }

    public String getType() {
        return "MirrorModifierData";
    }
}

