/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.sync;

import com.jme3.network.connection.Client;
import com.jme3.network.events.MessageAdapter;
import com.jme3.network.message.Message;
import com.jme3.network.service.Service;
import com.jme3.network.sync.EntityFactory;
import com.jme3.network.sync.EntitySyncInfo;
import com.jme3.network.sync.MovingAverage;
import com.jme3.network.sync.SyncEntity;
import com.jme3.network.sync.SyncMessage;
import com.jme3.network.sync.SyncSerializer;
import com.jme3.util.IntMap;
import java.nio.ByteBuffer;

@Deprecated
public class ClientSyncService
extends MessageAdapter
implements Service {
    private static final ByteBuffer BUFFER = ByteBuffer.wrap(new byte[10000]);
    private final IntMap<ClientEntityInfo> entities = new IntMap();
    private EntityFactory factory;
    private SyncSerializer serializer = new SyncSerializer();
    private long lastSyncMsgTime = 0L;
    private int lastHeartbeat;
    private MovingAverage averageLatency = new MovingAverage(20);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(float tpf2) {
        long time = System.currentTimeMillis();
        IntMap<ClientEntityInfo> intMap = this.entities;
        synchronized (intMap) {
            for (IntMap.Entry<ClientEntityInfo> entry : this.entities) {
                ClientEntityInfo info = entry.getValue();
                if (info.lastSyncInfo != null && !this.inLoopApplySyncInfo(entry.getKey(), info)) continue;
                long timeSinceUpdate = time - info.lastUpdate;
                if (timeSinceUpdate >= info.lastUpdateRate) {
                    if (info.lastExtrapolate == -1L) {
                        info.entity.interpolate(1.0f);
                        info.lastExtrapolate = info.lastUpdate + info.lastUpdateRate;
                    }
                    long timeSinceExtrapolate = time - info.lastExtrapolate;
                    info.lastExtrapolate = time;
                    float tpf = (float)timeSinceExtrapolate / 1000.0f;
                    info.entity.extrapolate(tpf);
                    continue;
                }
                float blendAmount = (float)timeSinceUpdate / (float)info.lastUpdateRate;
                info.entity.interpolate(blendAmount);
            }
        }
    }

    public ClientSyncService(Client client) {
        client.addMessageListener(this);
    }

    public void setEntityFactory(EntityFactory factory) {
        this.factory = factory;
    }

    public SyncEntity getEntity(int id) {
        return this.entities.get((int)id).entity;
    }

    private void inLoopCreateEntity(int entityId, ClientEntityInfo clientInfo) {
        SyncEntity entity;
        Class<?> clazz;
        EntitySyncInfo initInfo = clientInfo.lastSyncInfo;
        try {
            clazz = Class.forName(initInfo.className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Cannot find entity class: " + initInfo.className, ex);
        }
        if (this.factory != null) {
            entity = this.factory.createEntity(clazz);
        } else {
            try {
                entity = (SyncEntity)clazz.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Entity class is missing empty constructor", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
        clientInfo.entity = entity;
        entity.onRemoteCreate();
        this.serializer.read(entity, ByteBuffer.wrap(initInfo.data), true);
        clientInfo.lastSyncInfo = null;
    }

    private void inLoopSyncEntity(int entityId, ClientEntityInfo entityInfo) {
        this.serializer.read(entityInfo.entity, ByteBuffer.wrap(entityInfo.lastSyncInfo.data), false);
        entityInfo.entity.onRemoteUpdate((float)entityInfo.lastLatencyDelta / 1000.0f);
        entityInfo.lastSyncInfo = null;
        entityInfo.lastLatencyDelta = Long.MAX_VALUE;
    }

    private void inLoopDeleteEntity(int entityId, ClientEntityInfo clientInfo) {
        SyncEntity entity = clientInfo.entity;
        entity.onRemoteDelete();
        this.entities.remove(entityId);
    }

    private boolean inLoopApplySyncInfo(int entityId, ClientEntityInfo clientInfo) {
        switch (clientInfo.lastSyncInfo.type) {
            case 1: {
                this.inLoopCreateEntity(entityId, clientInfo);
                return true;
            }
            case 2: {
                this.inLoopSyncEntity(entityId, clientInfo);
                return true;
            }
            case 3: {
                this.inLoopDeleteEntity(entityId, clientInfo);
                return false;
            }
        }
        throw new UnsupportedOperationException();
    }

    private void createEntity(EntitySyncInfo info) {
        ClientEntityInfo entityInfo = new ClientEntityInfo();
        entityInfo.lastUpdate = System.currentTimeMillis();
        entityInfo.lastSyncInfo = info;
        this.entities.put(info.id, entityInfo);
    }

    private void syncEntity(EntitySyncInfo info, int latencyDelta) {
        ClientEntityInfo entityInfo = this.entities.get(info.id);
        if (entityInfo == null || entityInfo.entity == null) {
            return;
        }
        long time = System.currentTimeMillis();
        entityInfo.lastUpdateRate = time - entityInfo.lastUpdate;
        entityInfo.lastUpdate = time;
        entityInfo.lastExtrapolate = -1L;
        entityInfo.lastSyncInfo = info;
        entityInfo.lastLatencyDelta = latencyDelta;
    }

    void deleteEntity(EntitySyncInfo info) {
        ClientEntityInfo clientInfo = this.entities.get(info.id);
        clientInfo.lastSyncInfo = info;
    }

    private void applySyncInfo(EntitySyncInfo info, int latencyDelta) {
        switch (info.type) {
            case 1: {
                this.createEntity(info);
                break;
            }
            case 2: {
                this.syncEntity(info, latencyDelta);
                break;
            }
            case 3: {
                this.deleteEntity(info);
            }
        }
    }

    public void messageReceived(Message msg) {
        if (!(msg instanceof SyncMessage)) {
            return;
        }
        int latencyDelta = 0;
        if (this.lastSyncMsgTime == 0L) {
            this.lastSyncMsgTime = System.currentTimeMillis();
        } else {
            long time = System.currentTimeMillis();
            long delta = time - this.lastSyncMsgTime;
            this.averageLatency.add(delta);
            this.lastSyncMsgTime = time;
            latencyDelta = (int)(delta - this.averageLatency.getAverage());
        }
        SyncMessage sync = (SyncMessage)msg;
        boolean isOldMessage = false;
        int newHeartbeat = sync.heartbeat;
        if (this.lastHeartbeat > newHeartbeat) {
            if (this.lastHeartbeat > 2147482647 && newHeartbeat < 1000) {
                this.lastHeartbeat = newHeartbeat;
            } else {
                isOldMessage = true;
            }
        } else {
            this.lastHeartbeat = newHeartbeat;
        }
        for (EntitySyncInfo info : sync.infos) {
            if (info.type == 2 && isOldMessage) continue;
            this.applySyncInfo(info, latencyDelta);
        }
    }

    private static class ClientEntityInfo {
        SyncEntity entity;
        EntitySyncInfo lastSyncInfo;
        EntitySyncInfo lastCreateInfo;
        long lastUpdate = 0L;
        long lastExtrapolate = -1L;
        long lastUpdateRate;
        long lastLatencyDelta = Long.MAX_VALUE;

        private ClientEntityInfo() {
        }
    }
}

