/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import com.jme3.app.Application;
import com.jme3.input.android.AndroidInput;
import com.jme3.input.controls.TouchListener;
import com.jme3.input.event.TouchEvent;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeSystem;
import com.jme3.system.android.AndroidConfigChooser;
import com.jme3.system.android.OGLESContext;
import com.jme3.util.JmeFormatter;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class AndroidHarness
extends Activity
implements TouchListener,
DialogInterface.OnClickListener {
    protected static final Logger logger = Logger.getLogger(AndroidHarness.class.getName());
    protected String appClass = "jme3test.android.Test";
    protected Application app = null;
    protected AndroidConfigChooser.ConfigType eglConfigType = AndroidConfigChooser.ConfigType.FASTEST;
    protected boolean eglConfigVerboseLogging = false;
    protected boolean mouseEventsEnabled = true;
    protected boolean mouseEventsInvertX = true;
    protected boolean mouseEventsInvertY = true;
    protected String exitDialogTitle = "Do you want to exit?";
    protected String exitDialogMessage = "Use your home key to bring this app into the background or exit to terminate it.";
    protected int screenOrientation = 4;
    protected OGLESContext ctx;
    protected GLSurfaceView view = null;
    protected boolean isGLThreadPaused = true;
    private final String ESCAPE_EVENT = "TouchEscape";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger log = logger;
        boolean bIsLogFormatSet = false;
        do {
            if (log.getHandlers().length != 0 || (log = logger.getParent()) == null) continue;
            for (Handler h : log.getHandlers()) {
                h.setFormatter(new JmeFormatter());
                bIsLogFormatSet = true;
            }
        } while (log != null && !bIsLogFormatSet);
        JmeSystem.setResources(this.getResources());
        JmeSystem.setActivity(this);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setRequestedOrientation(this.screenOrientation);
        AppSettings settings = new AppSettings(true);
        AndroidInput input = new AndroidInput((Context)this);
        input.setMouseEventsInvertX(this.mouseEventsInvertX);
        input.setMouseEventsInvertY(this.mouseEventsInvertY);
        input.setMouseEventsEnabled(this.mouseEventsEnabled);
        try {
            if (this.app == null) {
                Class<?> clazz = Class.forName(this.appClass);
                this.app = (Application)clazz.newInstance();
            }
            this.app.setSettings(settings);
            this.app.start();
            this.ctx = (OGLESContext)this.app.getContext();
            this.view = this.ctx.createView(input, this.eglConfigType, this.eglConfigVerboseLogging);
            this.setContentView((View)this.view);
            WindowManager wind = this.getWindowManager();
            Display disp = wind.getDefaultDisplay();
            this.ctx.getSettings().setResolution(disp.getWidth(), disp.getHeight());
            AppSettings s = this.ctx.getSettings();
            logger.info("Settings: Width " + s.getWidth() + " Height " + s.getHeight());
        }
        catch (Exception ex) {
            this.handleError("Class " + this.appClass + " init failed", ex);
            this.setContentView((View)new TextView((Context)this));
        }
    }

    protected void onRestart() {
        super.onRestart();
        if (this.app != null) {
            this.app.restart();
        }
        logger.info("onRestart");
    }

    protected void onStart() {
        super.onStart();
        logger.info("onStart");
    }

    protected void onResume() {
        super.onResume();
        if (this.view != null) {
            this.view.onResume();
        }
        this.isGLThreadPaused = false;
        logger.info("onResume");
    }

    protected void onPause() {
        super.onPause();
        if (this.view != null) {
            this.view.onPause();
        }
        this.isGLThreadPaused = true;
        logger.info("onPause");
    }

    protected void onStop() {
        super.onStop();
        logger.info("onStop");
    }

    protected void onDestroy() {
        if (this.app != null) {
            this.app.stop(!this.isGLThreadPaused);
        }
        super.onDestroy();
        logger.info("onDestroy");
    }

    public Application getJmeApplication() {
        return this.app;
    }

    public void handleError(final String errorMsg, final Throwable t) {
        String s = "";
        if (t != null && t.getStackTrace() != null) {
            for (StackTraceElement ste : t.getStackTrace()) {
                s = s + ste.getClassName() + "." + ste.getMethodName() + "(" + ste.getLineNumber() + ") ";
            }
        }
        final String sTrace = s;
        logger.severe(t != null ? t.toString() : "OpenGL Exception");
        logger.severe((errorMsg != null ? errorMsg + ": " : "") + sTrace);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog dialog = new AlertDialog.Builder((Context)AndroidHarness.this).setTitle((CharSequence)(t != null ? (t.getMessage() != null ? t.getMessage() + ": " + t.getClass().getName() : t.getClass().getName()) : "OpenGL Exception")).setPositiveButton((CharSequence)"Kill", (DialogInterface.OnClickListener)AndroidHarness.this).setMessage((CharSequence)((errorMsg != null ? errorMsg + ": " : "") + sTrace)).create();
                dialog.show();
            }
        });
    }

    public void onClick(DialogInterface dialog, int whichButton) {
        if (whichButton != -2) {
            if (this.app != null) {
                this.app.stop(true);
            }
            this.finish();
        }
    }

    @Override
    public void onTouch(String name, TouchEvent evt, float tpf) {
        if (name.equals("TouchEscape")) {
            switch (evt.getType()) {
                case KEY_UP: {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AlertDialog dialog = new AlertDialog.Builder((Context)AndroidHarness.this).setTitle((CharSequence)AndroidHarness.this.exitDialogTitle).setPositiveButton((CharSequence)"Yes", (DialogInterface.OnClickListener)AndroidHarness.this).setNegativeButton((CharSequence)"No", (DialogInterface.OnClickListener)AndroidHarness.this).setMessage((CharSequence)AndroidHarness.this.exitDialogMessage).create();
                            dialog.show();
                        }
                    });
                    break;
                }
            }
        }
    }
}

