/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.tutorial.screen;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Draggable;
import de.lessvoid.nifty.controls.DraggableDragCanceledEvent;
import de.lessvoid.nifty.controls.DraggableDragStartedEvent;
import de.lessvoid.nifty.controls.Droppable;
import de.lessvoid.nifty.controls.DroppableDroppedEvent;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlAttributes;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectOnHoverAttributes;
import de.lessvoid.nifty.controls.label.builder.CreateLabelControl;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

public class MainPage
implements ScreenController,
KeyInputHandler {
    private Nifty nifty;
    private Screen screen;
    private boolean mute = false;
    private ArrayList<String> pages = new ArrayList();
    private ArrayList<String> chapterCaption = new ArrayList();
    private Map<String, Integer> chapterPageMap = new Hashtable<String, Integer>();
    private int pageIndex = 0;
    private int lastPageIndex = 0;
    private boolean lastPageWasActive = false;
    private Element chapterSelectPopup;

    public void bind(Nifty nifty, Screen screen) {
        this.nifty = nifty;
        this.screen = screen;
        this.pages.add("pageWelcome");
        this.pages.add("pageIntro");
        this.pages.add("pageChapterWhatsNewInNifty1.2");
        this.pages.add("pageNifty1.2");
        this.pages.add("pageChapterI");
        this.pages.add("pageBasicsJava1");
        this.pages.add("pageBasicsJava1b");
        this.pages.add("pageBasicsJava1c");
        this.pages.add("pageBasicsLoadXml");
        this.pages.add("pageChapterII");
        this.pages.add("pageBasicsXML1");
        this.pages.add("pageBasicsXML2");
        this.pages.add("pageBasicsXMLLayout1");
        this.pages.add("pageBasicsXMLLayout2");
        this.pages.add("pageBasicsXMLLayout3");
        this.pages.add("pageBasicsXMLMarkup");
        this.pages.add("pageBasicsXMLLocalization");
        this.pages.add("pageChapterIII");
        this.pages.add("pageEffects1");
        this.pages.add("pageEffects2");
        this.pages.add("pageEffects3");
        this.pages.add("pageCustomEffects1");
        this.pages.add("pageChapterIV");
        this.pages.add("pageConnecting1");
        this.pages.add("pageConnecting2");
        this.pages.add("pageConnecting3");
        this.pages.add("pageBasicsEnd");
        this.pages.add("pageChapterV");
        this.pages.add("pageAdvancedStyles1");
        this.pages.add("pageAdvancedStyles2");
        this.pages.add("pageAdvancedStyles3");
        this.pages.add("pageChapterVI");
        this.pages.add("pageAdvancedControls1");
        this.pages.add("pageAdvancedControls2");
        this.pages.add("pageAdvancedControls3");
        this.pages.add("pageAdvancedControls4");
        this.pages.add("pageAdvancedControls5");
        this.pages.add("pageAdvancedControls6");
        this.pages.add("pageAdvancedControls7");
        this.pages.add("pageAdvancedControls8");
        this.pages.add("pageAdvancedControls9");
        this.pages.add("pageChapterVII");
        this.pages.add("pageDnD1");
        this.pages.add("pageDnD2");
        this.pages.add("pageDnD3");
        this.pages.add("pageDnD4");
        this.pages.add("pageChapterVIII");
        this.pages.add("pageSlick1");
        this.pages.add("pageSlick2");
        this.pages.add("pageSlick3");
        this.pages.add("pageTheEndTeaser");
        this.pages.add("pageTheEnd");
        this.pages.add("pageCredits");
        this.addChapter("Welcome", "pageWelcome");
        this.addChapter("What's new in Nifty 1.2", "pageChapterWhatsNewInNifty1.2");
        this.addChapter("Nifty Basics: Java", "pageChapterI");
        this.addChapter("Nifty Basics: Writing XML", "pageChapterII");
        this.addChapter("Nifty Basics: Effects", "pageChapterIII");
        this.addChapter("Nifty Basics: Connect Java with Nifty XML", "pageChapterIV");
        this.addChapter("Advanced Nifty: Styles", "pageChapterV");
        this.addChapter("Advanced Nifty: Controls", "pageChapterVI");
        this.addChapter("Advanced Nifty: Drag and Drop", "pageChapterVII");
        this.addChapter("Integrate Nifty with: Slick2d", "pageChapterVIII");
        this.addChapter("The End", "pageTheEndTeaser");
        this.addChapter("Credits", "pageCredits");
        ControlEffectOnHoverAttributes textColorEffect = new ControlEffectOnHoverAttributes();
        textColorEffect.setName("textColor");
        textColorEffect.setAttribute("color", "#a22f");
        this.chapterSelectPopup = nifty.createPopup("chapterSelectPopup");
        Element chapterSelectElement = this.chapterSelectPopup.findElementByName("#chapterSelect");
        int idx = 0;
        for (String label : this.chapterCaption) {
            CreateLabelControl createLabel = new CreateLabelControl(label);
            createLabel.setAlign("left");
            createLabel.setTextVAlign("center");
            createLabel.setTextHAlign("left");
            createLabel.setColor("#ccce");
            createLabel.setStyle("menuFont");
            createLabel.setVisibleToMouse("true");
            createLabel.addEffectsOnHover(textColorEffect);
            createLabel.setInteractOnClick("chapterSelect(" + idx + ")");
            createLabel.create(nifty, screen, chapterSelectElement);
            ++idx;
        }
        this.pageIndex = 0;
        this.lastPageIndex = -1;
        this.updatePage();
        this.updateBackButtonVisibility();
        nifty.addControls();
    }

    private void addChapter(String chapter, String page) {
        this.chapterCaption.add(chapter);
        this.chapterPageMap.put(String.valueOf(this.chapterCaption.size() - 1), this.pages.indexOf(page));
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    public void back() {
        --this.pageIndex;
        if (this.pageIndex < 0) {
            this.pageIndex = this.pages.size() - 1;
        }
        this.updateBackButtonVisibility();
        this.nifty.setAlternateKey("back");
        this.updatePage();
    }

    public void next() {
        ++this.pageIndex;
        if (this.pageIndex >= this.pages.size()) {
            this.lastPageWasActive = true;
            this.pageIndex = 0;
        }
        this.updateBackButtonVisibility();
        this.nifty.setAlternateKey(null);
        this.updatePage();
    }

    public void showChapterSelect() {
        this.nifty.showPopup(this.screen, this.chapterSelectPopup.getId(), null);
    }

    private void updateBackButtonVisibility() {
        Element backButtonElement = this.screen.findElementByName("backButton");
        if (this.pageIndex == 0) {
            if (!this.lastPageWasActive) {
                backButtonElement.setVisible(false);
            }
        } else if (this.pageIndex == 1) {
            this.showBackButton();
        }
        Element currentPageElement = this.screen.findElementByName("curPage");
        currentPageElement.startEffect(EffectEventId.onCustom);
        ((TextRenderer)currentPageElement.getRenderer(TextRenderer.class)).setText(String.valueOf(this.pageIndex + 1) + " / " + this.pages.size());
    }

    private void showBackButton() {
        Element backButtonElement = this.screen.findElementByName("backButton");
        if (!backButtonElement.isVisible()) {
            backButtonElement.setVisible(true);
        }
    }

    public void toggleMute() {
        System.out.println("toggleMute");
        boolean bl = this.mute = !this.mute;
        if (this.mute) {
            this.screen.findElementByName("muteButton").setStyle("muteButtonSoundOff");
            this.screen.findElementByName("muteButton").startEffect(EffectEventId.onCustom);
        } else {
            this.screen.findElementByName("muteButton").setStyle("muteButtonSoundOn");
            this.screen.findElementByName("muteButton").startEffect(EffectEventId.onCustom);
        }
    }

    private void updatePage() {
        String pageName = this.pages.get(this.pageIndex);
        CreatePageControl createControl = new CreatePageControl(pageName, "page_" + this.pageIndex);
        createControl.create(this.nifty, this.screen, this.screen.findElementByName("pp"));
        Element element = this.screen.findElementByName("page_" + this.lastPageIndex);
        if (element != null) {
            this.nifty.removeElement(this.screen, element, new EndNotify(){

                public void perform() {
                }
            });
        }
        this.lastPageIndex = this.pageIndex;
    }

    public boolean keyEvent(NiftyInputEvent inputEvent) {
        if (NiftyInputEvent.MoveCursorRight.equals((Object)inputEvent)) {
            this.screen.findElementByName("nextButton").onClick();
            return true;
        }
        if (NiftyInputEvent.MoveCursorLeft.equals((Object)inputEvent)) {
            this.screen.findElementByName("backButton").onClick();
            return true;
        }
        return false;
    }

    public void chapterSelect(final String chapterLabel) {
        this.nifty.closePopup(this.chapterSelectPopup.getId(), new EndNotify(){

            public void perform() {
                MainPage.this.pageIndex = (Integer)MainPage.this.chapterPageMap.get(chapterLabel);
                MainPage.this.showBackButton();
                MainPage.this.updatePage();
                MainPage.this.updateBackButtonVisibility();
            }
        });
    }

    public void openLink(String url) {
        if (!Desktop.isDesktopSupported()) {
            System.err.println("Desktop is not supported (Can't open link)");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            System.err.println("Desktop (BROWSE) is not supported (Can't open link)");
            return;
        }
        try {
            URI uri = new URI(url);
            desktop.browse(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NiftyEventSubscriber(id="draggable")
    public void onDragStart(String id, DraggableDragStartedEvent event) {
        this.changeInfoText("dragStart() for source: " + this.getDroppableId(event.getSource()) + " with draggable: " + this.getDraggableId(event.getDraggable()));
    }

    @NiftyEventSubscriber(id="draggable")
    public void onDragCancel(String id, DraggableDragCanceledEvent event) {
        this.changeInfoText("dragCancel() for source: " + this.getDroppableId(event.getSource()) + " with draggable: " + this.getDraggableId(event.getDraggable()));
    }

    @NiftyEventSubscriber(pattern="droppable.")
    public void onDropped(String id, DroppableDroppedEvent event) {
        this.changeInfoText("drop() for source: " + this.getDroppableId(event.getSource()) + " with draggable: " + this.getDraggableId(event.getDraggable()) + " on target: " + this.getDroppableId(event.getTarget()));
    }

    private String getDroppableId(Droppable source) {
        if (source == null) {
            return "null";
        }
        if (source.getElement() == null) {
            return "null element";
        }
        return source.getElement().getId();
    }

    private String getDraggableId(Draggable draggable) {
        if (draggable == null) {
            return "null";
        }
        if (draggable.getElement() == null) {
            return "null element";
        }
        return draggable.getElement().getId();
    }

    private void changeInfoText(String text) {
        Element infoText = this.screen.findElementByName("DragAndDropInfoText");
        if (infoText != null) {
            ((TextRenderer)infoText.getRenderer(TextRenderer.class)).setText(text);
        }
    }

    public class CreatePageControl
    extends ControlAttributes {
        public CreatePageControl(String name, String id) {
            this.setAutoId(id);
            this.setName(name);
        }

        public void create(Nifty nifty, Screen screen, Element parent) {
            nifty.addControl(screen, parent, this.getStandardControl());
        }

        public ElementType createType() {
            return null;
        }
    }
}

