/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.List;

public class Gradient
implements EffectImpl {
    private List<Entry> entries = new ArrayList<Entry>();
    private boolean horizontal = false;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.entries.clear();
        for (Attributes entry : parameter.getEffectValues().getValues()) {
            SizeValue offset = new SizeValue(entry.get("offset"));
            Color color = entry.getAsColor("color");
            this.entries.add(new Entry(offset, color));
        }
        this.horizontal = "horizontal".equals(parameter.getProperty("direction", "vertical"));
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        block4: {
            if (!(normalizedTime > 0.0f)) break block4;
            if (this.horizontal) {
                for (int i = 1; i < this.entries.size(); ++i) {
                    Entry entry1 = this.entries.get(i - 1);
                    Entry entry2 = this.entries.get(i);
                    r.renderQuad(Math.round((float)element.getX() + entry1.offset.getValue(element.getWidth())), element.getY(), Math.round(entry2.offset.getValue(element.getWidth()) - entry1.offset.getValue(element.getWidth())), element.getHeight(), entry1.color, entry2.color, entry2.color, entry1.color);
                }
            } else {
                for (int i = 1; i < this.entries.size(); ++i) {
                    Entry entry1 = this.entries.get(i - 1);
                    Entry entry2 = this.entries.get(i);
                    int yStart = Math.round((float)element.getY() + entry1.offset.getValue(element.getHeight()));
                    int yEnd = Math.round((float)element.getY() + entry2.offset.getValue(element.getHeight()));
                    r.renderQuad(element.getX(), yStart, element.getWidth(), yEnd - yStart, entry1.color, entry1.color, entry2.color, entry2.color);
                }
            }
        }
    }

    @Override
    public void deactivate() {
    }

    private class Entry {
        public SizeValue offset;
        public Color color;

        public Entry(SizeValue offset, Color color) {
            this.offset = offset;
            this.color = color;
        }
    }
}

