/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.ContextAccumulatorMeasurement;
import com.jeantessier.metrics.CounterMeasurement;
import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.MeasurementVisitor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.NameListMeasurement;
import com.jeantessier.metrics.NbSubMetricsMeasurement;
import com.jeantessier.metrics.RatioMeasurement;
import com.jeantessier.metrics.SubMetricsAccumulatorMeasurement;
import com.jeantessier.metrics.SumMeasurement;
import java.io.PrintWriter;
import java.util.Collection;

public abstract class Printer
implements MeasurementVisitor {
    public static final String DEFAULT_INDENT_TEXT = "    ";
    private PrintWriter out;
    private boolean showEmptyMetrics = false;
    private boolean showHiddenMeasurements = false;
    private String indentText = "    ";
    private int indentLevel = 0;

    public Printer(PrintWriter out) {
        this.out = out;
    }

    public String getIndentText() {
        return this.indentText;
    }

    public void setIndentText(String indentText) {
        this.indentText = indentText;
    }

    public boolean isShowEmptyMetrics() {
        return this.showEmptyMetrics;
    }

    public void setShowEmptyMetrics(boolean showEmptyMetrics) {
        this.showEmptyMetrics = showEmptyMetrics;
    }

    public boolean isShowHiddenMeasurements() {
        return this.showHiddenMeasurements;
    }

    public void setShowHiddenMeasurements(boolean showHiddenMeasurements) {
        this.showHiddenMeasurements = showHiddenMeasurements;
    }

    protected Printer append(boolean b) {
        this.out.print(b);
        return this;
    }

    protected Printer append(char c) {
        this.out.print(c);
        return this;
    }

    protected Printer append(char[] s) {
        this.out.print(s);
        return this;
    }

    protected Printer append(double d) {
        this.out.print(d);
        return this;
    }

    protected Printer append(float f) {
        this.out.print(f);
        return this;
    }

    protected Printer append(int i) {
        this.out.print(i);
        return this;
    }

    protected Printer append(long l) {
        this.out.print(l);
        return this;
    }

    protected Printer append(Object obj) {
        this.out.print(obj);
        return this;
    }

    protected Printer append(String s) {
        this.out.print(s);
        return this;
    }

    protected Printer indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.append(this.getIndentText());
        }
        return this;
    }

    protected Printer eol() {
        this.out.println();
        return this;
    }

    protected void raiseIndent() {
        ++this.indentLevel;
    }

    protected void lowerIndent() {
        --this.indentLevel;
    }

    public void visitMetrics(Collection<Metrics> metrics) {
        for (Metrics metric : metrics) {
            this.visitMetrics(metric);
        }
    }

    public abstract void visitMetrics(Metrics var1);

    @Override
    public void visitRatioMeasurement(RatioMeasurement measurement) {
        this.visitMeasurement(measurement);
    }

    @Override
    public void visitNbSubMetricsMeasurement(NbSubMetricsMeasurement measurement) {
        this.visitMeasurement(measurement);
    }

    @Override
    public void visitCounterMeasurement(CounterMeasurement measurement) {
        this.visitMeasurement(measurement);
    }

    @Override
    public void visitContextAccumulatorMeasurement(ContextAccumulatorMeasurement measurement) {
        this.visitMeasurement(measurement);
    }

    @Override
    public void visitNameListMeasurement(NameListMeasurement measurement) {
        this.visitMeasurement(measurement);
    }

    @Override
    public void visitSubMetricsAccumulatorMeasurement(SubMetricsAccumulatorMeasurement measurement) {
        this.visitMeasurement(measurement);
    }

    @Override
    public void visitSumMeasurement(SumMeasurement measurement) {
        this.visitMeasurement(measurement);
    }

    protected abstract void visitMeasurement(Measurement var1);
}

