/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.Metrics;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class MeasurementDescriptor {
    private static final Class[] constructorSignature = new Class[]{MeasurementDescriptor.class, Metrics.class, String.class};
    private String shortName;
    private String longName;
    private Class classFor;
    private String initText;
    private Comparable lowerThreshold;
    private Comparable upperThreshold;
    private boolean visible = true;
    private boolean cached = true;

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public Class getClassFor() {
        return this.classFor;
    }

    public void setClassFor(Class classFor) {
        if (classFor == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        this.classFor = classFor;
    }

    public void getClassForByName(String className) throws ClassNotFoundException {
        this.classFor = Class.forName(className);
    }

    public String getInitText() {
        return this.initText;
    }

    public void setInitText(String initText) {
        this.initText = initText;
    }

    public Comparable getLowerThreshold() {
        return this.lowerThreshold;
    }

    public void setLowerThreshold(Comparable lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public Comparable getUpperThreshold() {
        return this.upperThreshold;
    }

    public void setUpperThreshold(Comparable upperThreshold) {
        this.upperThreshold = upperThreshold;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public Measurement createMeasurement() throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return this.createMeasurement(null);
    }

    public Measurement createMeasurement(Metrics context) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Measurement result = null;
        Constructor constructor = this.getClassFor().getConstructor(constructorSignature);
        Object[] params = new Object[]{this, context, this.getInitText()};
        result = (Measurement)constructor.newInstance(params);
        return result;
    }

    public String getRangeAsString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(this.getLowerThreshold() != null ? this.getLowerThreshold().toString() : "*");
        result.append(", ");
        result.append(this.getUpperThreshold() != null ? this.getUpperThreshold().toString() : "*");
        result.append("]");
        return result.toString();
    }
}

