/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.Node;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class Cycle
implements Comparable {
    private List<Node> path;

    public Cycle(List<Node> path) {
        TreeSet<Node> nodes = new TreeSet<Node>(path);
        Node first = (Node)nodes.iterator().next();
        LinkedList<Node> rawPath = new LinkedList<Node>(path);
        while (!rawPath.getFirst().equals(first)) {
            rawPath.addLast(rawPath.removeFirst());
        }
        this.path = rawPath;
    }

    public List<Node> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    public int getLength() {
        return this.getPath().size();
    }

    public boolean equals(Object object) {
        Cycle other;
        boolean result = this == object ? true : (object == null || this.getClass() != object.getClass() ? false : this.compareTo(other = (Cycle)object) == 0);
        return result;
    }

    public int hashCode() {
        return ((Object)this.getPath()).hashCode();
    }

    public int compareTo(Object object) {
        int result;
        if (this == object) {
            result = 0;
        } else {
            if (object == null) {
                throw new ClassCastException("compareTo: expected a " + this.getClass().getName() + " but got null");
            }
            if (!(object instanceof Cycle)) {
                throw new ClassCastException("compareTo: expected a " + this.getClass().getName() + " but got a " + object.getClass().getName());
            }
            Cycle other = (Cycle)object;
            result = this.getLength() - other.getLength();
            Iterator<Node> theseNodes = this.getPath().iterator();
            Iterator<Node> otherNodes = other.getPath().iterator();
            while (result == 0 && theseNodes.hasNext() && otherNodes.hasNext()) {
                result = theseNodes.next().compareTo(otherNodes.next());
            }
        }
        return result;
    }

    public String toString() {
        return this.getPath().toString();
    }
}

