/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.google.common.collect.Maps;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.LoadAdapter;
import com.jeantessier.classreader.LoadEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PackageMapper
extends LoadAdapter {
    private Map<String, Map<String, Classfile>> packages = Maps.newHashMap();

    public Collection<String> getPackageNames() {
        return this.packages.keySet();
    }

    public Map<String, Classfile> getPackage(String packageName) {
        return this.packages.get(packageName);
    }

    @Override
    public void endClassfile(LoadEvent event) {
        Classfile classfile = event.getClassfile();
        String packageName = classfile.getPackageName();
        HashMap map = this.packages.get(packageName);
        if (map == null) {
            map = Maps.newHashMap();
            this.packages.put(packageName, map);
        }
        map.put(classfile.getClassName(), classfile);
    }
}

