/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.GroupData;
import com.jeantessier.classreader.LoadAdapter;
import com.jeantessier.classreader.LoadEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

public class LoadListenerBase
extends LoadAdapter {
    private LinkedList<GroupData> groups = new LinkedList();
    private Collection<String> visitedFiles = new HashSet<String>();

    protected GroupData getCurrentGroup() {
        GroupData result = null;
        if (!this.groups.isEmpty()) {
            result = this.groups.getLast();
        }
        return result;
    }

    protected Collection<String> getVisitedFiles() {
        return this.visitedFiles;
    }

    @Override
    public void beginGroup(LoadEvent event) {
        this.groups.add(new GroupData(event.getGroupName(), event.getSize()));
    }

    @Override
    public void beginFile(LoadEvent event) {
        this.getCurrentGroup().incrementCount();
    }

    @Override
    public void endClassfile(LoadEvent event) {
        this.visitedFiles.add(event.getFilename());
    }

    @Override
    public void endGroup(LoadEvent event) {
        this.visitedFiles.add(event.getGroupName());
        this.groups.removeLast();
    }
}

