/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.jme3.gde.vehiclecreator;

import com.jme3.gde.core.assets.BinaryModelDataObject;
import com.jme3.gde.core.assets.ProjectAssetManager;
import com.jme3.gde.core.scene.PreviewRequest;
import com.jme3.gde.core.scene.SceneApplication;
import com.jme3.gde.core.scene.SceneListener;
import com.jme3.gde.core.scene.SceneRequest;
import com.jme3.gde.core.sceneexplorer.nodes.JmeNode;
import com.jme3.gde.core.sceneexplorer.nodes.NodeUtility;
import com.jme3.gde.core.sceneviewer.SceneViewerTopComponent;
import com.jme3.light.DirectionalLight;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import java.util.logging.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.util.ImageUtilities;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.util.HelpCtx;

/**
 * Top component which displays something.
 */
@ConvertAsProperties(dtd = "-//com.jme3.gde.vehiclecreator//VehicleCreator//EN",
autostore = false)
public final class VehicleCreatorTopComponent extends TopComponent implements SceneListener {

    private static VehicleCreatorTopComponent instance;
    /** path to the icon used by the component and its open action */
    static final String ICON_PATH = "com/jme3/gde/vehiclecreator/objects_039.gif";
    private static final String PREFERRED_ID = "VehicleCreatorTopComponent";
    private VehicleEditorController editorController;
    private SceneRequest currentRequest;
    private boolean testing = false;
    DirectionalLight dirLight = new DirectionalLight();
    private HelpCtx ctx = new HelpCtx("sdk.vehicle_creator");

    public VehicleCreatorTopComponent() {
        initComponents();
        setName(NbBundle.getMessage(VehicleCreatorTopComponent.class, "CTL_VehicleCreatorTopComponent"));
        setToolTipText(NbBundle.getMessage(VehicleCreatorTopComponent.class, "HINT_VehicleCreatorTopComponent"));
        setIcon(ImageUtilities.loadImage(ICON_PATH, true));

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jToolBar10 = new javax.swing.JToolBar();
        jButton5 = new javax.swing.JButton();
        jSeparator4 = new javax.swing.JToolBar.Separator();
        jLabel4 = new javax.swing.JLabel();
        motorForceSpinner = new javax.swing.JSpinner();
        brakeForceSpinner = new javax.swing.JSpinner();
        jSeparator3 = new javax.swing.JToolBar.Separator();
        jPanel10 = new javax.swing.JPanel();
        jSeparator1 = new javax.swing.JToolBar.Separator();
        jPanel13 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jToolBar3 = new javax.swing.JToolBar();
        jButton2 = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jToolBar4 = new javax.swing.JToolBar();
        jButton8 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jToolBar11 = new javax.swing.JToolBar();
        jPanel12 = new javax.swing.JPanel();
        jToolBar13 = new javax.swing.JToolBar();
        jButton1 = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        frontCheckBox = new javax.swing.JCheckBox();
        jToolBar14 = new javax.swing.JToolBar();
        boundingRadioButton = new javax.swing.JRadioButton();
        jPanel14 = new javax.swing.JPanel();
        boundingSpinner = new javax.swing.JSpinner();
        jToolBar15 = new javax.swing.JToolBar();
        jLabel5 = new javax.swing.JLabel();
        jPanel6 = new javax.swing.JPanel();
        axisSpinner = new javax.swing.JSpinner();
        jToolBar16 = new javax.swing.JToolBar();
        fixedRadioButton = new javax.swing.JRadioButton();
        jPanel11 = new javax.swing.JPanel();
        fixedSpinner = new javax.swing.JSpinner();
        jToolBar5 = new javax.swing.JToolBar();
        createNodeCheckBox = new javax.swing.JCheckBox();
        jPanel8 = new javax.swing.JPanel();
        jToolBar2 = new javax.swing.JToolBar();
        jLabel2 = new javax.swing.JLabel();
        compressionSlider = new javax.swing.JSlider();
        jLabel1 = new javax.swing.JLabel();
        releaseSlider = new javax.swing.JSlider();
        jToolBar6 = new javax.swing.JToolBar();
        jLabel6 = new javax.swing.JLabel();
        stiffnessSlider = new javax.swing.JSlider();
        jLabel10 = new javax.swing.JLabel();
        rollSlider = new javax.swing.JSlider();
        jToolBar7 = new javax.swing.JToolBar();
        jLabel11 = new javax.swing.JLabel();
        restSpinner = new javax.swing.JSpinner();
        jSeparator6 = new javax.swing.JToolBar.Separator();
        jLabel7 = new javax.swing.JLabel();
        forceSpinner = new javax.swing.JSpinner();
        jPanel7 = new javax.swing.JPanel();
        jToolBar9 = new javax.swing.JToolBar();
        jLabel9 = new javax.swing.JLabel();
        frictionSpinner = new javax.swing.JSpinner();
        jPanel15 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jToolBar1 = new javax.swing.JToolBar();
        jLabel8 = new javax.swing.JLabel();
        jPanel9 = new javax.swing.JPanel();
        jButton3 = new javax.swing.JButton();
        jButton6 = new javax.swing.JButton();
        jButton7 = new javax.swing.JButton();

        jToolBar10.setFloatable(false);
        jToolBar10.setRollover(true);

        jButton5.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/vehiclecreator/car-icon.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jButton5, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton5.text")); // NOI18N
        jButton5.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton5.toolTipText")); // NOI18N
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });
        jToolBar10.add(jButton5);
        jToolBar10.add(jSeparator4);

        jLabel4.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel4.text")); // NOI18N
        jToolBar10.add(jLabel4);

        motorForceSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(800.0f), null, null, Float.valueOf(1.0f)));
        motorForceSpinner.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.motorForceSpinner.toolTipText")); // NOI18N
        motorForceSpinner.setPreferredSize(new java.awt.Dimension(80, 28));
        motorForceSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                motorForceSpinnerStateChanged(evt);
            }
        });
        jToolBar10.add(motorForceSpinner);

        brakeForceSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(40.0f), null, null, Float.valueOf(1.0f)));
        brakeForceSpinner.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.brakeForceSpinner.toolTipText")); // NOI18N
        brakeForceSpinner.setPreferredSize(new java.awt.Dimension(80, 28));
        brakeForceSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                brakeForceSpinnerStateChanged(evt);
            }
        });
        jToolBar10.add(brakeForceSpinner);
        jToolBar10.add(jSeparator3);

        javax.swing.GroupLayout jPanel10Layout = new javax.swing.GroupLayout(jPanel10);
        jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(
            jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 434, Short.MAX_VALUE)
        );
        jPanel10Layout.setVerticalGroup(
            jPanel10Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar10.add(jPanel10);
        jToolBar10.add(jSeparator1);

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jPanel2.border.title"))); // NOI18N

        jToolBar3.setFloatable(false);
        jToolBar3.setRollover(true);

        org.openide.awt.Mnemonics.setLocalizedText(jButton2, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton2.text")); // NOI18N
        jButton2.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton2.toolTipText")); // NOI18N
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        jToolBar3.add(jButton2);

        jPanel5.setPreferredSize(new java.awt.Dimension(100, 21));

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar3.add(jPanel5);

        jToolBar4.setFloatable(false);
        jToolBar4.setRollover(true);

        org.openide.awt.Mnemonics.setLocalizedText(jButton8, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton8.text")); // NOI18N
        jButton8.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton8.toolTipText")); // NOI18N
        jButton8.setFocusable(false);
        jButton8.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton8.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton8.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton8ActionPerformed(evt);
            }
        });
        jToolBar4.add(jButton8);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar3, javax.swing.GroupLayout.DEFAULT_SIZE, 187, Short.MAX_VALUE)
            .addComponent(jToolBar4, javax.swing.GroupLayout.DEFAULT_SIZE, 187, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jToolBar3, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 115, Short.MAX_VALUE)
                .addComponent(jToolBar4, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jPanel1.border.title"))); // NOI18N

        jToolBar11.setFloatable(false);
        jToolBar11.setRollover(true);

        javax.swing.GroupLayout jPanel12Layout = new javax.swing.GroupLayout(jPanel12);
        jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(
            jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 276, Short.MAX_VALUE)
        );
        jPanel12Layout.setVerticalGroup(
            jPanel12Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar11.add(jPanel12);

        jToolBar13.setFloatable(false);
        jToolBar13.setRollover(true);

        jButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/vehiclecreator/objects_039.gif"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jButton1, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton1.text")); // NOI18N
        jButton1.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton1.toolTipText")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jToolBar13.add(jButton1);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar13.add(jPanel3);

        frontCheckBox.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(frontCheckBox, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.frontCheckBox.text")); // NOI18N
        frontCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.frontCheckBox.toolTipText")); // NOI18N
        frontCheckBox.setFocusable(false);
        frontCheckBox.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar13.add(frontCheckBox);

        jToolBar14.setFloatable(false);
        jToolBar14.setRollover(true);

        buttonGroup1.add(boundingRadioButton);
        boundingRadioButton.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(boundingRadioButton, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.boundingRadioButton.text")); // NOI18N
        boundingRadioButton.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.boundingRadioButton.toolTipText")); // NOI18N
        boundingRadioButton.setFocusable(false);
        boundingRadioButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar14.add(boundingRadioButton);

        javax.swing.GroupLayout jPanel14Layout = new javax.swing.GroupLayout(jPanel14);
        jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(
            jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 15, Short.MAX_VALUE)
        );
        jPanel14Layout.setVerticalGroup(
            jPanel14Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar14.add(jPanel14);

        boundingSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(1.0f), null, null, Float.valueOf(0.1f)));
        boundingSpinner.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.boundingSpinner.toolTipText")); // NOI18N
        boundingSpinner.setPreferredSize(new java.awt.Dimension(50, 28));
        jToolBar14.add(boundingSpinner);

        jToolBar15.setFloatable(false);
        jToolBar15.setRollover(true);

        jLabel5.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel5.text")); // NOI18N
        jToolBar15.add(jLabel5);

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 155, Short.MAX_VALUE)
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar15.add(jPanel6);

        axisSpinner.setModel(new javax.swing.SpinnerListModel(new String[] {"+Z", "-Z", "+X", "-X"}));
        axisSpinner.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.axisSpinner.toolTipText")); // NOI18N
        jToolBar15.add(axisSpinner);

        jToolBar16.setFloatable(false);
        jToolBar16.setRollover(true);

        buttonGroup1.add(fixedRadioButton);
        fixedRadioButton.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(fixedRadioButton, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.fixedRadioButton.text")); // NOI18N
        fixedRadioButton.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.fixedRadioButton.toolTipText")); // NOI18N
        fixedRadioButton.setFocusable(false);
        fixedRadioButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar16.add(fixedRadioButton);

        javax.swing.GroupLayout jPanel11Layout = new javax.swing.GroupLayout(jPanel11);
        jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 127, Short.MAX_VALUE)
        );
        jPanel11Layout.setVerticalGroup(
            jPanel11Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar16.add(jPanel11);

        fixedSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(1.0f), null, null, Float.valueOf(0.1f)));
        fixedSpinner.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.fixedSpinner.toolTipText")); // NOI18N
        fixedSpinner.setPreferredSize(new java.awt.Dimension(50, 28));
        jToolBar16.add(fixedSpinner);

        jToolBar5.setFloatable(false);
        jToolBar5.setRollover(true);

        createNodeCheckBox.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        createNodeCheckBox.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(createNodeCheckBox, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.createNodeCheckBox.text")); // NOI18N
        createNodeCheckBox.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.createNodeCheckBox.toolTipText")); // NOI18N
        createNodeCheckBox.setFocusable(false);
        createNodeCheckBox.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar5.add(createNodeCheckBox);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar13, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
            .addComponent(jToolBar14, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
            .addComponent(jToolBar16, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
            .addComponent(jToolBar15, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
            .addComponent(jToolBar11, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
            .addComponent(jToolBar5, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jToolBar13, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar14, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar16, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar15, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar5, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE)
                .addComponent(jToolBar11, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        jPanel8.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jPanel8.border.title"))); // NOI18N

        jToolBar2.setFloatable(false);
        jToolBar2.setRollover(true);

        jLabel2.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel2.text")); // NOI18N
        jToolBar2.add(jLabel2);

        compressionSlider.setMinimum(1);
        compressionSlider.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.compressionSlider.toolTipText")); // NOI18N
        compressionSlider.setValue(30);
        jToolBar2.add(compressionSlider);

        jLabel1.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel1.text")); // NOI18N
        jToolBar2.add(jLabel1);

        releaseSlider.setMinimum(1);
        releaseSlider.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.releaseSlider.toolTipText")); // NOI18N
        releaseSlider.setValue(40);
        jToolBar2.add(releaseSlider);

        jToolBar6.setFloatable(false);
        jToolBar6.setRollover(true);

        jLabel6.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel6, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel6.text")); // NOI18N
        jToolBar6.add(jLabel6);

        stiffnessSlider.setMaximum(220);
        stiffnessSlider.setMinimum(10);
        stiffnessSlider.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.stiffnessSlider.toolTipText")); // NOI18N
        stiffnessSlider.setPreferredSize(new java.awt.Dimension(260, 29));
        jToolBar6.add(stiffnessSlider);

        jLabel10.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel10, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel10.text")); // NOI18N
        jToolBar6.add(jLabel10);

        rollSlider.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.rollSlider.toolTipText")); // NOI18N
        jToolBar6.add(rollSlider);

        jToolBar7.setFloatable(false);
        jToolBar7.setRollover(true);

        jLabel11.setFont(new java.awt.Font("Lucida Grande", 0, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel11, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel11.text")); // NOI18N
        jToolBar7.add(jLabel11);

        restSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(0.2f), null, null, Float.valueOf(0.01f)));
        restSpinner.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.restSpinner.toolTipText")); // NOI18N
        restSpinner.setPreferredSize(new java.awt.Dimension(80, 28));
        jToolBar7.add(restSpinner);
        jToolBar7.add(jSeparator6);

        jLabel7.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel7, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel7.text")); // NOI18N
        jToolBar7.add(jLabel7);

        forceSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(6000.0f), null, null, Float.valueOf(1.0f)));
        forceSpinner.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.forceSpinner.toolTipText")); // NOI18N
        forceSpinner.setPreferredSize(new java.awt.Dimension(80, 28));
        jToolBar7.add(forceSpinner);

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 46, Short.MAX_VALUE)
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 28, Short.MAX_VALUE)
        );

        jToolBar7.add(jPanel7);

        jToolBar9.setFloatable(false);
        jToolBar9.setRollover(true);

        jLabel9.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel9, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel9.text")); // NOI18N
        jToolBar9.add(jLabel9);

        frictionSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(10.5f), null, null, Float.valueOf(0.1f)));
        frictionSpinner.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.frictionSpinner.toolTipText")); // NOI18N
        frictionSpinner.setPreferredSize(new java.awt.Dimension(80, 28));
        jToolBar9.add(frictionSpinner);

        javax.swing.GroupLayout jPanel15Layout = new javax.swing.GroupLayout(jPanel15);
        jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(
            jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 101, Short.MAX_VALUE)
        );
        jPanel15Layout.setVerticalGroup(
            jPanel15Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar9.add(jPanel15);

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 127, Short.MAX_VALUE)
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar9.add(jPanel4);

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);

        jLabel8.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel8, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jLabel8.text")); // NOI18N
        jToolBar1.add(jLabel8);

        javax.swing.GroupLayout jPanel9Layout = new javax.swing.GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 93, Short.MAX_VALUE)
        );
        jPanel9Layout.setVerticalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 21, Short.MAX_VALUE)
        );

        jToolBar1.add(jPanel9);

        org.openide.awt.Mnemonics.setLocalizedText(jButton3, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton3.text")); // NOI18N
        jButton3.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton3.toolTipText")); // NOI18N
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton3);

        org.openide.awt.Mnemonics.setLocalizedText(jButton6, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton6.text")); // NOI18N
        jButton6.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton6.toolTipText")); // NOI18N
        jButton6.setFocusable(false);
        jButton6.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton6.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton6ActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton6);

        org.openide.awt.Mnemonics.setLocalizedText(jButton7, org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton7.text")); // NOI18N
        jButton7.setToolTipText(org.openide.util.NbBundle.getMessage(VehicleCreatorTopComponent.class, "VehicleCreatorTopComponent.jButton7.toolTipText")); // NOI18N
        jButton7.setFocusable(false);
        jButton7.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton7.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton7.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton7ActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton7);

        javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar7, javax.swing.GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
            .addComponent(jToolBar6, javax.swing.GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
            .addComponent(jToolBar2, javax.swing.GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
            .addComponent(jToolBar9, javax.swing.GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addComponent(jToolBar7, javax.swing.GroupLayout.PREFERRED_SIZE, 32, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar6, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar2, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar9, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE)
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        javax.swing.GroupLayout jPanel13Layout = new javax.swing.GroupLayout(jPanel13);
        jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(
            jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel13Layout.createSequentialGroup()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel13Layout.setVerticalGroup(
            jPanel13Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jPanel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel13, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(jToolBar10, javax.swing.GroupLayout.DEFAULT_SIZE, 871, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jToolBar10, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel13, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        editorController.addWheel(getSuspensionSettings());
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        editorController.createHullShapeFromSelected();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton8ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton8ActionPerformed
        editorController.centerSelected();
    }//GEN-LAST:event_jButton8ActionPerformed

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
        if (testing) {
            editorController.stopVehicle();
            jButton5.setText("test vehicle");
            testing = false;
        } else {
            SceneViewerTopComponent.findInstance().requestActive();
            editorController.testVehicle();
            jButton5.setText("stop testing");
            testing = true;
        }
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        editorController.applyWheelData(0, getSuspensionSettings());
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
        editorController.applyWheelData(1, getSuspensionSettings());
    }//GEN-LAST:event_jButton6ActionPerformed

    private void jButton7ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton7ActionPerformed
        editorController.applyWheelData(2, getSuspensionSettings());
    }//GEN-LAST:event_jButton7ActionPerformed

    private void motorForceSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_motorForceSpinnerStateChanged
        editorController.setMotorForce((Float) motorForceSpinner.getValue());
    }//GEN-LAST:event_motorForceSpinnerStateChanged

    private void brakeForceSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_brakeForceSpinnerStateChanged
        editorController.setBrakeForce((Float) brakeForceSpinner.getValue());
    }//GEN-LAST:event_brakeForceSpinnerStateChanged
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSpinner axisSpinner;
    private javax.swing.JRadioButton boundingRadioButton;
    private javax.swing.JSpinner boundingSpinner;
    private javax.swing.JSpinner brakeForceSpinner;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JSlider compressionSlider;
    private javax.swing.JCheckBox createNodeCheckBox;
    private javax.swing.JRadioButton fixedRadioButton;
    private javax.swing.JSpinner fixedSpinner;
    private javax.swing.JSpinner forceSpinner;
    private javax.swing.JSpinner frictionSpinner;
    private javax.swing.JCheckBox frontCheckBox;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JButton jButton7;
    private javax.swing.JButton jButton8;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator3;
    private javax.swing.JToolBar.Separator jSeparator4;
    private javax.swing.JToolBar.Separator jSeparator6;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JToolBar jToolBar10;
    private javax.swing.JToolBar jToolBar11;
    private javax.swing.JToolBar jToolBar13;
    private javax.swing.JToolBar jToolBar14;
    private javax.swing.JToolBar jToolBar15;
    private javax.swing.JToolBar jToolBar16;
    private javax.swing.JToolBar jToolBar2;
    private javax.swing.JToolBar jToolBar3;
    private javax.swing.JToolBar jToolBar4;
    private javax.swing.JToolBar jToolBar5;
    private javax.swing.JToolBar jToolBar6;
    private javax.swing.JToolBar jToolBar7;
    private javax.swing.JToolBar jToolBar9;
    private javax.swing.JSpinner motorForceSpinner;
    private javax.swing.JSlider releaseSlider;
    private javax.swing.JSpinner restSpinner;
    private javax.swing.JSlider rollSlider;
    private javax.swing.JSlider stiffnessSlider;
    // End of variables declaration//GEN-END:variables

    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link #findInstance}.
     */
    public static synchronized VehicleCreatorTopComponent getDefault() {
        if (instance == null) {
            instance = new VehicleCreatorTopComponent();
        }
        return instance;
    }

    /**
     * Obtain the VehicleCreatorTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized VehicleCreatorTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(VehicleCreatorTopComponent.class.getName()).warning(
                    "Cannot find " + PREFERRED_ID + " component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof VehicleCreatorTopComponent) {
            return (VehicleCreatorTopComponent) win;
        }
        Logger.getLogger(VehicleCreatorTopComponent.class.getName()).warning(
                "There seem to be multiple components with the '" + PREFERRED_ID
                + "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }

    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }

    @Override
    public void componentOpened() {
        if (currentRequest == null) {
            close();
        }
    }

    @Override
    public void componentClosed() {
        if (currentRequest != null) {
            SceneApplication.getApplication().closeScene(currentRequest);
        }
    }

    @Override
    protected void componentActivated() {
        SceneViewerTopComponent.findInstance().requestVisible();
    }
    
    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    Object readProperties(java.util.Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }

    @Override
    protected String preferredID() {
        return PREFERRED_ID;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return ctx;
    }


    private SuspensionSettings getSuspensionSettings() {
        SuspensionSettings settings = new SuspensionSettings();
        settings.setFriction((Float) frictionSpinner.getValue());
        settings.setMaxForce((Float) forceSpinner.getValue());
        settings.setRestLength((Float) restSpinner.getValue());
        if (boundingRadioButton.isSelected()) {
            settings.setBoundingScale((Float) boundingSpinner.getValue());
        } else {
            settings.setBoundingScale(0);
            settings.setRadius((Float) fixedSpinner.getValue());
        }
        float stiffness = stiffnessSlider.getValue();
        float compValue = (float) compressionSlider.getValue() / 100.0f;
        float dampValue = (float) releaseSlider.getValue() / 100.0f;
        settings.setCompression(compValue * 2.0f * FastMath.sqrt(stiffness));
        settings.setRelease(dampValue * 2.0f * FastMath.sqrt(stiffness));
        settings.setStiffness(stiffness);
        settings.setFrontWheel(frontCheckBox.isSelected());
        if ("-Z".equals(axisSpinner.getValue())) {
            settings.setAxle(new Vector3f(1, 0, 0));
        } else if ("X".equals(axisSpinner.getValue())) {
            settings.setAxle(new Vector3f(0, 0, 1));
        } else if ("-X".equals(axisSpinner.getValue())) {
            settings.setAxle(new Vector3f(0, 0, -1));
        }
        settings.setCreateNode(createNodeCheckBox.isSelected());
        return settings;
    }

    public void openFile(BinaryModelDataObject file, Node spatial) {
        JmeNode node = NodeUtility.createNode(spatial, false);
        editorController = new VehicleEditorController(node, file);
        SceneApplication.getApplication().addSceneListener(this);
        currentRequest = new SceneRequest(this, node, file.getLookup().lookup(ProjectAssetManager.class));
        currentRequest.setWindowTitle("Vehicle Creator");
        currentRequest.setDataObject(file);
        currentRequest.setToolNode(editorController.getToolsNode());
        currentRequest.setHelpCtx(ctx);
        SceneApplication.getApplication().requestScene(currentRequest);
    }

    public void previewRequested(PreviewRequest request) {
    }

    public boolean sceneClose(SceneRequest request) {
        if (request == currentRequest) {
            SceneApplication.getApplication().removeSceneListener(this);
            currentRequest.getRootNode().getParent().removeLight(dirLight);
            editorController.cleanupApplication();
            SceneApplication.getApplication().getStateManager().detach(editorController.getBulletState());
            setLoadedScene(null, false);
            currentRequest = null;
        }
        return true;
    }

    public void sceneRequested(SceneRequest request) {
        if (request == currentRequest) {
            editorController.prepareApplication();
            SceneApplication.getApplication().getStateManager().attach(editorController.getBulletState());
            setLoadedScene(currentRequest.getJmeNode(), true);
            currentRequest.getRootNode().getParent().addLight(dirLight);
        }
    }

    private void setLoadedScene(final org.openide.nodes.Node jmeNode, final boolean active) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                if (!active) {
                    close();
                    setActivatedNodes(new org.openide.nodes.Node[]{});
                    if (editorController != null) {
                        editorController.cleanup();
                        editorController = null;
                    }
                } else {
                    if (!isOpened()) {
                        open();
                    }
                    requestActive();
//                    setActivatedNodes(new org.openide.nodes.Node[]{jmeNode});
                    editorController.checkVehicle();
                }
            }
        });
    }
}
