/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.CollisionShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import java.io.IOException;

public class RigidBodyControl
extends PhysicsRigidBody
implements PhysicsControl {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected boolean added = false;
    protected PhysicsSpace space = null;
    protected boolean kinematicSpatial = true;

    public RigidBodyControl() {
    }

    public RigidBodyControl(float f) {
        this.mass = f;
    }

    public RigidBodyControl(CollisionShape collisionShape) {
        super(collisionShape);
    }

    public RigidBodyControl(CollisionShape collisionShape, float f) {
        super(collisionShape, f);
    }

    public Control cloneForSpatial(Spatial spatial) {
        RigidBodyControl rigidBodyControl = new RigidBodyControl(this.collisionShape, this.mass);
        rigidBodyControl.setAngularFactor(this.getAngularFactor());
        rigidBodyControl.setAngularSleepingThreshold(this.getAngularSleepingThreshold());
        rigidBodyControl.setCcdMotionThreshold(this.getCcdMotionThreshold());
        rigidBodyControl.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        rigidBodyControl.setCollideWithGroups(this.getCollideWithGroups());
        rigidBodyControl.setCollisionGroup(this.getCollisionGroup());
        rigidBodyControl.setDamping(this.getLinearDamping(), this.getAngularDamping());
        rigidBodyControl.setFriction(this.getFriction());
        rigidBodyControl.setGravity(this.getGravity());
        rigidBodyControl.setKinematic(this.isKinematic());
        rigidBodyControl.setKinematicSpatial(this.isKinematicSpatial());
        rigidBodyControl.setLinearSleepingThreshold(this.getLinearSleepingThreshold());
        rigidBodyControl.setPhysicsLocation(this.getPhysicsLocation(null));
        rigidBodyControl.setPhysicsRotation(this.getPhysicsRotationMatrix(null));
        rigidBodyControl.setRestitution(this.getRestitution());
        if (this.mass > 0.0f) {
            rigidBodyControl.setAngularVelocity(this.getAngularVelocity());
            rigidBodyControl.setLinearVelocity(this.getLinearVelocity());
        }
        rigidBodyControl.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        rigidBodyControl.setSpatial(spatial);
        return rigidBodyControl;
    }

    public void setSpatial(Spatial spatial) {
        if (this.getUserObject() == null || this.getUserObject() == this.spatial) {
            this.setUserObject(spatial);
        }
        this.spatial = spatial;
        if (spatial == null) {
            if (this.getUserObject() == spatial) {
                this.setUserObject(null);
            }
            spatial = null;
            this.collisionShape = null;
            return;
        }
        if (this.collisionShape == null) {
            this.createCollisionShape();
            this.rebuildRigidBody();
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    protected void createCollisionShape() {
        if (this.spatial == null) {
            return;
        }
        if (this.spatial instanceof Geometry) {
            Geometry geometry = (Geometry)this.spatial;
            Mesh mesh = geometry.getMesh();
            if (mesh instanceof Sphere) {
                this.collisionShape = new SphereCollisionShape(((Sphere)mesh).getRadius());
                return;
            }
            if (mesh instanceof Box) {
                this.collisionShape = new BoxCollisionShape(new Vector3f(((Box)mesh).getXExtent(), ((Box)mesh).getYExtent(), ((Box)mesh).getZExtent()));
                return;
            }
        }
        this.collisionShape = this.mass > 0.0f ? CollisionShapeFactory.createDynamicMeshShape(this.spatial) : CollisionShapeFactory.createMeshShape(this.spatial);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.space != null) {
            if (bl && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!bl && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isKinematicSpatial() {
        return this.kinematicSpatial;
    }

    public void setKinematicSpatial(boolean bl) {
        this.kinematicSpatial = bl;
    }

    public boolean isApplyPhysicsLocal() {
        return this.motionState.isApplyPhysicsLocal();
    }

    public void setApplyPhysicsLocal(boolean bl) {
        this.motionState.setApplyPhysicsLocal(bl);
    }

    private Vector3f getSpatialTranslation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    private Quaternion getSpatialRotation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    public void update(float f) {
        if (this.enabled && this.spatial != null) {
            if (this.isKinematic() && this.kinematicSpatial) {
                super.setPhysicsLocation(this.getSpatialTranslation());
                super.setPhysicsRotation(this.getSpatialRotation());
            } else {
                this.getMotionState().applyTransform(this.spatial);
            }
        }
    }

    public void render(RenderManager renderManager, ViewPort viewPort) {
        if (this.enabled && this.space != null && this.space.getDebugManager() != null) {
            if (this.debugShape == null) {
                this.attachDebugShape(this.space.getDebugManager());
            }
            this.debugShape.setLocalTranslation(this.spatial.getWorldTranslation());
            this.debugShape.setLocalRotation(this.spatial.getWorldRotation());
            this.debugShape.updateLogicalState(0.0f);
            this.debugShape.updateGeometricState();
            renderManager.renderScene(this.debugShape, viewPort);
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace physicsSpace) {
        if (physicsSpace == null) {
            if (this.space != null) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        } else {
            if (this.space == physicsSpace) {
                return;
            }
            physicsSpace.addCollisionObject(this);
            this.added = true;
        }
        this.space = physicsSpace;
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.enabled, "enabled", true);
        outputCapsule.write(this.motionState.isApplyPhysicsLocal(), "applyLocalPhysics", false);
        outputCapsule.write(this.kinematicSpatial, "kinematicSpatial", true);
        outputCapsule.write((Savable)this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.enabled = inputCapsule.readBoolean("enabled", true);
        this.kinematicSpatial = inputCapsule.readBoolean("kinematicSpatial", true);
        this.spatial = (Spatial)inputCapsule.readSavable("spatial", null);
        this.motionState.setApplyPhysicsLocal(inputCapsule.readBoolean("applyLocalPhysics", false));
        this.setUserObject(this.spatial);
    }
}

