/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont.impl;

import java.io.IOException;
import java.util.Map;
import org.jglfont.BitmapFont;
import org.jglfont.BitmapFontException;
import org.jglfont.impl.format.BitmapFontCharacterInfo;
import org.jglfont.impl.format.BitmapFontData;
import org.jglfont.spi.BitmapFontRenderer;
import org.jglfont.spi.ResourceLoader;

public class BitmapFontImpl
implements BitmapFont {
    private final BitmapFontRenderer fontRenderer;
    private final ResourceLoader resourceLoader;
    private final BitmapFontData fontData;

    public BitmapFontImpl(BitmapFontRenderer fontRenderer, ResourceLoader resourceLoader, BitmapFontData fontData, String filename) {
        this.fontRenderer = fontRenderer;
        this.resourceLoader = resourceLoader;
        this.fontData = fontData;
        this.initalize(this.extractPath(filename));
    }

    @Override
    public void renderText(int x, int y, String text) {
        this.renderText(x, y, text, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void renderText(int x, int y, String text, float sizeX, float sizeY, float r, float g, float b, float a) {
        if (text.length() == 0) {
            return;
        }
        int xPos = x;
        int yPos = y;
        this.fontRenderer.beforeRender();
        for (int i = 0; i < text.length() && (i = this.fontRenderer.preProcess(text, i)) < text.length(); ++i) {
            char currentCharacter = text.charAt(i);
            char nextCharacter = this.getNextCharacter(text, i);
            BitmapFontCharacterInfo characterInfo = this.fontData.getCharacters().get(Character.valueOf(currentCharacter));
            if (characterInfo == null) continue;
            this.fontRenderer.render(characterInfo.getPage(), xPos, yPos, currentCharacter, sizeX, sizeY, r, g, b, a);
            xPos = (int)((float)xPos + (float)this.getCharacterWidth(currentCharacter, nextCharacter, sizeX));
        }
        this.fontRenderer.afterRender();
    }

    @Override
    public int getCharacterWidth(char currentCharacter, char nextCharacter) {
        return this.getCharacterWidth(currentCharacter, nextCharacter, 1.0f);
    }

    @Override
    public int getCharacterWidth(char currentCharacter, char nextCharacter, float size) {
        BitmapFontCharacterInfo currentCharacterInfo = this.fontData.getCharacters().get(Character.valueOf(currentCharacter));
        if (currentCharacterInfo == null) {
            return 0;
        }
        return (int)((float)(currentCharacterInfo.getXadvance() + this.getKerning(currentCharacterInfo, nextCharacter)) * size);
    }

    @Override
    public int getStringWidth(String text) {
        return this.getStringWidth(text, 1.0f);
    }

    @Override
    public int getStringWidth(String text, float size) {
        int length = 0;
        for (int i = 0; i < text.length() && (i = this.fontRenderer.preProcessForLength(text, i)) < text.length(); ++i) {
            char nextCharacter;
            char currentCharacter = text.charAt(i);
            int w = this.getCharacterWidth(currentCharacter, nextCharacter = this.getNextCharacter(text, i), size);
            if (w == -1) continue;
            length += w;
        }
        return length;
    }

    @Override
    public int getHeight() {
        return this.fontData.getLineHeight();
    }

    private void initalize(String path) {
        for (Map.Entry<Integer, String> entry : this.fontData.getBitmaps().entrySet()) {
            try {
                String filename = path + entry.getValue();
                this.fontRenderer.registerBitmap(this.bitmapKey(entry.getKey()), this.resourceLoader.load(filename), filename);
            }
            catch (IOException e) {
                throw new BitmapFontException(e);
            }
        }
        this.initGlyphs();
        this.fontRenderer.prepare();
    }

    private String extractPath(String filename) {
        int idx = filename.lastIndexOf("/");
        if (idx == -1) {
            return "";
        }
        return filename.substring(0, idx) + "/";
    }

    private void initGlyphs() {
        for (Map.Entry<Character, BitmapFontCharacterInfo> entry : this.fontData.getCharacters().entrySet()) {
            Character c = entry.getKey();
            BitmapFontCharacterInfo charInfo = entry.getValue();
            if (charInfo == null) continue;
            this.fontRenderer.registerGlyph(charInfo.getPage(), c.charValue(), charInfo.getXoffset(), charInfo.getYoffset(), charInfo.getWidth(), charInfo.getHeight(), (float)charInfo.getX() / (float)this.fontData.getBitmapWidth(), (float)charInfo.getY() / (float)this.fontData.getBitmapHeight(), (float)(charInfo.getX() + charInfo.getWidth()) / (float)this.fontData.getBitmapWidth(), (float)(charInfo.getY() + charInfo.getHeight()) / (float)this.fontData.getBitmapHeight());
        }
    }

    private char getNextCharacter(String text, int currentIndex) {
        char nextChar = '\u0000';
        if (currentIndex < text.length() - 1) {
            nextChar = text.charAt(currentIndex + 1);
        }
        return nextChar;
    }

    private int getKerning(BitmapFontCharacterInfo currentCharacterInfo, char nextCharacter) {
        Integer kern = currentCharacterInfo.getKerning().get(Character.valueOf(nextCharacter));
        if (kern != null) {
            return kern;
        }
        return 0;
    }

    private String bitmapKey(int key) {
        return this.fontData.getName() + "-" + key;
    }
}

