/*
 * Decompiled with CFR 0.152.
 */
package org.jglfont;

import java.io.IOException;
import java.io.InputStream;
import org.jglfont.BitmapFont;
import org.jglfont.impl.BitmapFontImpl;
import org.jglfont.impl.ClasspathResourceLoader;
import org.jglfont.impl.format.BitmapFontLoader;
import org.jglfont.impl.format.angelcode.AngelCodeBitmapFontLoader;
import org.jglfont.impl.format.angelcode.AngelCodeLineProcessors;
import org.jglfont.spi.BitmapFontRenderer;
import org.jglfont.spi.ResourceLoader;

public class BitmapFontFactory {
    private final BitmapFontRenderer fontRenderer;
    private final ResourceLoader resourceLoader;
    private final BitmapFontLoader fontLoader;

    public BitmapFontFactory(BitmapFontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
        this.resourceLoader = new ClasspathResourceLoader();
        this.fontLoader = new AngelCodeBitmapFontLoader(new AngelCodeLineProcessors());
    }

    public BitmapFontFactory(BitmapFontRenderer fontRenderer, ResourceLoader resourceLoader) {
        this.fontRenderer = fontRenderer;
        this.resourceLoader = resourceLoader;
        this.fontLoader = new AngelCodeBitmapFontLoader(new AngelCodeLineProcessors());
    }

    public BitmapFont loadFont(InputStream stream, String filename) throws IOException {
        return new BitmapFontImpl(this.fontRenderer, this.resourceLoader, this.fontLoader.load(stream), filename);
    }
}

