/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.window;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Window;
import de.lessvoid.nifty.controls.WindowClosedEvent;
import de.lessvoid.nifty.controls.dragndrop.DraggableControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class WindowControl
extends AbstractController
implements Window {
    private DraggableControl draggableControl = new DraggableControl();
    private Nifty nifty;
    private boolean removeCloseButton;
    private boolean hideOnClose;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(element);
        this.nifty = nifty;
        this.draggableControl.bind(nifty, screen, element, parameter, controlDefinitionAttributes);
        this.removeCloseButton = !controlDefinitionAttributes.getAsBoolean("closeable", true);
        this.hideOnClose = controlDefinitionAttributes.getAsBoolean("hideOnClose", false);
    }

    public void onStartScreen() {
        this.draggableControl.onStartScreen();
        if (this.removeCloseButton) {
            this.getCloseButton().markForRemoval();
            this.removeCloseButton = false;
        }
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return this.draggableControl.inputEvent(inputEvent);
    }

    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
        this.draggableControl.onFocus(getFocus);
    }

    public void dragStart(int mouseX, int mouseY) {
        this.draggableControl.dragStart(mouseX, mouseY);
    }

    public void drag(int mouseX, int mouseY) {
        this.draggableControl.drag(mouseX, mouseY);
    }

    public void dragStop() {
        this.draggableControl.dragStop();
    }

    private Element getTitleElement() {
        return this.getElement().findElementByName("#window-title");
    }

    private Element getCloseButton() {
        return this.getElement().findElementByName("#window-close-button");
    }

    public Element getContent() {
        return this.getElement().findElementByName("#window-content");
    }

    @Override
    public String getTitle() {
        return ((TextRenderer)this.getTitleElement().getRenderer(TextRenderer.class)).getOriginalText();
    }

    @Override
    public void setTitle(String title) {
        ((TextRenderer)this.getTitleElement().getRenderer(TextRenderer.class)).setText(title);
    }

    @Override
    public void closeWindow() {
        if (this.hideOnClose) {
            this.getElement().hide((EndNotify)new CloseEndNotify(this.nifty, true));
        } else {
            this.getElement().markForRemoval((EndNotify)new CloseEndNotify(this.nifty, false));
        }
    }

    private class CloseEndNotify
    implements EndNotify {
        private final Nifty nifty;
        private final boolean hidden;

        public CloseEndNotify(Nifty nifty, boolean hidden) {
            this.nifty = nifty;
            this.hidden = hidden;
        }

        public void perform() {
            this.nifty.publishEvent(WindowControl.this.getElement().getId(), (NiftyEvent)new WindowClosedEvent(WindowControl.this, this.hidden));
        }
    }
}

