/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.textfield;

import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;

public class TextFieldInputMapping
implements NiftyInputMapping {
    public NiftyInputEvent convert(KeyboardInputEvent inputEvent) {
        if (inputEvent.isKeyDown()) {
            return TextFieldInputMapping.handleKeyDownEvent(inputEvent);
        }
        return TextFieldInputMapping.handleKeyUpEvent(inputEvent);
    }

    private static NiftyInputEvent handleKeyDownEvent(KeyboardInputEvent inputEvent) {
        switch (inputEvent.getKey()) {
            case 200: {
                return NiftyInputEvent.MoveCursorUp;
            }
            case 208: {
                return NiftyInputEvent.MoveCursorDown;
            }
            case 203: {
                return NiftyInputEvent.MoveCursorLeft;
            }
            case 205: {
                return NiftyInputEvent.MoveCursorRight;
            }
            case 59: {
                return NiftyInputEvent.ConsoleToggle;
            }
            case 28: {
                return NiftyInputEvent.SubmitText;
            }
            case 211: {
                return NiftyInputEvent.Delete;
            }
            case 14: {
                return NiftyInputEvent.Backspace;
            }
            case 207: {
                return NiftyInputEvent.MoveCursorToLastPosition;
            }
            case 199: {
                return NiftyInputEvent.MoveCursorToFirstPosition;
            }
            case 42: 
            case 54: {
                return NiftyInputEvent.SelectionStart;
            }
            case 15: {
                return inputEvent.isShiftDown() ? NiftyInputEvent.PrevInputElement : NiftyInputEvent.NextInputElement;
            }
            case 45: {
                if (!inputEvent.isControlDown()) break;
                return NiftyInputEvent.Cut;
            }
            case 46: {
                if (!inputEvent.isControlDown()) break;
                return NiftyInputEvent.Copy;
            }
            case 47: {
                if (!inputEvent.isControlDown()) break;
                return NiftyInputEvent.Paste;
            }
            case 30: {
                if (!inputEvent.isControlDown()) break;
                return NiftyInputEvent.SelectAll;
            }
        }
        if (!Character.isISOControl(inputEvent.getCharacter())) {
            NiftyInputEvent character = NiftyInputEvent.Character;
            character.setCharacter(inputEvent.getCharacter());
            return character;
        }
        return null;
    }

    private static NiftyInputEvent handleKeyUpEvent(KeyboardInputEvent inputEvent) {
        switch (inputEvent.getKey()) {
            case 42: 
            case 54: {
                return NiftyInputEvent.SelectionEnd;
            }
            case 1: {
                return NiftyInputEvent.Escape;
            }
        }
        return null;
    }
}

