/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.checkbox;

import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.checkbox.CheckBoxView;
import de.lessvoid.nifty.controls.checkbox.CheckBoxViewNull;
import de.lessvoid.nifty.controls.shared.EmptyNiftyControlImpl;

public class CheckBoxImpl
extends EmptyNiftyControlImpl
implements CheckBox {
    private CheckBox checkbox;
    private boolean checked;
    private CheckBoxView view = new CheckBoxViewNull();

    public CheckBoxImpl(CheckBox checkbox) {
        this.checkbox = checkbox;
    }

    public void bindToView(CheckBoxView checkBoxView) {
        this.view = checkBoxView;
    }

    @Override
    public void check() {
        this.internalSetChecked(true);
    }

    @Override
    public void uncheck() {
        this.internalSetChecked(false);
    }

    @Override
    public void setChecked(boolean state) {
        this.internalSetChecked(state);
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    private void internalSetChecked(boolean newState) {
        if (this.checked == newState) {
            return;
        }
        this.checked = newState;
        this.updateView();
    }

    private void updateView() {
        this.view.update(this.checked);
        this.view.publish(new CheckBoxStateChangedEvent(this.checkbox, this.checked));
    }
}

