/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.helloniftybuilder;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.HoverEffectBuilder;
import de.lessvoid.nifty.builder.ImageBuilder;
import de.lessvoid.nifty.builder.LayerBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.builder.ScreenBuilder;
import de.lessvoid.nifty.builder.TextBuilder;
import de.lessvoid.nifty.examples.LwjglInitHelper;
import de.lessvoid.nifty.renderer.lwjgl.render.LwjglRenderDevice;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.sound.openal.OpenALSoundDevice;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.sound.SoundDevice;
import de.lessvoid.nifty.tools.TimeProvider;

public class HelloNiftyBuilderExampleMain
implements ScreenController {
    private Nifty nifty;

    public static void main(String[] args) {
        if (!LwjglInitHelper.initSubSystems("Hello Nifty Builder World")) {
            System.exit(0);
        }
        Nifty nifty = new Nifty((RenderDevice)new LwjglRenderDevice(), (SoundDevice)new OpenALSoundDevice(), (InputSystem)LwjglInitHelper.getInputSystem(), new TimeProvider());
        Screen screen = new ScreenBuilder("start"){
            {
                this.controller(new HelloNiftyBuilderExampleMain());
                this.layer(new LayerBuilder("layer"){
                    {
                        this.backgroundColor("#003f");
                        this.childLayoutCenter();
                        this.panel(new PanelBuilder(){
                            {
                                this.id("panel");
                                this.childLayoutCenter();
                                this.height("25%");
                                this.width("80%");
                                this.alignCenter();
                                this.valignCenter();
                                this.backgroundColor("#f60f");
                                this.visibleToMouse();
                                this.interactOnClick("quit()");
                                this.padding("10px");
                                this.onStartScreenEffect(new EffectBuilder("move"){
                                    {
                                        this.effectParameter("mode", "in");
                                        this.effectParameter("direction", "top");
                                        this.length(300);
                                        this.startDelay(0);
                                        this.inherit(true);
                                    }
                                });
                                this.onEndScreenEffect(new EffectBuilder("move"){
                                    {
                                        this.effectParameter("mode", "out");
                                        this.effectParameter("direction", "bottom");
                                        this.length(300);
                                        this.startDelay(0);
                                        this.inherit(true);
                                    }
                                });
                                this.onHoverEffect(new HoverEffectBuilder("pulsate"){
                                    {
                                        this.effectParameter("scaleFactor", "0.008");
                                        this.effectParameter("startColor", "#f600");
                                        this.effectParameter("endColor", "#ffff");
                                        this.post(true);
                                    }
                                });
                                this.panel(new PanelBuilder(){
                                    {
                                        this.childLayoutHorizontal();
                                        this.alignCenter();
                                        this.valignCenter();
                                        this.width("100%");
                                        this.image(new ImageBuilder(){
                                            {
                                                this.filename("nifty-logo-150x150.png");
                                            }
                                        });
                                        this.text(new TextBuilder(){
                                            {
                                                this.text("Hello Nifty Builder World!!!");
                                                this.font("aurulent-sans-17.fnt");
                                                this.color("#000f");
                                                this.width("*");
                                                this.alignCenter();
                                                this.valignCenter();
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }.build(nifty);
        nifty.addScreen("start", screen);
        nifty.gotoScreen("start");
        LwjglInitHelper.renderLoop(nifty, null);
        LwjglInitHelper.destroy();
    }

    public void bind(Nifty nifty, Screen screen) {
        System.out.println("bind()");
        this.nifty = nifty;
    }

    public void onStartScreen() {
        System.out.println("onStartScreen()");
    }

    public void onEndScreen() {
        System.out.println("onEndScreen()");
    }

    public void quit() {
        this.nifty.exit();
    }
}

