/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class BranchTargetFinder
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    public static final int NONE = -2;
    public static final int AT_METHOD_ENTRY = -1;
    private static final short INSTRUCTION = 1;
    private static final short BRANCH_ORIGIN = 2;
    private static final short BRANCH_TARGET = 4;
    private static final short AFTER_BRANCH = 8;
    private static final short EXCEPTION_START = 16;
    private static final short EXCEPTION_END = 32;
    private static final short EXCEPTION_HANDLER = 64;
    private static final short SUBROUTINE_INVOCATION = 128;
    private static final short SUBROUTINE_RETURNING = 256;
    private static final int MAXIMUM_CREATION_OFFSETS = 32;
    private short[] instructionMarks = new short[1025];
    private int[] subroutineStarts = new int[1024];
    private int[] subroutineEnds = new int[1024];
    private int[] creationOffsets = new int[1024];
    private int[] initializationOffsets = new int[1024];
    private int superInitializationOffset;
    private int currentSubroutineStart;
    private int currentSubroutineEnd;
    private int[] recentCreationOffsets = new int[32];
    private int recentCreationOffsetIndex;
    private boolean isInitializer;

    public boolean isInstruction(int n) {
        return (this.instructionMarks[n] & 1) != 0;
    }

    public boolean isTarget(int n) {
        return n == 0 || (this.instructionMarks[n] & 0x74) != 0;
    }

    public boolean isBranchOrigin(int n) {
        return (this.instructionMarks[n] & 2) != 0;
    }

    public boolean isBranchTarget(int n) {
        return (this.instructionMarks[n] & 4) != 0;
    }

    public boolean isAfterBranch(int n) {
        return (this.instructionMarks[n] & 8) != 0;
    }

    public boolean isExceptionStart(int n) {
        return (this.instructionMarks[n] & 0x10) != 0;
    }

    public boolean isExceptionEnd(int n) {
        return (this.instructionMarks[n] & 0x20) != 0;
    }

    public boolean isExceptionHandler(int n) {
        return (this.instructionMarks[n] & 0x40) != 0;
    }

    public boolean isSubroutineInvocation(int n) {
        return (this.instructionMarks[n] & 0x80) != 0;
    }

    public boolean isSubroutineStart(int n) {
        return this.subroutineStarts[n] == n;
    }

    public boolean isSubroutine(int n) {
        return this.subroutineStarts[n] != -2;
    }

    public boolean isSubroutineReturning(int n) {
        return (this.instructionMarks[n] & 0x100) != 0;
    }

    public int subroutineStart(int n) {
        return this.subroutineStarts[n];
    }

    public int subroutineEnd(int n) {
        return this.subroutineEnds[n];
    }

    public boolean isNew(int n) {
        return this.initializationOffsets[n] != -2;
    }

    public int initializationOffset(int n) {
        return this.initializationOffsets[n];
    }

    public boolean isInitializer() {
        return this.superInitializationOffset != -2;
    }

    public int superInitializationOffset() {
        return this.superInitializationOffset;
    }

    public boolean isInitializer(int n) {
        return this.creationOffsets[n] != -2;
    }

    public int creationOffset(int n) {
        return this.creationOffsets[n];
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int n;
        int n2 = codeAttribute.u4codeLength;
        if (this.subroutineStarts.length < n2) {
            this.instructionMarks = new short[n2 + 1];
            this.subroutineStarts = new int[n2];
            this.subroutineEnds = new int[n2];
            this.creationOffsets = new int[n2];
            this.initializationOffsets = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.subroutineStarts[n] = -2;
                this.subroutineEnds[n] = -2;
                this.creationOffsets[n] = -2;
                this.initializationOffsets[n] = -2;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.instructionMarks[n] = 0;
                this.subroutineStarts[n] = -2;
                this.subroutineEnds[n] = -2;
                this.creationOffsets[n] = -2;
                this.initializationOffsets[n] = -2;
            }
            this.instructionMarks[n2] = 0;
        }
        this.superInitializationOffset = -2;
        this.currentSubroutineStart = -2;
        this.currentSubroutineEnd = -2;
        this.recentCreationOffsetIndex = 0;
        if (method.getName(clazz).equals("<init>")) {
            this.recentCreationOffsets[this.recentCreationOffsetIndex++] = -1;
        }
        this.instructionMarks[n2] = 4;
        codeAttribute.instructionsAccept(clazz, method, this);
        codeAttribute.exceptionsAccept(clazz, method, this);
        n = -2;
        int n3 = n2;
        boolean bl = false;
        for (int i = n2 - 1; i >= 0; --i) {
            if (!this.isInstruction(i)) continue;
            if (this.subroutineStarts[i] != -2) {
                n = this.subroutineStarts[i];
            } else if (n != -2) {
                this.subroutineStarts[i] = n;
            }
            if (this.isSubroutineStart(i)) {
                n = -2;
            }
            if (this.isSubroutine(i)) {
                this.subroutineEnds[i] = n3;
                if (this.isSubroutineReturning(i)) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                int n4 = i;
                this.instructionMarks[n4] = (short)(this.instructionMarks[n4] | 0x100);
                continue;
            }
            n3 = i;
            bl = false;
        }
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 1);
        this.checkSubroutine(n);
        byte by = simpleInstruction.opcode;
        if (by == -84 || by == -83 || by == -82 || by == -81 || by == -80 || by == -65) {
            this.markBranchOrigin(n);
            this.markAfterBranchOrigin(n + simpleInstruction.length(n));
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 1);
        this.checkSubroutine(n);
        if (constantInstruction.opcode == -69) {
            this.recentCreationOffsets[this.recentCreationOffsetIndex++] = n;
        } else {
            this.isInitializer = false;
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            if (this.isInitializer) {
                int n3;
                this.creationOffsets[n] = n3 = this.recentCreationOffsets[--this.recentCreationOffsetIndex];
                if (n3 == -1) {
                    this.superInitializationOffset = n;
                } else {
                    this.initializationOffsets[n3] = n;
                }
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 1);
        this.checkSubroutine(n);
        if (variableInstruction.opcode == -87) {
            this.markBranchOrigin(n);
            int n3 = n;
            this.instructionMarks[n3] = (short)(this.instructionMarks[n3] | 0x100);
            this.markAfterBranchOrigin(n + variableInstruction.length(n));
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        this.markBranchOrigin(n);
        this.checkSubroutine(n);
        this.markBranchTarget(n, branchInstruction.branchOffset);
        byte by = branchInstruction.opcode;
        if (by == -88 || by == -55) {
            int n2;
            int n3 = n;
            this.instructionMarks[n3] = (short)(this.instructionMarks[n3] | 0x80);
            this.subroutineStarts[n2] = n2 = n + branchInstruction.branchOffset;
        } else if (by == -89 || by == -56) {
            this.markAfterBranchOrigin(n + branchInstruction.length(n));
        }
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
        this.markBranchOrigin(n);
        this.checkSubroutine(n);
        this.markBranchTarget(n, switchInstruction.defaultOffset);
        this.markBranchTargets(n, switchInstruction.jumpOffsets);
        this.markAfterBranchOrigin(n + switchInstruction.length(n));
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.isInitializer = methodrefConstant.getName(clazz).equals("<init>");
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int n = exceptionInfo.u2startPC;
        this.instructionMarks[n] = (short)(this.instructionMarks[n] | 0x10);
        int n2 = exceptionInfo.u2endPC;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 0x20);
        int n3 = exceptionInfo.u2handlerPC;
        this.instructionMarks[n3] = (short)(this.instructionMarks[n3] | 0x40);
    }

    private void markBranchTargets(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.markBranchTarget(n, nArray[i]);
        }
    }

    private void markBranchOrigin(int n) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 3);
    }

    private void markBranchTarget(int n, int n2) {
        int n3;
        int n4 = n3 = n + n2;
        this.instructionMarks[n4] = (short)(this.instructionMarks[n4] | 4);
        if (this.isSubroutine(n)) {
            this.subroutineStarts[n3] = this.currentSubroutineStart;
            if (this.currentSubroutineEnd < n3) {
                this.currentSubroutineEnd = n3;
            }
        }
    }

    private void markAfterBranchOrigin(int n) {
        int n2 = n;
        this.instructionMarks[n2] = (short)(this.instructionMarks[n2] | 8);
        if (this.currentSubroutineEnd <= n) {
            this.currentSubroutineStart = -2;
        }
    }

    private void checkSubroutine(int n) {
        if (this.isSubroutine(n)) {
            this.currentSubroutineStart = this.subroutineStarts[n];
        } else {
            this.subroutineStarts[n] = this.currentSubroutineStart;
        }
    }
}

