/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.NonEmptyAttributeFilter;
import proguard.classfile.attribute.visitor.RequiredAttributeFilter;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.BridgeMethodFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.InnerClassesAccessFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.obfuscate.AttributeShrinker;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.ClassRenamer;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.MapCleaner;
import proguard.obfuscate.MappingKeeper;
import proguard.obfuscate.MappingPrinter;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.obfuscate.MemberNameCollector;
import proguard.obfuscate.MemberNameConflictFixer;
import proguard.obfuscate.MemberNameFilter;
import proguard.obfuscate.MemberObfuscator;
import proguard.obfuscate.MemberSpecialNameFilter;
import proguard.obfuscate.MultiMappingProcessor;
import proguard.obfuscate.NameAndTypeShrinker;
import proguard.obfuscate.NameAndTypeUsageMarker;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NameMarker;
import proguard.obfuscate.ParameterNameMarker;
import proguard.obfuscate.SimpleNameFactory;
import proguard.obfuscate.SourceFileRenamer;
import proguard.obfuscate.SpecialNameFactory;
import proguard.obfuscate.Utf8Shrinker;
import proguard.obfuscate.Utf8UsageMarker;
import proguard.util.ListParser;
import proguard.util.NameParser;

public class Obfuscator {
    private final Configuration configuration;

    public Obfuscator(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the obfuscation step.");
        }
        classPool.classesAccept(new ClassCleaner());
        classPool2.classesAccept(new ClassCleaner());
        ClassVisitor classVisitor = this.configuration.useUniqueClassMemberNames ? new AllMemberVisitor(new MethodLinker()) : new BottomClassFilter(new MethodLinker());
        classPool.classesAccept(classVisitor);
        classPool2.classesAccept(classVisitor);
        NameMarker nameMarker = new NameMarker();
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, nameMarker, nameMarker, false, false, true);
        classPool.accept(classPoolVisitor);
        classPool2.accept(classPoolVisitor);
        classPool2.classesAccept(nameMarker);
        classPool2.classesAccept(new AllMemberVisitor(nameMarker));
        NonEmptyAttributeFilter nonEmptyAttributeFilter = new NonEmptyAttributeFilter(new AttributeUsageMarker());
        AttributeNameFilter attributeNameFilter = this.configuration.keepAttributes == null ? null : new AttributeNameFilter(new ListParser(new NameParser()).parse(this.configuration.keepAttributes), nonEmptyAttributeFilter);
        classPool.classesAccept(new AllAttributeVisitor(true, new RequiredAttributeFilter(nonEmptyAttributeFilter, attributeNameFilter)));
        if (this.configuration.keepParameterNames) {
            classPool.classesAccept(new AllMethodVisitor(new MemberNameFilter(new AllAttributeVisitor(true, new ParameterNameMarker(nonEmptyAttributeFilter)))));
        }
        classPool.classesAccept(new AttributeShrinker());
        if (this.configuration.applyMapping != null) {
            object3 = new WarningPrinter(System.err, this.configuration.warn);
            object2 = new MappingReader(this.configuration.applyMapping);
            object = new MultiMappingProcessor(new MappingProcessor[]{new MappingKeeper(classPool, (WarningPrinter)object3), new MappingKeeper(classPool2, null)});
            ((MappingReader)object2).pump((MappingProcessor)object);
            int n = ((WarningPrinter)object3).getWarningCount();
            if (n > 0) {
                System.err.println("Warning: there were " + n + " kept classes and class members that were remapped anyway.");
                System.err.println("         You should adapt your configuration or edit the mapping file.");
                if (!this.configuration.ignoreWarnings) {
                    System.err.println("         If you are sure this remapping won't hurt,");
                    System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                    throw new IOException("Please correct the above warnings first.");
                }
            }
        }
        object3 = this.configuration.classObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.classObfuscationDictionary, null) : null;
        object2 = this.configuration.packageObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.packageObfuscationDictionary, null) : null;
        classPool.classesAccept(new ClassObfuscator(classPool, (DictionaryNameFactory)object3, (DictionaryNameFactory)object2, this.configuration.useMixedCaseClassNames, this.configuration.keepPackageNames, this.configuration.flattenPackageHierarchy, this.configuration.repackageClasses, this.configuration.allowAccessModification));
        object = new SimpleNameFactory();
        if (this.configuration.obfuscationDictionary != null) {
            object = new DictionaryNameFactory(this.configuration.obfuscationDictionary, (NameFactory)object);
        }
        WarningPrinter warningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        HashMap hashMap = new HashMap();
        if (this.configuration.useUniqueClassMemberNames) {
            classPool.classesAccept(new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, hashMap)));
            classPool.classesAccept(new AllMemberVisitor(new MemberObfuscator(this.configuration.overloadAggressively, (NameFactory)object, hashMap)));
        } else {
            classPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, false, false, true, new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameCollector(this.configuration.overloadAggressively, hashMap)))), new ClassHierarchyTraveler(true, true, true, true, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, hashMap)))), new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberObfuscator(this.configuration.overloadAggressively, (NameFactory)object, hashMap))), new MapCleaner(hashMap)}));
            classPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, hashMap)), new ClassHierarchyTraveler(false, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, hashMap)))), new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberObfuscator(this.configuration.overloadAggressively, (NameFactory)object, hashMap))), new MapCleaner(hashMap)}));
        }
        SpecialNameFactory specialNameFactory = new SpecialNameFactory(new SimpleNameFactory());
        HashMap hashMap2 = new HashMap();
        classPool.classesAccept(new AllMemberVisitor(new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, hashMap2))));
        classPool2.classesAccept(new AllMemberVisitor(new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, hashMap2))));
        classPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, false, false, true, new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameCollector(this.configuration.overloadAggressively, hashMap)))), new ClassHierarchyTraveler(true, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, hashMap)))), new ClassHierarchyTraveler(true, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameConflictFixer(this.configuration.overloadAggressively, hashMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, hashMap2))))), new MapCleaner(hashMap)}));
        classPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, hashMap)), new ClassHierarchyTraveler(false, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, hashMap)))), new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameConflictFixer(this.configuration.overloadAggressively, hashMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, hashMap2)))), new MapCleaner(hashMap)}));
        int n = warningPrinter.getWarningCount();
        if (n > 0) {
            System.err.println("Warning: there were " + n + " conflicting class member name mappings.");
            System.err.println("         Your configuration may be inconsistent.");
            if (!this.configuration.ignoreWarnings) {
                System.err.println("         If you are sure the conflicts are harmless,");
                System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
        if (this.configuration.printMapping != null) {
            PrintStream printStream = this.isFile(this.configuration.printMapping) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printMapping))) : System.out;
            classPool.classesAcceptAlphabetically(new MappingPrinter(printStream));
            if (printStream != System.out) {
                printStream.close();
            }
        }
        classPool.classesAccept(new ClassRenamer());
        classPool2.classesAccept(new ClassRenamer());
        classPool.classesAccept(new ClassReferenceFixer(false));
        classPool2.classesAccept(new ClassReferenceFixer(false));
        classPool.classesAccept(new MemberReferenceFixer());
        if (this.configuration.repackageClasses != null && this.configuration.allowAccessModification) {
            classPool.classesAccept(new AllConstantVisitor(new AccessFixer()));
            classPool.classesAccept(new AllAttributeVisitor(new AllInnerClassesInfoVisitor(new InnerClassesAccessFixer())));
        }
        classPool.classesAccept(new AllMethodVisitor(new BridgeMethodFixer()));
        if (this.configuration.newSourceFileAttribute != null) {
            classPool.classesAccept(new SourceFileRenamer(this.configuration.newSourceFileAttribute));
        }
        classPool.classesAccept(new NameAndTypeUsageMarker());
        classPool.classesAccept(new NameAndTypeShrinker());
        classPool.classesAccept(new Utf8UsageMarker());
        classPool.classesAccept(new Utf8Shrinker());
    }

    private boolean isFile(File file) {
        return file.getPath().length() > 0;
    }
}

