/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.xpp3;

import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.xml.tools.SpecialValuesReplace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;

public class Attributes {
    private Map<String, String> attributes = new HashMap<String, String>();
    private Map<String, Set<String>> taggedAttributes = new HashMap<String, Set<String>>();

    public Attributes() {
    }

    public Attributes(String ... values) {
        for (int i = 0; i < values.length / 2; ++i) {
            this.set(values[i * 2 + 0], values[i * 2 + 1]);
        }
    }

    public Attributes(XmlPullParser xpp) {
        this.initAttributes(this.xppToMap(xpp));
    }

    public Attributes(Attributes source) {
        this.attributes = new HashMap<String, String>();
        this.attributes.putAll(source.attributes);
        this.taggedAttributes = new HashMap<String, Set<String>>();
        this.taggedAttributes.putAll(source.taggedAttributes);
    }

    public void translateSpecialValues(Map<String, ResourceBundle> resourceBundle, ScreenController screenController, Properties globalProperties) {
        for (Map.Entry<String, String> value : this.attributes.entrySet()) {
            this.attributes.put(value.getKey(), SpecialValuesReplace.replace(value.getValue(), resourceBundle, screenController, globalProperties));
        }
    }

    public boolean isSet(String name) {
        return this.attributes.get(name) != null;
    }

    public String get(String name) {
        return this.attributes.get(name);
    }

    public String getWithDefault(String name, String defaultValue) {
        String value = this.attributes.get(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Properties createProperties() {
        Properties props = new Properties();
        props.putAll(this.attributes);
        return props;
    }

    public boolean getAsBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        return defaultValue;
    }

    public Integer getAsInteger(String name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Integer getAsInteger(String name, int defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public Float getAsFloat(String name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        return Float.valueOf(value);
    }

    public Color getAsColor(String name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        return new Color(value);
    }

    public void set(String name, String value) {
        this.setAttribute(name, value);
    }

    public void merge(Attributes src) {
        Map<String, String> srcAttributes = src.attributes;
        Set<String> srcKeys = srcAttributes.keySet();
        for (String srcKey : srcKeys) {
            if (this.attributes.containsKey(srcKey)) continue;
            this.attributes.put(srcKey, srcAttributes.get(srcKey));
            for (Map.Entry<String, Set<String>> tag : src.taggedAttributes.entrySet()) {
                if (!tag.getValue().contains(srcKey)) continue;
                Set<String> attribForTag = this.taggedAttributes.get(tag.getKey());
                if (attribForTag == null) {
                    attribForTag = new HashSet<String>();
                    this.taggedAttributes.put(tag.getKey(), attribForTag);
                }
                attribForTag.add(srcKey);
            }
        }
    }

    public void mergeAndTag(Attributes src, String tag) {
        Map<String, String> srcAttributes = src.attributes;
        Set<String> srcKeys = srcAttributes.keySet();
        for (String srcKey : srcKeys) {
            String value = srcAttributes.get(srcKey);
            if (this.attributes.containsKey(srcKey)) continue;
            this.setAttribute(srcKey, value);
            this.tagAttribute(srcKey, tag);
        }
    }

    private void tagAttribute(String srcKey, String tag) {
        Set<String> attribForTag = this.taggedAttributes.get(tag);
        if (attribForTag == null) {
            attribForTag = new HashSet<String>();
            this.taggedAttributes.put(tag, attribForTag);
        }
        attribForTag.add(srcKey);
    }

    public void refreshFromAttributes(Attributes src) {
        Map<String, String> srcAttributes = src.attributes;
        Set<String> srcKeys = srcAttributes.keySet();
        for (String srcKey : srcKeys) {
            String srcValue = srcAttributes.get(srcKey);
            if (srcValue.equals("")) {
                this.attributes.remove(srcKey);
                continue;
            }
            this.attributes.put(srcKey, srcAttributes.get(srcKey));
        }
    }

    private Map<String, String> xppToMap(XmlPullParser xpp) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String key = xpp.getAttributeName(i);
            String value = xpp.getAttributeValue(i);
            result.put(key, value);
        }
        return result;
    }

    private void initAttributes(Map<String, String> source) {
        this.attributes = new HashMap<String, String>();
        Set<Map.Entry<String, String>> entries = source.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.setAttribute(key, value);
        }
    }

    private void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String toString() {
        String result = "";
        boolean first = true;
        for (String key : this.attributes.keySet()) {
            if (!first) {
                result = result + ", ";
            }
            if (first) {
                first = false;
            }
            result = result + key + " => " + this.attributes.get(key);
            String tag = this.resolveTag(key);
            if (tag == null) continue;
            result = result + " {" + tag + "}";
        }
        return result;
    }

    private String resolveTag(String key) {
        for (Map.Entry<String, Set<String>> tag : this.taggedAttributes.entrySet()) {
            if (!tag.getValue().contains(key)) continue;
            return tag.getKey();
        }
        return null;
    }

    public List<Entry> extractParameters() {
        ArrayList<Entry> parameters = new ArrayList<Entry>();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!this.isParameterDefinition(value)) continue;
            parameters.add(new Entry(value.replaceFirst("\\$", ""), key));
        }
        return parameters;
    }

    private boolean isParameterDefinition(String value) {
        return !value.startsWith("${") && value.startsWith("$");
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void remove(String key) {
        this.attributes.remove(key);
    }

    public String getWithTag(String name, String tag) {
        Set<String> attributesWithTag = this.taggedAttributes.get(tag);
        if (attributesWithTag == null) {
            return null;
        }
        if (!attributesWithTag.contains(name)) {
            return null;
        }
        return this.attributes.get(name);
    }

    public void resolveParameters(Attributes attributes) {
        List<Entry> entrySet = this.getParameterSet();
        for (Entry entry : entrySet) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (attributes.isSet(key)) {
                this.set(value, attributes.get(key));
                continue;
            }
            if (this.isSet(key) && !this.isParameterDefinition(this.get(key))) {
                this.set(value, this.get(key));
                continue;
            }
            this.remove(value);
        }
    }

    List<Entry> getParameterSet() {
        return this.extractParameters();
    }

    public void removeWithTag(String tag) {
        Set<String> tagged = this.taggedAttributes.get(tag);
        if (tagged != null) {
            for (String key : tagged) {
                this.remove(key);
            }
        }
    }

    public class Entry {
        private String key;
        private String value;

        private Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

