/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools;

import java.util.regex.Pattern;

public class ColorValidator {
    private static final Pattern colorPattern = Pattern.compile("#\\p{XDigit}{3,8}");

    public boolean isValid(String toCheck) {
        if (toCheck == null) {
            return false;
        }
        int digits = toCheck.length() - 1;
        if (digits == 3 || digits == 4 || digits == 6 || digits == 8) {
            return this.checkSyntax(toCheck);
        }
        return false;
    }

    public boolean isShortMode(String toCheck) {
        return this.isColor(toCheck, 4);
    }

    public boolean isShortModeWithoutAlpha(String toCheck) {
        return this.isColor(toCheck, 3);
    }

    public boolean isLongMode(String toCheck) {
        return this.isColor(toCheck, 8);
    }

    public boolean isLongModeWithoutAlpha(String toCheck) {
        return this.isColor(toCheck, 6);
    }

    private boolean isColor(String toCheck, int components) {
        return toCheck != null && toCheck.length() == components + 1 && this.checkSyntax(toCheck);
    }

    private boolean checkSyntax(String toCheck) {
        return colorPattern.matcher(toCheck).matches();
    }
}

