/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.NiftyMouse;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.time.TimeProvider;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;

public class NiftyMouseImpl
implements NiftyMouse {
    private static Logger log = Logger.getLogger(NiftyMouseImpl.class.getName());
    private RenderDevice renderDevice;
    private InputSystem inputSystem;
    private Map<String, MouseCursor> registeredMouseCursors = new Hashtable<String, MouseCursor>();
    private String currentId;
    private int mouseX;
    private int mouseY;
    private TimeProvider timeProvider;
    private long lastMouseMoveEventTime;

    public NiftyMouseImpl(RenderDevice renderDevice, InputSystem inputSystem, TimeProvider timeProvider) {
        this.renderDevice = renderDevice;
        this.inputSystem = inputSystem;
        this.timeProvider = timeProvider;
        this.lastMouseMoveEventTime = timeProvider.getMsTime();
    }

    @Override
    public void registerMouseCursor(String id, String filename, int hotspotX, int hotspotY) throws IOException {
        MouseCursor mouseCursor = this.renderDevice.createMouseCursor(filename, hotspotX, hotspotY);
        if (mouseCursor == null) {
            log.warning("Your RenderDevice does not support the createMouseCursor() method. Mouse cursors can't be changed.");
            return;
        }
        this.registeredMouseCursors.put(id, mouseCursor);
    }

    @Override
    public String getCurrentId() {
        return this.currentId;
    }

    @Override
    public void unregisterAll() {
        for (MouseCursor cursor : this.registeredMouseCursors.values()) {
            cursor.dispose();
        }
        this.registeredMouseCursors.clear();
    }

    @Override
    public void resetMouseCursor() {
        this.currentId = null;
        this.renderDevice.disableMouseCursor();
    }

    @Override
    public void enableMouseCursor(String id) {
        if (id == null) {
            this.resetMouseCursor();
            return;
        }
        if (id.equals(this.currentId)) {
            return;
        }
        this.renderDevice.enableMouseCursor(this.registeredMouseCursors.get(id));
        this.currentId = id;
    }

    @Override
    public void setMousePosition(int x, int y) {
        this.inputSystem.setMousePosition(x, y);
        this.updateMousePosition(x, y);
    }

    @Override
    public int getX() {
        return this.mouseX;
    }

    @Override
    public int getY() {
        return this.mouseY;
    }

    @Override
    public long getNoMouseMovementTime() {
        long now = this.timeProvider.getMsTime();
        return now - this.lastMouseMoveEventTime;
    }

    public void updateMousePosition(int x, int y) {
        if (this.positionChanged(x, y)) {
            this.lastMouseMoveEventTime = this.timeProvider.getMsTime();
        }
        this.mouseX = x;
        this.mouseY = y;
    }

    private boolean positionChanged(int x, int y) {
        return x != this.mouseX || y != this.mouseY;
    }
}

