/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.loaderv2.types.ControlDefinitionType;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.helper.NullElementRendererCreator;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public class ControlType
extends ElementType {
    private static Logger log = Logger.getLogger(ControlType.class.getName());

    public ControlType() {
    }

    public ControlType(ControlType src) {
        super(src);
    }

    public ControlType(Attributes attributes) {
        super(attributes);
    }

    @Override
    public ElementType copy() {
        return new ControlType(this);
    }

    @Override
    protected void makeFlat() {
        super.makeFlat();
        this.setTagName("<control>");
        this.setElementRendererCreator(new NullElementRendererCreator());
    }

    private String getType() {
        String type = this.getAttributes().get("type");
        if (type != null) {
            return type;
        }
        return this.getAttributes().get("name");
    }

    @Override
    void internalApplyControl(Nifty nifty) {
        ControlDefinitionType controlDefinition = nifty.resolveControlDefinition(this.getType());
        if (controlDefinition == null) {
            log.warning("controlDefinition [" + this.getType() + "] missing.");
            return;
        }
        ArrayList<ElementType> childCopy = new ArrayList<ElementType>();
        childCopy.addAll(this.elements);
        this.mergeFromElementType(controlDefinition);
        String childRootId = this.getAttributes().get("childRootId");
        if (childRootId != null && !this.addChildrenToChildRoot(this, childRootId, childCopy)) {
            log.warning("childRootId [" + childRootId + "] could not be found in any childs of [" + this + "]");
        }
    }

    @Override
    void makeFlatControlsInternal() {
        if (!this.elements.isEmpty()) {
            this.mergeFromElementType((ElementType)this.elements.iterator().next());
        }
        this.resolveIds(this, this.getAttributes().get("id"));
    }

    private void resolveIds(ElementType parent, String grantParentId) {
        for (ElementType element : parent.elements) {
            String id = element.getAttributes().get("id");
            if (id != null && id.startsWith("#")) {
                String parentId = parent.getAttributes().get("id");
                if (parentId != null) {
                    element.getAttributes().set("id", parentId + id);
                } else if (grantParentId != null) {
                    element.getAttributes().set("id", grantParentId + id);
                }
            }
            this.resolveIds(element, grantParentId);
        }
    }

    private boolean addChildrenToChildRoot(ElementType elementType, String childRootId, Collection<ElementType> children) {
        if (children.isEmpty()) {
            return true;
        }
        for (ElementType element : elementType.elements) {
            if (childRootId.equals(element.getAttributes().get("id"))) {
                element.elements.clear();
                element.elements.addAll(children);
                return true;
            }
            if (!this.addChildrenToChildRoot(element, childRootId, children)) continue;
            return true;
        }
        return false;
    }
}

